/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.drive;

import de.joergjahnke.c64.core.C1541;
import de.joergjahnke.c64.core.C64FileEntry;
import de.joergjahnke.c64.drive.DriveHandler;

public abstract class DiskDriveHandler
extends DriveHandler {
    public static final int BYTES_PER_SECTOR = 256;
    protected static final int FIRST_TRACK = 1;
    protected static final int LAST_TRACK = 40;
    protected static final int DIRECTORY_TRACK = 18;
    protected static final int BAM_SECTOR = 0;
    protected static final int FIRST_DIRECTORY_SECTOR = 1;
    protected static final int DISK_LABEL_INDEX = 144;
    protected static final int DISK_LABEL_LENGTH = 16;
    protected static final int FIRST_BAM_ENTRY_INDEX = 4;
    protected static final int BAM_LENGTH = 140;
    protected static final int BAM_ENTRY_LENGTH = 4;
    protected static final int FIRST_USABLE_BYTE_INDEX = 2;
    protected static final int DIRECTORY_ENTRY_LENGTH = 32;
    protected static final int USABLE_BYTES_PER_SECTOR = 254;
    public static final int[] SECTORS_PER_TRACK = new int[]{21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 19, 19, 19, 19, 19, 19, 19, 18, 18, 18, 18, 18, 18, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
    protected int currentTrack;
    protected int currentSector;

    public int getCurrentTrack() {
        return this.currentTrack;
    }

    public int getCurrentSector() {
        return this.currentSector;
    }

    protected final C64FileEntry createFileEntry(byte[] dirEntryBytes) {
        int fileType = dirEntryBytes[2] & 0xFF;
        int firstTrack = dirEntryBytes[3] & 0xFF;
        int firstSector = dirEntryBytes[4] & 0xFF;
        String filename = this.readC64Filename(dirEntryBytes, 5, 16);
        int relTrack = dirEntryBytes[21] & 0xFF;
        int relSector = dirEntryBytes[22] & 0xFF;
        int relLength = dirEntryBytes[23] & 0xFF;
        int fileLength = (dirEntryBytes[30] & 0xFF) + (dirEntryBytes[31] & 0xFF) * 256;
        return new C64FileEntry(filename, fileType, fileLength, firstTrack, firstSector, relTrack, relSector, relLength);
    }

    public void gotoBlock(int track, int sector) {
        this.currentTrack = track;
        this.currentSector = sector;
    }

    public void writeBlock(byte[] bytes) {
        if (bytes.length != 256) {
            throw new IllegalArgumentException("Block must contain 256 bytes to write!");
        }
        this.writeBlock(bytes, 256);
    }

    public byte[] readBlock() {
        this.setChanged(true);
        this.notifyObservers(C1541.READING);
        this.setChanged(true);
        this.notifyObservers(this.getCurrentTrack() + "," + this.getCurrentSector());
        return this.readBlockImpl();
    }

    public void writeBlock(byte[] bytes, int numBytes) {
        this.setChanged(true);
        this.notifyObservers(C1541.WRITING);
        this.setChanged(true);
        this.notifyObservers(this.getCurrentTrack() + "," + this.getCurrentSector());
        this.writeBlockImpl(bytes, numBytes);
    }

    protected abstract byte[] readBlockImpl();

    protected abstract void writeBlockImpl(byte[] var1, int var2);

    public abstract int[] getDiskID();
}

