/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.jme;

import de.joergjahnke.common.jme.OrientationSensitiveCanvas;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;

public class OrientationSensitiveCanvasHelper {
    private Connection con = null;
    private final OrientationSensitiveCanvas canvas;

    public OrientationSensitiveCanvasHelper(OrientationSensitiveCanvas canvas) {
        this.canvas = canvas;
    }

    public void activateAccelerometer() {
        try {
            SensorInfo[] si = SensorManager.findSensors((String)"acceleration", (String)"user");
            String url = si[0].getUrl();
            this.con = Connector.open((String)url);
            SensorConnection sensor = (SensorConnection)this.con;
            sensor.setDataListener(new DataListener(){

                public void dataReceived(SensorConnection sensor, Data[] data, boolean isDataLost) {
                    try {
                        double x = 0.0;
                        double y = 0.0;
                        double z = 0.0;
                        switch (data[0].getChannelInfo().getDataType()) {
                            case 2: {
                                x = data[0].getIntValues()[0];
                                break;
                            }
                            case 1: {
                                x = data[0].getDoubleValues()[0];
                            }
                        }
                        switch (data[1].getChannelInfo().getDataType()) {
                            case 2: {
                                y = data[1].getIntValues()[0];
                                break;
                            }
                            case 1: {
                                y = data[1].getDoubleValues()[0];
                            }
                        }
                        switch (data[2].getChannelInfo().getDataType()) {
                            case 2: {
                                z = data[2].getIntValues()[0];
                                break;
                            }
                            case 1: {
                                z = data[2].getDoubleValues()[0];
                            }
                        }
                        if (OrientationSensitiveCanvasHelper.this.canvas.isAutoChangeOrientation()) {
                            int oldTransform = ((OrientationSensitiveCanvasHelper)OrientationSensitiveCanvasHelper.this).canvas.transform;
                            if (x < -500.0) {
                                ((OrientationSensitiveCanvasHelper)OrientationSensitiveCanvasHelper.this).canvas.transform = 6;
                            } else if (x > 500.0) {
                                ((OrientationSensitiveCanvasHelper)OrientationSensitiveCanvasHelper.this).canvas.transform = 5;
                            } else if (y < -500.0) {
                                ((OrientationSensitiveCanvasHelper)OrientationSensitiveCanvasHelper.this).canvas.transform = 3;
                            } else if (y > 500.0) {
                                ((OrientationSensitiveCanvasHelper)OrientationSensitiveCanvasHelper.this).canvas.transform = 0;
                            }
                            if (oldTransform != ((OrientationSensitiveCanvasHelper)OrientationSensitiveCanvasHelper.this).canvas.transform) {
                                OrientationSensitiveCanvasHelper.this.canvas.onDeviceRotated();
                            }
                        }
                        if (OrientationSensitiveCanvasHelper.this.canvas.isUseAccelerometer()) {
                            OrientationSensitiveCanvasHelper.this.canvas.onAccelerometerChange(x, y, z);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }, 1);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    public void deactivateAccelerometer() {
        try {
            ((SensorConnection)this.con).removeDataListener();
            this.con.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean supportsSensorAPI() {
        return null != System.getProperty("microedition.sensor.version");
    }

    public static boolean supportsAccelerometer() {
        if (OrientationSensitiveCanvasHelper.supportsSensorAPI()) {
            try {
                SensorInfo[] si = SensorManager.findSensors((String)"acceleration", (String)"user");
                return si[0].getChannelInfos().length == 3;
            }
            catch (Throwable t) {
                return false;
            }
        }
        return false;
    }
}

