/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.C64;
import de.joergjahnke.c64.core.CPU6502;
import de.joergjahnke.c64.core.IOChip;
import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import de.joergjahnke.common.util.DefaultObservable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class CIA6526
extends DefaultObservable
implements IOChip,
Serializable {
    private static final boolean TIMER_DEBUG = false;
    private static final int UPDATE_CYCLES = 37;
    private static final int START_DELAY = 2;
    private static final int RESTART_DELAY = 1;
    public static final int PRA = 0;
    public static final int PRB = 1;
    public static final int DDRA = 2;
    public static final int DDRB = 3;
    private static final int TIMER_A_LOW = 4;
    private static final int TIMER_A_HIGH = 5;
    private static final int TIMER_B_LOW = 6;
    private static final int TIMER_B_HIGH = 7;
    private static final int TIMEOFDAY_TEN = 8;
    private static final int TIMEOFDAY_SEC = 9;
    private static final int TIMEOFDAY_MIN = 10;
    private static final int TIMEOFDAY_HRS = 11;
    private static final int SDR = 12;
    private static final int ICR = 13;
    private static final int CRA = 14;
    private static final int CRB = 15;
    private final Timer timerA = new Timer(this.getClass().getName() + " (Timer A)");
    private final Timer timerB = new Timer(this.getClass().getName() + " (Timer B)");
    private int icr;
    private int crb = 0;
    protected int irqMask = 0;
    private int alarmTen = 0;
    private int alarmSec = 0;
    private int alarmMin = 0;
    private int alarmHrs = 0;
    private int todTen = 0;
    private int todSec = 0;
    private int todMin = 0;
    private int todHrs = 0;
    private long nextDayTimeUpdate = 0L;
    private long nextUpdate = 0L;
    private int offset;
    protected final C64 c64;
    protected final CPU6502 cpu;
    protected final int[] registers = new int[16];

    public CIA6526(C64 c64, int offset) {
        this.c64 = c64;
        this.cpu = c64.getCPU();
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void reset() {
        this.icr = 0;
        this.irqMask = 0;
        this.crb = 0;
        this.alarmHrs = 0;
        this.alarmMin = 0;
        this.alarmSec = 0;
        this.alarmTen = 0;
        this.timerA.reset();
        this.timerB.reset();
    }

    protected void setInterrupt(int bit) {
        this.icr |= bit;
        if ((this.irqMask & bit) != 0) {
            this.icr |= 0x80;
            this.triggerInterrupt();
        }
    }

    public int readRegister(int register) {
        switch (register) {
            case 0: {
                return this.registers[register] | ~this.registers[2];
            }
            case 1: {
                return this.registers[register] | ~this.registers[3];
            }
            case 4: {
                return (int)((this.timerA.isActive ? Math.max(0L, this.timerA.nextTrigger - this.cpu.getCycles()) : (long)this.timerA.timeLeft) & 0xFFL);
            }
            case 5: {
                return (int)((this.timerA.isActive ? Math.max(0L, this.timerA.nextTrigger - this.cpu.getCycles()) : (long)this.timerA.timeLeft) >> 8);
            }
            case 6: {
                return (int)((this.timerB.isActive ? Math.max(0L, this.timerB.nextTrigger - this.cpu.getCycles()) : (long)this.timerB.timeLeft) & 0xFFL);
            }
            case 7: {
                return (int)((this.timerB.isActive ? Math.max(0L, this.timerB.nextTrigger - this.cpu.getCycles()) : (long)this.timerB.timeLeft) >> 8);
            }
            case 8: {
                return this.todTen;
            }
            case 9: {
                return this.todSec;
            }
            case 10: {
                return this.todMin;
            }
            case 11: {
                return this.todHrs;
            }
            case 13: {
                int result = this.icr;
                this.icr = 0;
                this.clearInterrupt();
                return result;
            }
        }
        return this.registers[register];
    }

    public void writeRegister(int register, int data) {
        switch (register) {
            case 0: {
                this.registers[register] = this.registers[register] & ~this.registers[2] | data & this.registers[2];
                break;
            }
            case 1: {
                this.registers[register] = this.registers[register] & ~this.registers[3] | data & this.registers[3];
                break;
            }
            case 4: {
                this.timerA.latch &= 0xFF00;
                this.timerA.latch |= data;
                break;
            }
            case 5: {
                this.timerA.latch &= 0xFF;
                this.timerA.latch |= data << 8;
                break;
            }
            case 6: {
                this.timerB.latch &= 0xFF00;
                this.timerB.latch |= data;
                break;
            }
            case 7: {
                this.timerB.latch &= 0xFF;
                this.timerB.latch |= data << 8;
                break;
            }
            case 8: {
                if ((this.crb & 0x80) != 0) {
                    this.alarmTen = data;
                    break;
                }
                this.todTen = data;
                break;
            }
            case 9: {
                if ((this.crb & 0x80) != 0) {
                    this.alarmSec = data;
                    break;
                }
                this.todSec = data;
                break;
            }
            case 10: {
                if ((this.crb & 0x80) != 0) {
                    this.alarmMin = data;
                    break;
                }
                this.todMin = data;
                break;
            }
            case 11: {
                if ((this.crb & 0x80) != 0) {
                    this.alarmHrs = data;
                    break;
                }
                this.todHrs = data;
                break;
            }
            case 12: {
                this.setInterrupt(8);
                this.registers[register] = data;
                break;
            }
            case 13: {
                boolean doesTriggerIRQs;
                boolean bl = doesTriggerIRQs = (data & 0x80) != 0;
                this.irqMask = doesTriggerIRQs ? (this.irqMask |= data & 0x7F) : (this.irqMask &= ~data);
                this.setInterrupt(this.irqMask & this.icr);
                break;
            }
            case 14: {
                this.timerA.applyControlRegister(data);
                this.registers[register] = data;
                break;
            }
            case 15: {
                this.crb = data;
                this.timerB.applyControlRegister(data);
                this.registers[register] = data;
                break;
            }
            default: {
                this.registers[register] = data;
            }
        }
    }

    public final long getNextUpdate() {
        return this.nextUpdate;
    }

    public void update(long cycles) {
        this.nextUpdate += 37L;
        if (this.timerA.isActive && cycles >= this.timerA.nextTrigger) {
            this.setInterrupt(1);
            if (!this.timerA.isOneShot) {
                this.timerA.nextTrigger += (long)(this.timerA.latch + 1);
            } else {
                this.timerA.isActive = false;
                this.registers[14] = this.registers[14] & 0xFE;
            }
        }
        if (this.timerB.isActive && cycles >= this.timerB.nextTrigger) {
            this.setInterrupt(2);
            if (!this.timerB.isOneShot) {
                this.timerB.nextTrigger = (this.crb & 0x60) == 64 ? (this.timerB.nextTrigger += (long)(this.timerB.latch * this.timerA.latch)) : (this.timerB.nextTrigger += (long)this.timerB.latch);
                ++this.timerB.nextTrigger;
            } else {
                this.timerB.isActive = false;
                this.crb = this.registers[15] = this.registers[15] & 0xFE;
            }
        }
        if (cycles >= this.nextDayTimeUpdate) {
            this.nextDayTimeUpdate += 100000L;
            this.todTen &= 0xF;
            ++this.todTen;
            if (this.todTen > 9) {
                this.todTen %= 10;
                this.todSec &= 0x7F;
                if ((++this.todSec & 0xF) > 9) {
                    this.todSec += 6;
                }
                if (this.todSec >= 96) {
                    this.todSec %= 96;
                    this.todMin &= 0x7F;
                    if ((++this.todMin & 0xF) > 9) {
                        this.todMin += 6;
                    }
                    if (this.todMin >= 96) {
                        this.todMin %= 96;
                        this.todHrs &= 0x9F;
                        if ((++this.todHrs & 0xF) > 9) {
                            this.todHrs += 6;
                            if ((this.todHrs & 0x7F) >= 18) {
                                this.todHrs ^= 0x80;
                                this.todHrs &= 0x80;
                            }
                        }
                    }
                }
            }
            if (this.alarmTen == this.todTen && this.alarmSec == this.todSec && this.alarmMin == this.todMin && this.alarmHrs == this.todHrs) {
                this.setInterrupt(4);
            }
        }
        if (this.timerA.isActive && this.timerA.nextTrigger < this.nextUpdate) {
            this.nextUpdate = this.timerA.nextTrigger;
        }
        if (this.timerB.isActive && this.timerB.nextTrigger < this.nextUpdate) {
            this.nextUpdate = this.timerB.nextTrigger;
        }
        if (this.nextDayTimeUpdate < this.nextUpdate) {
            this.nextUpdate = this.nextDayTimeUpdate;
        }
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(this.alarmHrs);
        out.writeInt(this.alarmMin);
        out.writeInt(this.alarmSec);
        out.writeInt(this.alarmTen);
        out.writeInt(this.crb);
        out.writeInt(this.icr);
        out.writeInt(this.irqMask);
        out.writeLong(this.nextDayTimeUpdate);
        out.writeLong(this.nextUpdate);
        out.writeInt(this.offset);
        out.writeInt(this.todHrs);
        out.writeInt(this.todMin);
        out.writeInt(this.todSec);
        out.writeInt(this.todTen);
        SerializationUtils.serialize(out, this.registers);
        this.timerA.serialize(out);
        this.timerB.serialize(out);
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.alarmHrs = in.readInt();
        this.alarmMin = in.readInt();
        this.alarmSec = in.readInt();
        this.alarmTen = in.readInt();
        this.crb = in.readInt();
        this.icr = in.readInt();
        this.irqMask = in.readInt();
        this.nextDayTimeUpdate = in.readLong();
        this.nextUpdate = in.readLong();
        this.offset = in.readInt();
        this.todHrs = in.readInt();
        this.todMin = in.readInt();
        this.todSec = in.readInt();
        this.todTen = in.readInt();
        SerializationUtils.deserialize(in, this.registers);
        this.timerA.deserialize(in);
        this.timerB.deserialize(in);
    }

    protected abstract void clearInterrupt();

    protected abstract void triggerInterrupt();

    class Timer
    implements Serializable {
        private final String name;
        public boolean isActive = false;
        public int timeLeft = 0;
        public long nextTrigger = 0L;
        public int latch = 0;
        public boolean isOneShot = false;
        public boolean isSignalUnderflowOnPB = false;
        public boolean isPBSignalToggle = false;

        public Timer(String name) {
            this.name = name;
        }

        public void reset() {
            this.isActive = false;
        }

        public void start() {
            this.isActive = true;
            this.nextTrigger = CIA6526.this.cpu.getCycles() + (long)this.latch + 2L;
        }

        public void stop() {
            this.isActive = false;
            this.timeLeft = Math.max(0, (int)(this.nextTrigger - CIA6526.this.cpu.getCycles()));
        }

        public void applyControlRegister(int data) {
            boolean bl = this.isOneShot = (data & 8) > 0;
            if ((data & 1) != 0) {
                this.start();
            } else {
                this.stop();
            }
            this.isSignalUnderflowOnPB = (data & 2) != 0;
            boolean bl2 = this.isPBSignalToggle = (data & 4) != 0;
            if ((data & 0x10) != 0) {
                this.nextTrigger = CIA6526.this.cpu.getCycles() + (long)this.latch + 2L;
            }
        }

        public void serialize(DataOutputStream out) throws IOException {
            out.writeBoolean(this.isActive);
            out.writeBoolean(this.isOneShot);
            out.writeBoolean(this.isPBSignalToggle);
            out.writeBoolean(this.isSignalUnderflowOnPB);
            out.writeInt(this.latch);
            out.writeInt(this.timeLeft);
            out.writeLong(this.nextTrigger);
        }

        public void deserialize(DataInputStream in) throws IOException {
            this.isActive = in.readBoolean();
            this.isOneShot = in.readBoolean();
            this.isPBSignalToggle = in.readBoolean();
            this.isSignalUnderflowOnPB = in.readBoolean();
            this.latch = in.readInt();
            this.timeLeft = in.readInt();
            this.nextTrigger = in.readLong();
        }
    }
}

