/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.smalldisplays;

import de.joergjahnke.c64.core.C64;
import de.joergjahnke.c64.smalldisplays.ScalableVIC6569;
import de.joergjahnke.common.ui.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SmoothingScalableVIC6569
extends ScalableVIC6569 {
    protected boolean savedPaintLine;

    public SmoothingScalableVIC6569(C64 c64, double scaling) {
        super(c64, scaling);
    }

    public void initScreenMemory() {
        this.pixels = new int[112000];
        this.scaledPixels = new int[this.getBorderWidth() * this.getBorderHeight()];
    }

    protected void setNextPixel(int color) {
        if (this.isPaintLine && (this.nextScaledPixel + this.memInc) % 1024 < this.nextScaledPixel % 1024) {
            int abovePixelIndex = this.nextPixel - 400;
            int fracX = 1024 - this.nextScaledPixel % 1024;
            int fracY = 1024 - this.yFraction % 1024;
            int fraction22 = fracX * fracY >> 10;
            int fraction21 = (1024 - fracX) * fracY >> 10;
            int fraction12 = fracX * (1024 - fracY) >> 10;
            int fraction11 = (1024 - fracX) * (1024 - fracY) >> 10;
            this.scaledPixels[this.nextScaledPixel >> 10] = Color.mix(this.pixels[abovePixelIndex - 1], fraction11, this.pixels[abovePixelIndex], fraction12, this.pixels[this.nextPixel - 1], fraction21, color, fraction22);
        }
        if (color != this.pixels[this.nextPixel]) {
            this.lastPainted[this.paintY + 1][this.hashCol] = -1;
        }
        this.pixels[this.nextPixel] = color;
        this.skipPixels(1);
    }

    protected void saveCurrentPixelPosition() {
        super.saveCurrentPixelPosition();
        this.savedPaintLine = this.isPaintLine;
    }

    protected void restoreSavedPixelPosition() {
        this.isPaintLine = this.savedPaintLine;
        super.restoreSavedPixelPosition();
    }

    public void reset() {
        super.reset();
    }

    public void serialize(DataOutputStream out) throws IOException {
        super.serialize(out);
        out.writeBoolean(this.savedPaintLine);
    }

    public void deserialize(DataInputStream in) throws IOException {
        super.deserialize(in);
        this.savedPaintLine = in.readBoolean();
    }
}

