/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.C64;
import de.joergjahnke.c64.core.CIA6526;
import de.joergjahnke.c64.core.IECBus;
import java.util.Vector;

public class CIA6526_2
extends CIA6526 {
    public static final int SB_ATN_OUT = 8;
    public static final int SB_CLK_OUT = 16;
    public static final int SB_DATA_OUT = 32;
    public static final int SB_CLK_IN = 64;
    public static final int SB_DATA_IN = 128;
    public static final Integer ADDRESS_PRA = new Integer(56576);
    private final Vector signals = new Vector();

    public CIA6526_2(C64 c64) {
        super(c64, 56576);
        this.initDataDirectionRegisters();
        for (int i = 0; i < this.registers.length; ++i) {
            this.signals.addElement(new Integer(this.getOffset() + i));
        }
    }

    private void initDataDirectionRegisters() {
        this.registers[2] = 63;
        this.registers[3] = 0;
    }

    public void reset() {
        super.reset();
        this.initDataDirectionRegisters();
    }

    public int readRegister(int register) {
        switch (register) {
            case 0: {
                return super.readRegister(register) & 0x3F | (this.c64.getIECBus().getSignal(IECBus.CLK) ? 0 : 64) | (this.c64.getIECBus().getSignal(IECBus.DATA) ? 0 : 128);
            }
        }
        return super.readRegister(register);
    }

    public void writeRegister(int register, int data) {
        super.writeRegister(register, data);
        switch (register) {
            case 0: {
                this.c64.getIECBus().setSignal(this.c64, IECBus.CLK, (data & 0x10) != 0);
                this.c64.getIECBus().setSignal(this.c64, IECBus.DATA, (data & 0x20) != 0);
                this.c64.getIECBus().setSignal(this.c64, IECBus.ATN, (data & 8) != 0);
                this.setChanged(true);
                this.notifyObservers(this.signals.elementAt(register));
                break;
            }
        }
    }

    protected final void clearInterrupt() {
        this.cpu.setNMI(this, false);
    }

    protected final void triggerInterrupt() {
        this.cpu.setNMI(this, true);
    }
}

