/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.C1541;
import de.joergjahnke.c64.core.CPU6502;
import de.joergjahnke.c64.core.EmulatedDevice;
import de.joergjahnke.c64.core.IOChip;
import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class VIA6522
implements IOChip,
Serializable {
    private static final boolean DEBUG = false;
    private static final int UPDATE_CYCLES = 20;
    public static final int PRB = 0;
    public static final int PRA = 1;
    public static final int DDRB = 2;
    public static final int DDRA = 3;
    public static final int TIMER_A_LOW = 4;
    public static final int TIMER_A_HIGH = 5;
    public static final int TIMER_A_LATCH_LOW = 6;
    public static final int TIMER_A_LATCH_HIGH = 7;
    public static final int TIMER_B_LOW = 8;
    public static final int TIMER_B_HIGH = 9;
    public static final int SHIFT = 10;
    public static final int ACR = 11;
    public static final int PCR = 12;
    public static final int IFR = 13;
    public static final int IER = 14;
    public static final int PRA2 = 15;
    protected static final int IRQ_TRANSITION_CA2 = 1;
    protected static final int IRQ_TRANSITION_CA1 = 2;
    protected static final int IRQ_SHIFT_COMPLETION = 4;
    protected static final int IRQ_TRANSITION_CB2 = 8;
    protected static final int IRQ_TRANSITION_CB1 = 16;
    protected static final int IRQ_TIMEOUT_TIMER_B = 32;
    protected static final int IRQ_TIMEOUT_TIMER_A = 64;
    protected long nextUpdate = 0L;
    protected long lastUpdate = 0L;
    protected final C1541 c1541;
    protected final CPU6502 cpu;
    protected final int[] registers = new int[16];

    public VIA6522(C1541 c1541) {
        this.c1541 = c1541;
        this.cpu = c1541.getCPU();
    }

    public void reset() {
        for (int i = 0; i < this.registers.length; ++i) {
            this.registers[i] = 0;
        }
        this.lastUpdate = this.cpu.getCycles();
    }

    protected void checkInterrupts() {
        if ((this.registers[14] & this.registers[13]) != 0) {
            this.triggerInterrupt();
        } else {
            this.clearInterrupt();
        }
    }

    protected void clearInterrupt() {
        this.cpu.setIRQ(this, false);
    }

    protected void triggerInterrupt() {
        this.cpu.setIRQ(this, true);
    }

    public void synchronizeWithDevice(EmulatedDevice device) {
        this.nextUpdate = this.lastUpdate = device.getCPU().getCycles();
    }

    public int readRegister(int register) {
        switch (register) {
            case 1: {
                this.registers[13] = this.registers[13] & 0xFC;
                this.checkInterrupts();
                return this.registers[register] | ~this.registers[3];
            }
            case 0: {
                this.registers[13] = this.registers[13] & 0xE7;
                this.checkInterrupts();
                return this.registers[register] | ~this.registers[2];
            }
            case 4: {
                this.registers[13] = this.registers[13] & 0xBF;
                this.checkInterrupts();
                return this.registers[register];
            }
            case 8: {
                this.registers[13] = this.registers[13] & 0xDF;
                this.checkInterrupts();
                return this.registers[register];
            }
            case 10: {
                this.registers[13] = this.registers[13] & 0xFB;
                this.checkInterrupts();
                return this.registers[register];
            }
            case 13: {
                return this.registers[13] | ((this.registers[13] & this.registers[14]) != 0 ? 128 : 0);
            }
            case 14: {
                return this.registers[14] | 0x80;
            }
            case 15: {
                return this.registers[1];
            }
        }
        return this.registers[register];
    }

    public void writeRegister(int register, int data) {
        switch (register) {
            case 1: {
                this.registers[13] = this.registers[13] & 0xFC;
                this.registers[register] = this.registers[register] & ~this.registers[3] | data & this.registers[3];
                this.checkInterrupts();
                break;
            }
            case 0: {
                this.registers[13] = this.registers[13] & 0xE7;
                this.registers[register] = this.registers[register] & ~this.registers[2] | data & this.registers[2];
                break;
            }
            case 4: {
                this.registers[6] = data;
                break;
            }
            case 5: {
                this.registers[register] = this.registers[7] = data;
                this.registers[4] = this.registers[6];
                this.registers[13] = this.registers[13] & 0xBF;
                this.checkInterrupts();
                break;
            }
            case 9: {
                this.registers[register] = data;
                this.registers[13] = this.registers[13] & 0xDF;
                this.checkInterrupts();
                break;
            }
            case 10: {
                this.registers[register] = data;
                this.registers[13] = this.registers[13] & 0xFB;
                this.checkInterrupts();
                break;
            }
            case 13: {
                this.registers[13] = this.registers[13] & ~data;
                this.checkInterrupts();
                break;
            }
            case 14: {
                this.registers[14] = data >= 128 ? this.registers[14] | data & 0x7F : this.registers[14] & ~data;
                this.checkInterrupts();
                break;
            }
            case 15: {
                this.registers[1] = data;
                break;
            }
            default: {
                this.registers[register] = data;
            }
        }
    }

    public final long getNextUpdate() {
        return this.nextUpdate;
    }

    public void update(long cycles) {
        int passed = (int)(cycles - this.lastUpdate);
        int ta = this.registers[4] + (this.registers[5] << 8);
        if ((ta -= passed) <= 0) {
            if ((this.registers[11] & 0x40) == 0) {
                ta += this.registers[6] + (this.registers[7] << 8);
            }
            this.registers[13] = this.registers[13] | 0x40;
            this.checkInterrupts();
            ta &= 0xFFFF;
        }
        this.registers[4] = ta & 0xFF;
        this.registers[5] = ta >> 8;
        if ((this.registers[11] & 0x20) == 0) {
            int tb = this.registers[8] + (this.registers[9] << 8);
            if ((tb -= passed) <= 0) {
                this.registers[13] = this.registers[13] | 0x20;
                this.checkInterrupts();
                tb &= 0xFFFF;
            }
            this.registers[8] = tb & 0xFF;
            this.registers[9] = tb >> 8;
        }
        this.nextUpdate += 20L;
        this.lastUpdate = cycles;
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeLong(this.lastUpdate);
        out.writeLong(this.nextUpdate);
        SerializationUtils.serialize(out, this.registers);
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.lastUpdate = in.readLong();
        this.nextUpdate = in.readLong();
        SerializationUtils.deserialize(in, this.registers);
    }
}

