/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.rms.RecordStore;

public class Bluetooth
implements DiscoveryListener,
CommandListener,
Runnable {
    private static final UUID MeBoyUUID = new UUID("ceb15f4a19eb4db28d1c40eb0f091607", false);
    private MeBoy parent;
    private String connectionURL;
    private String savegameDisplayName;
    private String savegameFilename;
    private String savegameCartID;
    private String sendgameMode = "s";
    private byte[] savegameData;
    private Vector remoteDevices = new Vector();
    private DiscoveryAgent discoveryAgent;
    private boolean discoveryAgentIsInquiring;
    private boolean discoveryAgentIsScanning;
    private int discoveryAgentId;
    private UUID[] uuidSet = new UUID[]{new UUID(4353L)};
    private int[] attrSet = new int[]{256};
    private Form waitForm;
    private List mainList;
    private Form receiveForm;
    private List savegameList;
    private List suspendgameList;
    private List deviceList;
    private Gauge gauge;
    private Vector savegameCartIDs;
    private Vector savegameFilenames;
    private boolean iAmSender;
    private StreamConnectionNotifier notifier;
    private StreamConnection connection;
    private DataInputStream is;
    private DataOutputStream os;
    private boolean poisoned;

    public Bluetooth(MeBoy meBoy) {
        this.parent = meBoy;
        this.showMain();
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        this.remoteDevices.addElement(remoteDevice);
    }

    public void inquiryCompleted(int n) {
        if (this.poisoned) {
            return;
        }
        this.discoveryAgentIsInquiring = false;
        if (n != 0) {
            MeBoy.log("disctype = " + n);
            return;
        }
        if (this.remoteDevices.size() == 0) {
            this.parent.cancelBluetooth(MeBoy.literal[60]);
            return;
        }
        this.showDevice();
    }

    public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
        if (this.poisoned) {
            return;
        }
        block0: for (int i = 0; i < serviceRecordArray.length; ++i) {
            DataElement dataElement = serviceRecordArray[i].getAttributeValue(1);
            Enumeration enumeration = (Enumeration)(dataElement == null ? null : dataElement.getValue());
            if (enumeration == null) continue;
            while (enumeration.hasMoreElements()) {
                UUID uUID = (UUID)((DataElement)enumeration.nextElement()).getValue();
                if (!uUID.equals((Object)MeBoyUUID)) continue;
                this.connectionURL = serviceRecordArray[i].getConnectionURL(0, false);
                if (this.connectionURL != null && this.connectionURL.length() > 0) {
                    return;
                }
                long l = Bluetooth.getChannel(serviceRecordArray[i].getAttributeValue(4));
                if (l <= 0L) continue block0;
                this.connectionURL = "btspp://" + serviceRecordArray[i].getHostDevice().getBluetoothAddress() + ":" + l + ";authenticate=false;encrypt=false";
                return;
            }
        }
    }

    public void serviceSearchCompleted(int n, int n2) {
        if (this.poisoned) {
            return;
        }
        this.discoveryAgentIsScanning = false;
        if (this.connectionURL != null && n2 == 1) {
            this.iAmSender = true;
            new Thread(this).start();
            this.showWait(MeBoy.literal[61], true);
        } else {
            this.parent.cancelBluetooth(MeBoy.literal[62]);
        }
    }

    public void showWait(String string) {
        this.showWait(string, false);
    }

    public void showWait(String string, boolean bl) {
        this.waitForm = new Form(MeBoy.literal[4]);
        this.waitForm.append(string);
        if (bl) {
            this.gauge = new Gauge("", false, 100, 5);
            this.waitForm.append((Item)this.gauge);
        }
        this.waitForm.setCommandListener((CommandListener)this);
        this.waitForm.addCommand(new Command(MeBoy.literal[57], 3, 0));
        MeBoy.display.setCurrent((Displayable)this.waitForm);
    }

    private void waitCommand() {
        this.parent.cancelBluetooth();
    }

    private void showMain() {
        this.mainList = new List(MeBoy.literal[4], 3);
        this.mainList.append(MeBoy.literal[52], null);
        if (MeBoy.suspendName20.length > 0) {
            this.mainList.append(MeBoy.literal[54], null);
        }
        this.mainList.append(MeBoy.literal[56], null);
        this.mainList.addCommand(new Command(MeBoy.literal[10], 2, 1));
        this.mainList.setCommandListener((CommandListener)this);
        MeBoy.display.setCurrent((Displayable)this.mainList);
    }

    private void mainCommand(Command command) {
        if (command.getCommandType() == 2) {
            this.parent.cancelBluetooth();
        } else {
            String string = this.mainList.getString(this.mainList.getSelectedIndex());
            if (string == MeBoy.literal[52]) {
                this.showSavegameSelect();
            } else if (string == MeBoy.literal[54]) {
                this.showSuspendGameSelect();
            } else if (string.equals(MeBoy.literal[56])) {
                this.showReceive(false);
            }
        }
        this.mainList = null;
    }

    private void showSavegameSelect() {
        this.savegameList = new List(MeBoy.literal[53], 3);
        this.savegameCartIDs = new Vector();
        this.savegameFilenames = new Vector();
        this.parent.addSavegamesToList(this.savegameList, this.savegameCartIDs, this.savegameFilenames);
        if (this.savegameList.size() == 0) {
            this.parent.cancelBluetooth(MeBoy.literal[65]);
            return;
        }
        this.savegameList.addCommand(new Command(MeBoy.literal[10], 2, 1));
        this.savegameList.setCommandListener((CommandListener)this);
        MeBoy.display.setCurrent((Displayable)this.savegameList);
    }

    private void startInquiry() throws BluetoothStateException, InterruptedException {
        LocalDevice localDevice = LocalDevice.getLocalDevice();
        this.discoveryAgent = localDevice.getDiscoveryAgent();
        for (int i = 0; i < 10; ++i) {
            try {
                this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
                this.discoveryAgentIsInquiring = true;
                break;
            }
            catch (BluetoothStateException bluetoothStateException) {
                this.showWait(MeBoy.literal[66]);
                Thread.sleep(500L);
                continue;
            }
        }
        if (!this.discoveryAgentIsInquiring) {
            this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
            this.discoveryAgentIsInquiring = true;
        }
        this.showWait(MeBoy.literal[66]);
    }

    private void savegameSelectCommand(Command command) {
        if (command.getCommandType() == 2) {
            this.showMain();
            this.savegameList = null;
            return;
        }
        this.savegameDisplayName = this.savegameList.getString(this.savegameList.getSelectedIndex());
        this.savegameCartID = (String)this.savegameCartIDs.elementAt(this.savegameList.getSelectedIndex());
        this.savegameFilename = (String)this.savegameFilenames.elementAt(this.savegameList.getSelectedIndex());
        this.sendgameMode = "r";
        this.savegameList = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)("20R_" + this.savegameCartID), (boolean)false);
            this.savegameData = recordStore.getRecord(1);
            recordStore.closeRecordStore();
            this.startInquiry();
        }
        catch (Exception exception) {
            this.parent.cancelBluetooth(exception);
            return;
        }
    }

    private void showSuspendGameSelect() {
        this.suspendgameList = new List(MeBoy.literal[55], 3);
        int n = 0;
        while (true) {
            if (n >= MeBoy.suspendName20.length) break;
            this.suspendgameList.append(MeBoy.suspendName20[n], null);
            ++n;
        }
        this.suspendgameList.addCommand(new Command(MeBoy.literal[10], 2, 1));
        this.suspendgameList.setCommandListener((CommandListener)this);
        MeBoy.display.setCurrent((Displayable)this.suspendgameList);
    }

    private void suspendGameSelectCommand(Command command) {
        if (command.getCommandType() == 2) {
            this.showMain();
            this.suspendgameList = null;
            return;
        }
        this.savegameDisplayName = this.suspendgameList.getString(this.suspendgameList.getSelectedIndex());
        this.savegameFilename = "";
        this.sendgameMode = "s";
        this.suspendgameList = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)("20S_" + this.savegameDisplayName), (boolean)false);
            this.savegameCartID = new String(recordStore.getRecord(1));
            this.savegameData = recordStore.getRecord(2);
            recordStore.closeRecordStore();
            int n = this.savegameDisplayName.indexOf(58);
            if (n > 0) {
                this.savegameDisplayName = this.savegameDisplayName.substring(n + 2);
            }
            this.startInquiry();
        }
        catch (Exception exception) {
            this.parent.cancelBluetooth(exception);
            return;
        }
    }

    private void showDevice() {
        try {
            this.deviceList = new List(MeBoy.literal[70], 3);
            for (int i = 0; i < this.remoteDevices.size(); ++i) {
                String string;
                try {
                    string = ((RemoteDevice)this.remoteDevices.elementAt(i)).getFriendlyName(true);
                }
                catch (Exception exception) {
                    string = ((RemoteDevice)this.remoteDevices.elementAt(i)).getBluetoothAddress();
                }
                this.deviceList.append(string, null);
            }
            this.deviceList.addCommand(new Command(MeBoy.literal[57], 3, 1));
            this.deviceList.setCommandListener((CommandListener)this);
            MeBoy.display.setCurrent((Displayable)this.deviceList);
        }
        catch (Exception exception) {
            this.parent.cancelBluetooth(exception);
        }
    }

    private void deviceCommand(Command command) {
        if (command.getCommandType() == 3) {
            this.parent.cancelBluetooth();
            return;
        }
        int n = this.deviceList.getSelectedIndex();
        try {
            RemoteDevice remoteDevice = (RemoteDevice)this.remoteDevices.elementAt(n);
            this.discoveryAgentId = this.discoveryAgent.searchServices(this.attrSet, this.uuidSet, remoteDevice, (DiscoveryListener)this);
            this.discoveryAgentIsScanning = true;
        }
        catch (Exception exception) {
            this.parent.cancelBluetooth(exception);
            return;
        }
        this.showWait(MeBoy.literal[67]);
    }

    private void showReceive(boolean bl) {
        this.receiveForm = new Form(MeBoy.literal[56]);
        this.receiveForm.addCommand(new Command(MeBoy.literal[57], 3, 1));
        this.receiveForm.setCommandListener((CommandListener)this);
        if (bl) {
            this.receiveForm.append(MeBoy.literal[71]);
            this.gauge = new Gauge("", false, 100, 0);
            this.receiveForm.append((Item)this.gauge);
        } else {
            this.receiveForm.append(MeBoy.literal[68]);
            this.iAmSender = false;
            new Thread(this).start();
        }
        MeBoy.display.setCurrent((Displayable)this.receiveForm);
    }

    private void receiveCommand(Command command) {
        if (command.getCommandType() == 3) {
            this.parent.cancelBluetooth();
        }
    }

    public void tearDown() {
        if (this.poisoned) {
            return;
        }
        this.poisoned = true;
        if (this.discoveryAgent != null) {
            if (this.discoveryAgentIsScanning) {
                this.discoveryAgent.cancelServiceSearch(this.discoveryAgentId);
            } else if (this.discoveryAgentIsInquiring) {
                this.discoveryAgent.cancelInquiry((DiscoveryListener)this);
            }
            this.discoveryAgent = null;
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.os = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connection = null;
        }
        if (this.notifier != null) {
            try {
                this.notifier.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.notifier = null;
        }
        this.mainList = null;
        this.receiveForm = null;
        this.savegameList = null;
        this.deviceList = null;
        System.gc();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.waitForm) {
            this.waitCommand();
        } else if (displayable == this.mainList) {
            this.mainCommand(command);
        } else if (displayable == this.savegameList) {
            this.savegameSelectCommand(command);
        } else if (displayable == this.suspendgameList) {
            this.suspendGameSelectCommand(command);
        } else if (displayable == this.deviceList) {
            this.deviceCommand(command);
        } else if (displayable == this.receiveForm) {
            this.receiveCommand(command);
        }
    }

    private void send() throws Exception {
        this.connection = (StreamConnection)Connector.open((String)this.connectionURL);
        this.is = this.connection.openDataInputStream();
        this.os = this.connection.openDataOutputStream();
        this.os.writeUTF("MeBoy20");
        this.os.flush();
        String string = this.is.readUTF();
        if (string.equals("version")) {
            throw new IOException(MeBoy.literal[69]);
        }
        if (!string.equals("go")) {
            throw new IOException("read " + string);
        }
        this.os.writeUTF(this.sendgameMode);
        this.os.writeUTF(this.savegameDisplayName);
        this.os.writeUTF(this.savegameFilename);
        this.os.writeUTF(this.savegameCartID);
        this.os.writeInt(this.savegameData.length);
        int n = 0;
        for (int i = 0; i < this.savegameData.length; i += 512) {
            int n2 = Math.min(this.savegameData.length - i, 512);
            this.os.write(this.savegameData, i, n2);
            this.os.flush();
            int n3 = 100 * i / this.savegameData.length;
            if (n3 <= n + 10) continue;
            this.gauge.setValue(n3);
            Thread.sleep(50L);
            n = n3;
        }
        this.gauge.setValue(100);
        string = this.is.readUTF();
        if (!string.equals("ok")) {
            throw new IOException("read " + string);
        }
        this.parent.finishBluetooth();
    }

    private void receive() throws Exception {
        int n;
        String string = "btspp://localhost:" + MeBoyUUID + ";authenticate=false;encrypt=false;name=MeBoy";
        this.notifier = (StreamConnectionNotifier)Connector.open((String)string);
        this.connection = this.notifier.acceptAndOpen();
        this.showReceive(true);
        this.is = this.connection.openDataInputStream();
        this.os = this.connection.openDataOutputStream();
        String string2 = this.is.readUTF();
        if (!string2.equals("MeBoy20")) {
            this.os.writeUTF("version");
            this.os.flush();
            throw new IOException("read " + string2);
        }
        this.os.writeUTF("go");
        this.os.flush();
        String string3 = this.is.readUTF();
        if (!string3.equals("r") && !string3.equals("s")) {
            throw new IOException("invalid mode: " + string3);
        }
        String string4 = this.is.readUTF();
        String string5 = this.is.readUTF();
        String string6 = this.is.readUTF();
        String string7 = string4.toLowerCase();
        if (string7.endsWith(".gb") || string7.endsWith(".gbc") || string7.endsWith(".sgb")) {
            string4 = string4.substring(0, string4.lastIndexOf(46));
        }
        int n2 = this.is.readInt();
        byte[] byArray = new byte[n2];
        this.gauge.setMaxValue(100);
        this.gauge.setValue(0);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2 && (n = this.is.read(byArray, n3, n2 - n3)) != -1) {
            int n5 = 100 * (n3 += n) / n2;
            if (n5 <= n4 + 10) continue;
            this.gauge.setValue(n5);
            Thread.sleep(50L);
            n4 = n5;
        }
        if (n3 != n2) {
            throw new IOException("read " + n3 + "/" + n2);
        }
        this.os.writeUTF("ok");
        this.os.flush();
        this.parent.finishBluetoothReceive(string3, string4, string5, string6, byArray);
    }

    public void run() {
        try {
            if (this.iAmSender) {
                this.send();
            } else {
                this.receive();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            this.parent.cancelBluetooth();
        }
        catch (Exception exception) {
            this.parent.cancelBluetooth(exception);
        }
    }

    static long getChannel(DataElement dataElement) {
        try {
            Enumeration enumeration = (Enumeration)dataElement.getValue();
            while (enumeration.hasMoreElements()) {
                DataElement dataElement2 = (DataElement)enumeration.nextElement();
                if (48 == dataElement2.getDataType() || 56 == dataElement2.getDataType()) {
                    long l = Bluetooth.getChannel(dataElement2);
                    if (l <= 0L) continue;
                    return l;
                }
                if (24 != dataElement2.getDataType() || !dataElement2.getValue().equals(new UUID(3L))) continue;
                DataElement dataElement3 = (DataElement)enumeration.nextElement();
                if (11 == dataElement3.getDataType() || 12 == dataElement3.getDataType() || 20 == dataElement3.getDataType()) {
                    byte[] byArray = (byte[])dataElement3.getValue();
                    return byArray[0];
                }
                return dataElement3.getLong();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    static boolean available() {
        return true;
    }
}

