/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public abstract class GraphicsChip {
    protected final int MS_PER_FRAME;
    protected final int TILE_FLIPX;
    protected final int TILE_FLIPY;
    protected byte[] videoRam;
    protected byte[][] videoRamBanks;
    protected int[] colors;
    protected int[] gbPalette = new int[12];
    protected int[] gbcRawPalette = new int[128];
    protected int[] gbcPalette = new int[64];
    protected int gbcMask;
    protected int transparentCutoff;
    boolean bgEnabled = true;
    boolean winEnabled = true;
    boolean spritesEnabled = true;
    boolean lcdEnabled = true;
    boolean spritePriorityEnabled = true;
    public int timer;
    protected boolean skipping = true;
    protected int frameCount;
    protected int skipCount;
    int lastSkipCount;
    boolean bgWindowDataSelect = true;
    boolean doubledSprites = false;
    boolean hiBgTileMapAddress = false;
    boolean hiWinTileMapAddress = false;
    protected int tileOffset;
    protected int tileCount;
    protected int colorCount;
    protected boolean scale;
    public int scaledWidth = 160;
    public int scaledHeight = 144;
    private boolean frameDone = true;
    protected Dmgcpu cpu;
    public Image frameBufferImage;
    protected static int[] weaveLookup = new int[256];

    public GraphicsChip(Dmgcpu dmgcpu) {
        int n;
        this.MS_PER_FRAME = 17;
        this.TILE_FLIPX = 1;
        this.TILE_FLIPY = 2;
        this.cpu = dmgcpu;
        if (this.cpu.gbcFeatures) {
            this.videoRamBanks = new byte[2][8192];
            this.tileCount = 768;
            this.colorCount = 64;
        } else {
            this.videoRamBanks = new byte[1][8192];
            this.tileCount = 384;
            this.colorCount = 12;
        }
        this.videoRam = this.videoRamBanks[0];
        this.cpu.memory[4] = this.videoRam;
        this.scale = false;
        for (n = 0; n < this.gbcRawPalette.length; ++n) {
            this.gbcRawPalette[n] = -1000;
        }
        for (n = 0; n < this.gbcPalette.length >> 1; ++n) {
            this.gbcPalette[n] = -1;
        }
        for (n = this.gbcPalette.length >> 1; n < this.gbcPalette.length; ++n) {
            this.gbcPalette[n] = 0;
        }
    }

    public int unflatten(byte[] byArray, int n) {
        int n2;
        for (n2 = 0; n2 < this.videoRamBanks.length; ++n2) {
            System.arraycopy(byArray, n, this.videoRamBanks[n2], 0, 8192);
            n += 8192;
        }
        for (n2 = 0; n2 < 12; ++n2) {
            this.gbPalette[n2] = (n2 & 3) == 0 ? 0xFFFFFF & GBCanvas.getInt(byArray, n) : 0xFF000000 | GBCanvas.getInt(byArray, n);
            n += 4;
        }
        this.UpdateLCDCFlags(this.cpu.registers[64]);
        if (this.cpu.gbcFeatures) {
            this.setVRamBank(byArray[n++] & 0xFF);
            for (n2 = 0; n2 < 128; ++n2) {
                this.setGBCPalette(n2, byArray[n++] & 0xFF);
            }
        } else {
            this.invalidateAll(0);
            this.invalidateAll(1);
            this.invalidateAll(2);
        }
        return n;
    }

    public int flatten(byte[] byArray, int n) {
        int n2;
        for (n2 = 0; n2 < this.videoRamBanks.length; ++n2) {
            System.arraycopy(this.videoRamBanks[n2], 0, byArray, n, 8192);
            n += 8192;
        }
        for (n2 = 0; n2 < 12; ++n2) {
            GBCanvas.setInt(byArray, n, this.gbPalette[n2]);
            n += 4;
        }
        if (this.cpu.gbcFeatures) {
            byArray[n++] = (byte)(this.tileOffset != 0 ? 1 : 0);
            for (n2 = 0; n2 < 128; ++n2) {
                byArray[n++] = (byte)this.getGBCPalette(n2);
            }
        }
        return n;
    }

    public void UpdateLCDCFlags(int n) {
        this.bgEnabled = true;
        this.lcdEnabled = (n & 0x80) != 0;
        this.hiWinTileMapAddress = (n & 0x40) != 0;
        this.winEnabled = (n & 0x20) != 0;
        this.bgWindowDataSelect = (n & 0x10) != 0;
        this.hiBgTileMapAddress = (n & 8) != 0;
        this.doubledSprites = (n & 4) != 0;
        boolean bl = this.spritesEnabled = (n & 2) != 0;
        if (this.cpu.gbcFeatures) {
            this.spritePriorityEnabled = (n & 1) != 0;
        } else if ((n & 1) == 0) {
            this.bgEnabled = false;
            this.winEnabled = false;
        }
    }

    public final void vBlank() {
        this.timer += 17;
        ++this.frameCount;
        if (this.skipping) {
            ++this.skipCount;
            if (this.skipCount >= MeBoy.maxFrameSkip) {
                this.skipping = false;
                int n = (int)System.currentTimeMillis() - this.timer;
                if (n > 17) {
                    this.timer += n - 17;
                }
            } else {
                this.skipping = this.timer - (int)System.currentTimeMillis() < 0;
            }
            return;
        }
        this.lastSkipCount = this.skipCount;
        this.frameDone = false;
        this.cpu.screen.redrawSmall();
        int n = (int)System.currentTimeMillis();
        this.skipping = MeBoy.maxFrameSkip == 0 ? false : this.timer - n < 0;
        try {
            while (this.timer > n + 17) {
                Thread.sleep(1L);
                n = (int)System.currentTimeMillis();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (!this.frameDone && !this.cpu.terminate) {
            Thread.yield();
        }
        this.skipCount = 0;
    }

    public void decodePalette(int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            this.gbPalette[n + i] = this.colors[n2 >> 2 * i & 3];
        }
        int n3 = n;
        this.gbPalette[n3] = this.gbPalette[n3] & 0xFFFFFF;
    }

    public void setGBCPalette(int n, int n2) {
        if (this.gbcRawPalette[n] == n2) {
            return;
        }
        this.gbcRawPalette[n] = n2;
        if (n >= 64 && (n & 6) == 0) {
            return;
        }
        int n3 = (this.gbcRawPalette[n | 1] << 8) + this.gbcRawPalette[n & 0xFFFFFFFE];
        this.gbcPalette[n >> 1] = this.gbcMask + ((n3 & 0x1F) << 19) + ((n3 & 0x3E0) << 6) + ((n3 & 0x7C00) >> 7);
        this.invalidateAll(n >> 3);
    }

    public int getGBCPalette(int n) {
        return this.gbcRawPalette[n];
    }

    public void setVRamBank(int n) {
        this.tileOffset = n * 384;
        this.videoRam = this.videoRamBanks[n];
        this.cpu.memory[4] = this.videoRam;
    }

    public final void notifyRepainted() {
        this.frameDone = true;
    }

    public void stopWindowFromLine() {
    }

    public abstract void setScale(int var1, int var2);

    public abstract void addressWrite(int var1, byte var2);

    public abstract void invalidateAll(int var1);

    public abstract void notifyScanline(int var1);

    static {
        for (int i = 1; i < 256; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = i;
                weaveLookup[n] = weaveLookup[n] + ((i >> j & 1) << j * 2);
            }
        }
    }
}

