/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.GBACanvas;
import dma.DMA;
import dma.DirectMemoryAccess;
import java.io.IOException;
import java.io.InputStream;
import time.Time;
import time.Timer;

public final class GBACore
extends Thread {
    private DirectMemoryAccess dma;
    private Time time;
    private GBACanvas gui;
    public static final int REQUEST_START = 0;
    public static final int REQUEST_RESET = 1;
    public static final int REQUEST_STOP = 2;
    public static final int REQUEST_LOAD = 3;
    public static final int REQUEST_SAVE = 4;
    public static final int REQUEST_SLEEP = 5;
    private int request;
    private int param;
    public int[] pixels;
    private boolean op1;
    private boolean op2;
    private boolean res;
    private boolean draw;
    private int[] registers;
    private int pipelineStage1;
    private int pipelineStage2;
    private static byte SPSR;
    private int mFlag;
    private boolean tFlag;
    private boolean fFlag;
    private boolean iFlag;
    private boolean vFlag;
    private boolean cFlag;
    private boolean nFlag;
    private boolean zFlag;
    private static final byte[] thumbInstruction;
    private static byte[] armInstruction;
    private byte[] sysrom = new byte[16384];
    private byte[] ewram = new byte[262144];
    private byte[] iwram = new byte[32768];
    private byte[] ioram = new byte[1024];
    private byte[] palram = new byte[1024];
    private byte[] vram = new byte[98304];
    private byte[] oam = new byte[1024];
    private byte[] rom;
    private byte[] sram = new byte[65536];
    private int romMask;
    private DMA dma0;
    private DMA dma1;
    private DMA dma2;
    private DMA dma3;
    private Timer timer0;
    private Timer timer1;
    private Timer timer2;
    private Timer timer3;
    private boolean bg0Enabled;
    private boolean bg1Enabled;
    private boolean bg2Enabled;
    private boolean bg3Enabled;
    private boolean objEnabled;
    private boolean isMosaicEnabled;
    private int bg0Priority;
    private int bg1Priority;
    private int bg2Priority;
    private int bg3Priority;
    private int xMosaic;
    private int yMosaic;
    private int drawMode_x;
    private int drawMode_y;
    private boolean pf;

    public GBACore(GBACanvas gBACanvas) {
        this.dma = new DirectMemoryAccess();
        this.time = new Time();
        this.gui = gBACanvas;
        this.pixels = new int[38400];
        this.connectToDMA(this.dma);
        this.connectToTime(this.time);
        this.dma.connectToMemory(this);
        this.connectToGBACanvas(gBACanvas);
        this.time.connectToMemory(this);
        this.registers = new int[37];
        GBACore.initARM();
    }

    public void reset() {
        this.cpu_reset();
        this.Memory_reset();
        this.dma.reset();
        this.gfx_reset();
        this.time.reset();
    }

    public void request(int n, int n2) {
        this.request = n;
        this.param = n2;
    }

    public final void run() {
        block5: while (true) {
            switch (this.request) {
                case 1: {
                    this.reset();
                    break;
                }
                case 2: {
                    this.request = 0;
                    return;
                }
                case 5: {
                    continue block5;
                }
            }
            this.request = 0;
            this.draw = this.gui.startFrame();
            short s = this.gui.readJoyPad();
            this.writeIO16(304, (short)(s & 0x3FF));
            if (s < 0) {
                this.ioram[515] = (byte)(this.ioram[515] | (byte)(this.ioram[513] & 0x10));
            }
            for (int i = 0; i < 228; ++i) {
                this.ioram[6] = (byte)i;
                this.cpu(960);
                this.enterHBlank();
                this.cpu(272);
                byte by = this.ioram[4];
                this.ioram[4] = by = (byte)(by & 0xFFFFFFFD);
                this.time.addTime(1232);
                if (i == 159) {
                    this.dma0.signalVBlank();
                    this.dma1.signalVBlank();
                    this.dma2.signalVBlank();
                    this.dma3.signalVBlank();
                    this.writeIO16(514, (short)(this.readIO16(514) | this.readIO16(512) & 1));
                    this.ioram[4] = (byte)(this.ioram[4] | 1);
                    continue;
                }
                if (i != 227) continue;
                this.ioram[4] = (byte)(this.ioram[4] & 0xFFFFFFFE);
            }
            if (!this.draw) continue;
            this.gui.endFrame();
        }
    }

    private final void setMode(int n) {
        int n2 = n;
        int n3 = this.mFlag;
        if (n2 != n3) {
            int n4;
            switch (n3) {
                case 17: {
                    n4 = this.registers[17];
                    this.registers[17] = this.registers[8];
                    this.registers[8] = n4;
                    n4 = this.registers[18];
                    this.registers[18] = this.registers[9];
                    this.registers[9] = n4;
                    n4 = this.registers[19];
                    this.registers[19] = this.registers[10];
                    this.registers[10] = n4;
                    n4 = this.registers[20];
                    this.registers[20] = this.registers[11];
                    this.registers[11] = n4;
                    n4 = this.registers[21];
                    this.registers[21] = this.registers[12];
                    this.registers[12] = n4;
                    n4 = this.registers[22];
                    this.registers[22] = this.registers[13];
                    this.registers[13] = n4;
                    n4 = this.registers[23];
                    this.registers[23] = this.registers[14];
                    this.registers[14] = n4;
                    break;
                }
                case 19: {
                    n4 = this.registers[25];
                    this.registers[25] = this.registers[13];
                    this.registers[13] = n4;
                    n4 = this.registers[26];
                    this.registers[26] = this.registers[14];
                    this.registers[14] = n4;
                    break;
                }
                case 23: {
                    n4 = this.registers[28];
                    this.registers[28] = this.registers[13];
                    this.registers[13] = n4;
                    n4 = this.registers[29];
                    this.registers[29] = this.registers[14];
                    this.registers[14] = n4;
                    break;
                }
                case 18: {
                    n4 = this.registers[31];
                    this.registers[31] = this.registers[13];
                    this.registers[13] = n4;
                    n4 = this.registers[32];
                    this.registers[32] = this.registers[14];
                    this.registers[14] = n4;
                    break;
                }
                case 27: {
                    n4 = this.registers[34];
                    this.registers[34] = this.registers[13];
                    this.registers[13] = n4;
                    n4 = this.registers[35];
                    this.registers[35] = this.registers[14];
                    this.registers[14] = n4;
                }
            }
            switch (n2) {
                case 16: 
                case 31: {
                    SPSR = (byte)-1;
                    break;
                }
                case 17: {
                    n4 = this.registers[17];
                    this.registers[17] = this.registers[8];
                    this.registers[8] = n4;
                    n4 = this.registers[18];
                    this.registers[18] = this.registers[9];
                    this.registers[9] = n4;
                    n4 = this.registers[19];
                    this.registers[19] = this.registers[10];
                    this.registers[10] = n4;
                    n4 = this.registers[20];
                    this.registers[20] = this.registers[11];
                    this.registers[11] = n4;
                    n4 = this.registers[21];
                    this.registers[21] = this.registers[12];
                    this.registers[12] = n4;
                    n4 = this.registers[22];
                    this.registers[22] = this.registers[13];
                    this.registers[13] = n4;
                    n4 = this.registers[23];
                    this.registers[23] = this.registers[14];
                    this.registers[14] = n4;
                    SPSR = (byte)24;
                    break;
                }
                case 19: {
                    n4 = this.registers[25];
                    this.registers[25] = this.registers[13];
                    this.registers[13] = n4;
                    n4 = this.registers[26];
                    this.registers[26] = this.registers[14];
                    this.registers[14] = n4;
                    SPSR = (byte)27;
                    break;
                }
                case 23: {
                    n4 = this.registers[28];
                    this.registers[28] = this.registers[13];
                    this.registers[13] = n4;
                    n4 = this.registers[29];
                    this.registers[29] = this.registers[14];
                    this.registers[14] = n4;
                    SPSR = (byte)30;
                    break;
                }
                case 18: {
                    n4 = this.registers[31];
                    this.registers[31] = this.registers[13];
                    this.registers[13] = n4;
                    n4 = this.registers[32];
                    this.registers[32] = this.registers[14];
                    this.registers[14] = n4;
                    SPSR = (byte)33;
                    break;
                }
                case 27: {
                    n4 = this.registers[34];
                    this.registers[34] = this.registers[13];
                    this.registers[13] = n4;
                    n4 = this.registers[35];
                    this.registers[35] = this.registers[14];
                    this.registers[14] = n4;
                    SPSR = (byte)36;
                }
            }
            this.mFlag = n2;
        }
    }

    private final void generateInterrupt(int n, int n2, int n3) {
        int n4 = 0;
        n4 = this.tFlag ? n4 | 0x20 : (n4 |= this.mFlag) & 0xFFFFFFDF;
        n4 = this.fFlag ? n4 | 0x40 : n4 & 0xFFFFFFBF;
        n4 = this.iFlag ? n4 | 0x80 : n4 & 0xFFFFFF7F;
        n4 = this.vFlag ? n4 | 0x10000000 : n4 & 0xEFFFFFFF;
        n4 = this.cFlag ? n4 | 0x20000000 : n4 & 0xDFFFFFFF;
        n4 = this.zFlag ? n4 | 0x40000000 : n4 & 0xBFFFFFFF;
        int n5 = n4 = this.nFlag ? n4 | Integer.MIN_VALUE : n4 & Integer.MAX_VALUE;
        this.setMode(n);
        this.tFlag = false;
        this.iFlag = true;
        this.registers[GBACore.SPSR] = n5;
        this.registers[14] = n3;
        this.registers[15] = n2;
        this.registers[15] = this.registers[15] & 0xFFFFFFFC;
        this.pipelineStage1 = this.getWord(this.registers[15]);
        this.registers[15] = this.registers[15] + 4;
        this.pipelineStage2 = this.getWord(this.registers[15]);
    }

    private final void cpu_reset() {
        for (int n = 0; n < 37; n = (int)((byte)(n + 1))) {
            this.registers[n] = 0;
        }
        this.mFlag = 0;
        this.nFlag = false;
        this.zFlag = false;
        this.cFlag = false;
        this.vFlag = false;
        this.tFlag = false;
        this.iFlag = true;
        this.fFlag = true;
        this.setMode(19);
        this.registers[15] = 0;
        this.iFlag = false;
        this.setMode(31);
        this.registers[15] = 0x8000000;
        this.registers[13] = 50364160;
        this.registers[25] = 50364384;
        this.registers[31] = 50364320;
        if (this.tFlag) {
            this.registers[15] = this.registers[15] & 0xFFFFFFFE;
            this.pipelineStage1 = this.getHalfWord(this.registers[15]) & 0xFFFF;
            this.registers[15] = this.registers[15] + 2;
            this.pipelineStage2 = this.getHalfWord(this.registers[15]) & 0xFFFF;
        } else {
            this.registers[15] = this.registers[15] & 0xFFFFFFFC;
            this.pipelineStage1 = this.getWord(this.registers[15]);
            this.registers[15] = this.registers[15] + 4;
            this.pipelineStage2 = this.getWord(this.registers[15]);
        }
    }

    private final void cpu(int n) {
        while (n > 0) {
            block127: {
                byte by;
                int n2;
                block128: {
                    block126: {
                        if (this.iFlag || this.ioram[520] == 0 || ((short)(this.ioram[512] & 0xFF | this.ioram[513] << 8) & (short)(this.ioram[514] & 0xFF | this.ioram[515] << 8)) == 0) break block126;
                        this.generateInterrupt(18, 24, this.registers[15] + (this.tFlag ? 2 : 0));
                        break block127;
                    }
                    if (!this.tFlag) break block128;
                    this.registers[15] = this.registers[15] + 2;
                    n2 = this.pipelineStage1;
                    this.pipelineStage1 = this.pipelineStage2;
                    this.pipelineStage2 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                    by = thumbInstruction[n2 >>> 8];
                    block0 : switch (by) {
                        case 1: {
                            int n3 = n2 & 7;
                            int n4 = n2 >>> 3 & 7;
                            int n5 = this.registers[n4];
                            int n6 = 0;
                            int n7 = n2 >>> 6 & 0x1F;
                            switch (n2 & 0x1800) {
                                case 0: {
                                    if (n7 == 0) break;
                                    this.cFlag = (n5 & 1 << 32 - n7) != 0;
                                    n6 = n5 << n7;
                                    break;
                                }
                                case 2048: {
                                    if (n7 == 0) {
                                        this.cFlag = n5 < 0;
                                        n6 = 0;
                                        break;
                                    }
                                    this.cFlag = (n5 & 1 << n7 - 1) != 0;
                                    n6 = n5 >>> n7;
                                    break;
                                }
                                case 4096: {
                                    if (n7 == 0) {
                                        this.cFlag = n5 < 0;
                                        n6 = n5 >> 31;
                                        break;
                                    }
                                    this.cFlag = (n5 & 1 << n7 - 1) != 0;
                                    n6 = n5 >> n7;
                                    break;
                                }
                            }
                            this.registers[n3] = n6;
                            this.zFlag = n6 == 0;
                            this.nFlag = n6 < 0;
                            break;
                        }
                        case 2: {
                            int n6;
                            int n3 = n2 & 7;
                            int n4 = n2 >>> 3 & 7;
                            int n5 = this.registers[n4];
                            int n7 = n2 >>> 6 & 7;
                            if ((n2 & 0x400) == 0) {
                                n7 = this.registers[n7];
                            }
                            if ((n2 & 0x200) == 0) {
                                n6 = n5 + n7;
                                this.op1 = n5 < 0;
                                this.op2 = n7 < 0;
                                this.res = n6 < 0;
                                this.vFlag = this.op1 && this.op2 && !this.res || !this.op1 && !this.op2 && this.res;
                                this.cFlag = this.op1 && this.op2 || this.op1 && !this.res || this.op2 && !this.res;
                            } else {
                                n6 = n5 - n7;
                                this.op1 = n5 < 0;
                                this.op2 = n7 < 0;
                                this.res = n6 < 0;
                                this.vFlag = this.op1 && !this.op2 && !this.res || !this.op1 && this.op2 && this.res;
                                this.cFlag = this.op1 && !this.op2 || this.op1 && !this.res || !this.op2 && !this.res;
                            }
                            this.registers[n3] = n6;
                            this.zFlag = n6 == 0;
                            this.nFlag = n6 < 0;
                            break;
                        }
                        case 3: {
                            int n3 = n2 >>> 8 & 7;
                            int n4 = this.registers[n3];
                            int n5 = 0;
                            int n6 = n2 & 0xFF;
                            switch (n2 & 0x1800) {
                                case 0: {
                                    this.registers[n3] = n5 = n6;
                                    break;
                                }
                                case 2048: {
                                    n5 = n4 - n6;
                                    this.op1 = n4 < 0;
                                    this.op2 = n6 < 0;
                                    this.res = n5 < 0;
                                    this.vFlag = this.op1 && !this.op2 && !this.res || !this.op1 && this.op2 && this.res;
                                    this.cFlag = this.op1 && !this.op2 || this.op1 && !this.res || !this.op2 && !this.res;
                                    break;
                                }
                                case 4096: {
                                    n5 = n4 + n6;
                                    this.op1 = n4 < 0;
                                    this.op2 = n6 < 0;
                                    this.res = n5 < 0;
                                    this.vFlag = this.op1 && this.op2 && !this.res || !this.op1 && !this.op2 && this.res;
                                    this.cFlag = this.op1 && this.op2 || this.op1 && !this.res || this.op2 && !this.res;
                                    this.registers[n3] = n5;
                                    break;
                                }
                                case 6144: {
                                    n5 = n4 - n6;
                                    this.op1 = n4 < 0;
                                    this.op2 = n6 < 0;
                                    this.res = n5 < 0;
                                    this.vFlag = this.op1 && !this.op2 && !this.res || !this.op1 && this.op2 && this.res;
                                    this.cFlag = this.op1 && !this.op2 || this.op1 && !this.res || !this.op2 && !this.res;
                                    this.registers[n3] = n5;
                                    break;
                                }
                            }
                            this.zFlag = n5 == 0;
                            this.nFlag = n5 < 0;
                            break;
                        }
                        case 4: {
                            int n6;
                            int n3 = n2 & 7;
                            int n4 = n2 >>> 3 & 7;
                            int n5 = this.registers[n4];
                            int n7 = n6 = this.registers[n3];
                            switch (n2 & 0x3C0) {
                                case 0: {
                                    this.registers[n3] = n7 &= n5;
                                    break;
                                }
                                case 64: {
                                    this.registers[n3] = n7 ^= n5;
                                    break;
                                }
                                case 128: {
                                    if (n5 == 0) break;
                                    if (n5 < 32) {
                                        this.cFlag = (n6 & 1 << 32 - n5) != 0;
                                        n7 <<= n5;
                                    } else if (n5 == 32) {
                                        this.cFlag = (n6 & 1) != 0;
                                        n7 = 0;
                                    } else {
                                        this.cFlag = false;
                                        n7 = 0;
                                    }
                                    this.registers[n3] = n7;
                                    break;
                                }
                                case 192: {
                                    if (n5 == 0) break;
                                    if (n5 < 32) {
                                        this.cFlag = (n6 & 1 << n5 - 1) != 0;
                                        n7 >>>= n5;
                                    } else if (n5 == 32) {
                                        this.cFlag = (n6 & Integer.MIN_VALUE) != 0;
                                        n7 = 0;
                                    } else {
                                        this.cFlag = false;
                                        n7 = 0;
                                    }
                                    this.registers[n3] = n7;
                                    break;
                                }
                                case 256: {
                                    if (n5 == 0) break;
                                    if (n5 < 32) {
                                        this.cFlag = (n6 & 1 << n5 - 1) != 0;
                                        n7 >>= n5;
                                    } else {
                                        this.cFlag = (n6 & Integer.MIN_VALUE) != 0;
                                        n7 >>= 31;
                                    }
                                    this.registers[n3] = n7;
                                    break;
                                }
                                case 320: {
                                    n7 = n6 + n5 + (this.cFlag ? 1 : 0);
                                    this.op1 = n6 < 0;
                                    this.op2 = n5 < 0;
                                    this.res = n7 < 0;
                                    this.vFlag = this.op1 && this.op2 && !this.res || !this.op1 && !this.op2 && this.res;
                                    this.cFlag = this.op1 && this.op2 || this.op1 && !this.res || this.op2 && !this.res;
                                    this.registers[n3] = n7;
                                    break;
                                }
                                case 384: {
                                    n7 = n6 - n5 - (this.cFlag ? 0 : 1);
                                    this.op1 = n6 < 0;
                                    this.op2 = n5 < 0;
                                    this.res = n7 < 0;
                                    this.vFlag = this.op1 && !this.op2 && !this.res || !this.op1 && this.op2 && this.res;
                                    this.cFlag = this.op1 && !this.op2 || this.op1 && !this.res || !this.op2 && !this.res;
                                    this.registers[n3] = n7;
                                    break;
                                }
                                case 448: {
                                    if (n5 == 0) break;
                                    if ((n5 &= 0x1F) == 0) {
                                        this.cFlag = (n6 & Integer.MIN_VALUE) != 0;
                                        break;
                                    }
                                    this.cFlag = (n6 & 1 << n5 - 1) != 0;
                                    this.registers[n3] = n7 = n6 << 32 - n5 | n6 >>> n5;
                                    break;
                                }
                                case 512: {
                                    n7 &= n5;
                                    break;
                                }
                                case 576: {
                                    n7 = -n5;
                                    this.op1 = false;
                                    this.op2 = n5 < 0;
                                    this.res = n7 < 0;
                                    this.vFlag = this.op1 && !this.op2 && !this.res || !this.op1 && this.op2 && this.res;
                                    this.cFlag = this.op1 && !this.op2 || this.op1 && !this.res || !this.op2 && !this.res;
                                    this.registers[n3] = n7;
                                    break;
                                }
                                case 640: {
                                    this.op1 = n6 < 0;
                                    this.op2 = n5 < 0;
                                    this.res = (n7 -= n5) < 0;
                                    this.vFlag = this.op1 && !this.op2 && !this.res || !this.op1 && this.op2 && this.res;
                                    this.cFlag = this.op1 && !this.op2 || this.op1 && !this.res || !this.op2 && !this.res;
                                    break;
                                }
                                case 704: {
                                    this.op1 = n6 < 0;
                                    this.op2 = n5 < 0;
                                    this.res = (n7 += n5) < 0;
                                    this.vFlag = this.op1 && this.op2 && !this.res || !this.op1 && !this.op2 && this.res;
                                    this.cFlag = this.op1 && this.op2 || this.op1 && !this.res || this.op2 && !this.res;
                                    break;
                                }
                                case 768: {
                                    this.registers[n3] = n7 |= n5;
                                    break;
                                }
                                case 832: {
                                    this.registers[n3] = n7 *= n5;
                                    break;
                                }
                                case 896: {
                                    this.registers[n3] = n7 &= ~n5;
                                    break;
                                }
                                case 960: {
                                    this.registers[n3] = n7 = ~n5;
                                    break;
                                }
                            }
                            this.zFlag = n7 == 0;
                            this.nFlag = n7 < 0;
                            break;
                        }
                        case 5: {
                            int n7;
                            int n6;
                            int n5;
                            int n3 = n2 >>> 3 & 0xF;
                            int n4 = this.registers[n3];
                            switch (n2 & 0x300) {
                                case 0: {
                                    n5 = n2 & 7 | (n2 & 0x80) >>> 4;
                                    n6 = this.registers[n5];
                                    this.registers[n5] = n6 + n4;
                                    if (n5 != 15) break;
                                    this.registers[15] = this.registers[15] & 0xFFFFFFFE;
                                    this.pipelineStage1 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                                    this.registers[15] = this.registers[15] + 2;
                                    this.pipelineStage2 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                                    break block0;
                                }
                                case 256: {
                                    n5 = n2 & 7 | (n2 & 0x80) >>> 4;
                                    n6 = this.registers[n5];
                                    n7 = n6 - n4;
                                    this.op1 = n6 < 0;
                                    this.op2 = n4 < 0;
                                    this.res = n7 < 0;
                                    this.vFlag = this.op1 && !this.op2 && !this.res || !this.op1 && this.op2 && this.res;
                                    this.cFlag = this.op1 && !this.op2 || this.op1 && !this.res || !this.op2 && !this.res;
                                    this.zFlag = n7 == 0;
                                    this.nFlag = n7 < 0;
                                    break block0;
                                }
                                case 512: {
                                    n5 = n2 & 7 | (n2 & 0x80) >>> 4;
                                    this.registers[n5] = n4;
                                    if (n5 != 15) break;
                                    this.registers[15] = this.registers[15] & 0xFFFFFFFE;
                                    this.pipelineStage1 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                                    this.registers[15] = this.registers[15] + 2;
                                    this.pipelineStage2 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                                    break block0;
                                }
                                case 768: {
                                    this.tFlag = (n4 & 1) != 0;
                                    this.registers[15] = n4;
                                    if (this.tFlag) {
                                        this.registers[15] = this.registers[15] & 0xFFFFFFFE;
                                        this.pipelineStage1 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                                        this.registers[15] = this.registers[15] + 2;
                                        this.pipelineStage2 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                                        break block0;
                                    }
                                    this.registers[15] = this.registers[15] & 0xFFFFFFFC;
                                    this.pipelineStage1 = this.getWord(this.registers[15]);
                                    this.registers[15] = this.registers[15] + 4;
                                    this.pipelineStage2 = this.getWord(this.registers[15]);
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 6: {
                            int n3 = n2 >>> 8 & 7;
                            int n4 = (this.registers[15] & 0xFFFFFFFC) + ((n2 & 0xFF) << 2);
                            this.registers[n3] = this.loadWord(n4);
                            break;
                        }
                        case 7: {
                            int n3 = n2 & 7;
                            int n4 = n2 >>> 3 & 7;
                            int n5 = n2 >>> 6 & 7;
                            int n6 = this.registers[n4] + this.registers[n5];
                            switch (n2 & 0xC00) {
                                case 0: {
                                    this.storeWord(n6, this.registers[n3]);
                                    break block0;
                                }
                                case 1024: {
                                    this.storeByte(n6, (byte)this.registers[n3]);
                                    break block0;
                                }
                                case 2048: {
                                    this.registers[n3] = this.loadWord(n6);
                                    break block0;
                                }
                                case 3072: {
                                    this.registers[n3] = this.loadByte(n6) & 0xFF;
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 8: {
                            int n3 = n2 & 7;
                            int n4 = n2 >>> 3 & 7;
                            int n5 = n2 >>> 6 & 7;
                            int n6 = this.registers[n4] + this.registers[n5];
                            switch (n2 & 0xC00) {
                                case 0: {
                                    this.storeHalfWord(n6, (short)this.registers[n3]);
                                    break block0;
                                }
                                case 1024: {
                                    this.registers[n3] = this.loadByte(n6);
                                    break block0;
                                }
                                case 2048: {
                                    this.registers[n3] = this.loadHalfWord(n6) & 0xFFFF;
                                    break block0;
                                }
                                case 3072: {
                                    this.registers[n3] = this.loadHalfWord(n6);
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 9: {
                            int n3 = n2 & 7;
                            int n4 = n2 >>> 3 & 7;
                            int n5 = this.registers[n4];
                            int n6 = n2 >>> 6 & 0x1F;
                            switch (n2 & 0x1800) {
                                case 0: {
                                    this.storeWord(n5 + (n6 << 2), this.registers[n3]);
                                    break block0;
                                }
                                case 2048: {
                                    this.registers[n3] = this.loadWord(n5 + (n6 << 2));
                                    break block0;
                                }
                                case 4096: {
                                    this.storeByte(n5 + n6, (byte)this.registers[n3]);
                                    break block0;
                                }
                                case 6144: {
                                    this.registers[n3] = this.loadByte(n5 + n6) & 0xFF;
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 10: {
                            int n3 = n2 & 7;
                            int n4 = n2 >>> 3 & 7;
                            int n5 = this.registers[n4];
                            int n6 = n2 >>> 5 & 0x3E;
                            if ((n2 & 0x800) == 0) {
                                this.storeHalfWord(n5 + n6, (short)this.registers[n3]);
                                break;
                            }
                            this.registers[n3] = this.loadHalfWord(n5 + n6) & 0xFFFF;
                            break;
                        }
                        case 11: {
                            int n3 = n2 >>> 8 & 7;
                            int n4 = this.registers[13];
                            int n5 = (n2 & 0xFF) << 2;
                            if ((n2 & 0x800) == 0) {
                                this.storeWord(n4 + n5, this.registers[n3]);
                                break;
                            }
                            this.registers[n3] = this.loadWord(n4 + n5);
                            break;
                        }
                        case 12: {
                            int n3 = n2 >>> 8 & 7;
                            int n4 = (n2 & 0x800) == 0 ? this.registers[15] & 0xFFFFFFFC : this.registers[13];
                            int n5 = (n2 & 0xFF) << 2;
                            this.registers[n3] = n4 + n5;
                            break;
                        }
                        case 13: {
                            int n3 = this.registers[13];
                            int n4 = (n2 & 0x7F) << 2;
                            if ((n2 & 0x80) != 0) {
                                n4 = -n4;
                            }
                            this.registers[13] = n3 + n4;
                            break;
                        }
                        case 14: {
                            int n4;
                            int n3 = this.registers[13] & 0xFFFFFFFC;
                            if ((n2 & 0x800) == 0) {
                                if ((n2 & 0x100) != 0) {
                                    this.storeWord(n3 -= 4, this.registers[14]);
                                }
                                for (n4 = 7; n4 >= 0; --n4) {
                                    if ((n2 & 1 << n4) == 0) continue;
                                    this.storeWord(n3 -= 4, this.registers[n4]);
                                }
                            } else {
                                for (n4 = 0; n4 <= 7; ++n4) {
                                    if ((n2 & 1 << n4) == 0) continue;
                                    this.registers[n4] = this.loadWord(n3);
                                    n3 += 4;
                                }
                                if ((n2 & 0x100) != 0) {
                                    this.registers[15] = this.loadWord(n3);
                                    n3 += 4;
                                    this.registers[15] = this.registers[15] & 0xFFFFFFFE;
                                    this.pipelineStage1 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                                    this.registers[15] = this.registers[15] + 2;
                                    this.pipelineStage2 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                                }
                            }
                            this.registers[13] = n3;
                            break;
                        }
                        case 15: {
                            int n5;
                            int n3 = n2 >>> 8 & 7;
                            int n4 = this.registers[n3] & 0xFFFFFFFC;
                            if ((n2 & 0x800) == 0) {
                                for (n5 = 0; n5 <= 7; ++n5) {
                                    if ((n2 & 1 << n5) == 0) continue;
                                    this.storeWord(n4, this.registers[n5]);
                                    n4 += 4;
                                }
                            } else {
                                for (n5 = 0; n5 <= 7; ++n5) {
                                    if ((n2 & 1 << n5) == 0) continue;
                                    this.registers[n5] = this.loadWord(n4);
                                    n4 += 4;
                                }
                            }
                            this.registers[n3] = n4;
                            break;
                        }
                        case 16: {
                            int n4;
                            int n3;
                            switch (n2 & 0xF00) {
                                case 0: {
                                    n3 = this.zFlag ? 1 : 0;
                                    break;
                                }
                                case 256: {
                                    n3 = !this.zFlag ? 1 : 0;
                                    break;
                                }
                                case 512: {
                                    n3 = this.cFlag ? 1 : 0;
                                    break;
                                }
                                case 768: {
                                    n3 = !this.cFlag ? 1 : 0;
                                    break;
                                }
                                case 1024: {
                                    n3 = this.nFlag ? 1 : 0;
                                    break;
                                }
                                case 1280: {
                                    n3 = !this.nFlag ? 1 : 0;
                                    break;
                                }
                                case 1536: {
                                    n3 = this.vFlag ? 1 : 0;
                                    break;
                                }
                                case 1792: {
                                    n3 = !this.vFlag ? 1 : 0;
                                    break;
                                }
                                case 2048: {
                                    n3 = this.cFlag && !this.zFlag ? 1 : 0;
                                    break;
                                }
                                case 2304: {
                                    n3 = !this.cFlag || this.zFlag ? 1 : 0;
                                    break;
                                }
                                case 2560: {
                                    n3 = this.nFlag == this.vFlag ? 1 : 0;
                                    break;
                                }
                                case 2816: {
                                    n3 = this.nFlag != this.vFlag ? 1 : 0;
                                    break;
                                }
                                case 3072: {
                                    n3 = !this.zFlag && this.nFlag == this.vFlag ? 1 : 0;
                                    break;
                                }
                                case 3328: {
                                    n3 = this.zFlag || this.nFlag != this.vFlag ? 1 : 0;
                                    break;
                                }
                                default: {
                                    n3 = 0;
                                }
                            }
                            if (n3 != 0) {
                                n4 = (byte)(n2 & 0xFF) << 1;
                                this.registers[15] = this.registers[15] + n4;
                                this.registers[15] = this.registers[15] & 0xFFFFFFFE;
                                this.pipelineStage1 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                                this.registers[15] = this.registers[15] + 2;
                                this.pipelineStage2 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                                break;
                            }
                            break block127;
                        }
                        case 17: {
                            this.generateInterrupt(19, 8, this.registers[15] - (this.tFlag ? 2 : 4));
                            break;
                        }
                        case 18: {
                            int n3 = (n2 & 0x3FF) << 1;
                            if ((n2 & 0x400) != 0) {
                                n3 |= 0xFFFFF800;
                            }
                            this.registers[15] = this.registers[15] + n3;
                            this.registers[15] = this.registers[15] & 0xFFFFFFFE;
                            this.pipelineStage1 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                            this.registers[15] = this.registers[15] + 2;
                            this.pipelineStage2 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                            break;
                        }
                        case 19: {
                            int n3 = n2 & 0x7FF;
                            if ((n2 & 0x800) == 0) {
                                if ((n2 & 0x400) != 0) {
                                    n3 |= 0xFFFFF800;
                                }
                                this.registers[14] = this.registers[15] + (n3 << 12);
                                break;
                            }
                            int n4 = this.registers[14];
                            int n5 = this.registers[15] - (this.tFlag ? 2 : 4);
                            this.registers[15] = n4 + (n3 << 1);
                            this.registers[14] = n5 | 1;
                            this.registers[15] = this.registers[15] & 0xFFFFFFFE;
                            this.pipelineStage1 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                            this.registers[15] = this.registers[15] + 2;
                            this.pipelineStage2 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                            break;
                        }
                        case 127: {
                            this.generateInterrupt(27, 4, this.registers[15] - (this.tFlag ? 2 : 4));
                        }
                    }
                    break block127;
                }
                this.registers[15] = this.registers[15] + 4;
                n2 = this.pipelineStage1;
                this.pipelineStage1 = this.pipelineStage2;
                this.pipelineStage2 = this.getWord(this.registers[15]);
                by = armInstruction[n2 >>> 12 & 0xFF00 | n2 >>> 4 & 0xFF];
                this.executeARM(n2, by);
            }
            n -= 4;
        }
    }

    private final void executeARM(int n, byte by) {
        switch (by) {
            case 3: {
                if (!this.isPreconditionSatisfied(n)) {
                    return;
                }
                int n2 = n & 0xF;
                int n3 = this.registers[n2];
                this.tFlag = (n3 & 1) != 0;
                this.registers[15] = n3;
                if (this.tFlag) {
                    this.registers[15] = this.registers[15] & 0xFFFFFFFE;
                    this.pipelineStage1 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                    this.registers[15] = this.registers[15] + 2;
                    this.pipelineStage2 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                    break;
                }
                this.registers[15] = this.registers[15] & 0xFFFFFFFC;
                this.pipelineStage1 = this.getWord(this.registers[15]);
                this.registers[15] = this.registers[15] + 4;
                this.pipelineStage2 = this.getWord(this.registers[15]);
                break;
            }
            case 4: {
                if (!this.isPreconditionSatisfied(n)) {
                    return;
                }
                int n4 = n & 0xFFFFFF;
                if ((n4 & 0x800000) != 0) {
                    n4 |= 0xFF000000;
                }
                n4 <<= 2;
                if ((n & 0x1000000) != 0) {
                    this.registers[14] = this.registers[15] - (this.tFlag ? 2 : 4);
                }
                this.registers[15] = this.registers[15] + n4;
                this.registers[15] = this.registers[15] & 0xFFFFFFFC;
                this.pipelineStage1 = this.getWord(this.registers[15]);
                this.registers[15] = this.registers[15] + 4;
                this.pipelineStage2 = this.getWord(this.registers[15]);
                break;
            }
            case 5: {
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                if (!this.isPreconditionSatisfied(n)) {
                    return;
                }
                int n10 = n >>> 16 & 0xF;
                int n11 = this.registers[n10];
                boolean bl = this.cFlag;
                int n12 = n11;
                if ((n & 0x2000000) != 0) {
                    n9 = n & 0xFF;
                    n8 = (n & 0xF00) >>> 7;
                    if (n8 != 0) {
                        bl = (n9 & 1 << n8 - 1) != 0;
                        n9 = n9 << 32 - n8 | n9 >>> n8;
                    }
                } else {
                    n8 = n & 0xF;
                    n7 = this.registers[n8];
                    n6 = n & 0x60;
                    n9 = n7;
                    if ((n & 0x10) == 0) {
                        n5 = n >>> 7 & 0x1F;
                        switch (n6) {
                            case 0: {
                                if (n5 == 0) break;
                                bl = (n9 & 1 << 32 - n5) != 0;
                                n9 <<= n5;
                                break;
                            }
                            case 32: {
                                if (n5 != 0) {
                                    bl = (n9 & 1 << n5 - 1) != 0;
                                    n9 >>>= n5;
                                    break;
                                }
                                bl = (n9 & Integer.MIN_VALUE) != 0;
                                n9 = 0;
                                break;
                            }
                            case 64: {
                                if (n5 != 0) {
                                    bl = (n9 & 1 << n5 - 1) != 0;
                                    n9 >>= n5;
                                    break;
                                }
                                bl = (n9 & Integer.MIN_VALUE) != 0;
                                n9 >>= 31;
                                break;
                            }
                            case 96: {
                                if (n5 != 0) {
                                    bl = (n9 & 1 << n5 - 1) != 0;
                                    n9 = n9 << 32 - n5 | n9 >>> n5;
                                    break;
                                }
                                bl = (n9 & 1) != 0;
                                n9 >>>= 1;
                                if (!bl) break;
                                n9 |= Integer.MIN_VALUE;
                            }
                        }
                    } else {
                        int n13 = n >>> 8 & 0xF;
                        int n14 = this.registers[n13];
                        n5 = n14 + (n13 == 15 ? 4 : 0) & 0xFF;
                        switch (n6) {
                            case 0: {
                                if (n5 == 0) break;
                                if (n5 < 32) {
                                    bl = (n9 & 1 << 32 - n5) != 0;
                                    n9 <<= n5;
                                    break;
                                }
                                if (n5 == 32) {
                                    bl = (n9 & 1) != 0;
                                    n9 = 0;
                                    break;
                                }
                                bl = false;
                                n9 = 0;
                                break;
                            }
                            case 32: {
                                if (n5 == 0) break;
                                if (n5 < 32) {
                                    bl = (n9 & 1 << n5 - 1) != 0;
                                    n9 >>>= n5;
                                    break;
                                }
                                if (n5 == 32) {
                                    bl = (n9 & Integer.MIN_VALUE) != 0;
                                    n9 = 0;
                                    break;
                                }
                                bl = false;
                                n9 = 0;
                                break;
                            }
                            case 64: {
                                if (n5 == 0) break;
                                if (n5 < 32) {
                                    bl = (n9 & 1 << n5 - 1) != 0;
                                    n9 >>= n5;
                                    break;
                                }
                                bl = (n9 & Integer.MIN_VALUE) != 0;
                                n9 >>= 31;
                                break;
                            }
                            case 96: {
                                if (n5 != 0) {
                                    if ((n5 &= 0x1F) != 0) {
                                        bl = (n9 & 1 << n5 - 1) != 0;
                                        n9 = n9 << 32 - n5 | n9 >>> n5;
                                        break;
                                    }
                                    bl = (n9 & Integer.MIN_VALUE) != 0;
                                    break;
                                }
                                bl = (n9 & Integer.MIN_VALUE) != 0;
                            }
                        }
                    }
                }
                n8 = n >>> 12 & 0xF;
                n6 = (n & 0x100000) != 0 ? 1 : 0;
                switch (n & 0x1E00000) {
                    case 0: {
                        this.registers[n8] = n7 = n12 & n9;
                        if (n6 == 0) break;
                        this.cFlag = bl;
                        break;
                    }
                    case 0x200000: {
                        this.registers[n8] = n7 = n12 ^ n9;
                        if (n6 == 0) break;
                        this.cFlag = bl;
                        break;
                    }
                    case 0x400000: {
                        this.registers[n8] = n7 = n12 - n9;
                        if (n6 == 0) break;
                        this.op1 = n12 < 0;
                        this.op2 = n9 < 0;
                        this.res = n7 < 0;
                        this.vFlag = this.op1 && !this.op2 && !this.res || !this.op1 && this.op2 && this.res;
                        this.cFlag = this.op1 && !this.op2 || this.op1 && !this.res || !this.op2 && !this.res;
                        break;
                    }
                    case 0x600000: {
                        this.registers[n8] = n7 = n9 - n12;
                        if (n6 == 0) break;
                        this.op1 = n9 < 0;
                        this.op2 = n12 < 0;
                        this.res = n7 < 0;
                        this.vFlag = this.op1 && !this.op2 && !this.res || !this.op1 && this.op2 && this.res;
                        this.cFlag = this.op1 && !this.op2 || this.op1 && !this.res || !this.op2 && !this.res;
                        break;
                    }
                    case 0x800000: {
                        this.registers[n8] = n7 = n12 + n9;
                        if (n6 == 0) break;
                        this.op1 = n12 < 0;
                        this.op2 = n9 < 0;
                        this.res = n7 < 0;
                        this.vFlag = this.op1 && this.op2 && !this.res || !this.op1 && !this.op2 && this.res;
                        this.cFlag = this.op1 && this.op2 || this.op1 && !this.res || this.op2 && !this.res;
                        break;
                    }
                    case 0xA00000: {
                        this.registers[n8] = n7 = n12 + n9 + (bl ? 1 : 0);
                        if (n6 == 0) break;
                        this.op1 = n12 < 0;
                        this.op2 = n9 < 0;
                        this.res = n7 < 0;
                        this.vFlag = this.op1 && this.op2 && !this.res || !this.op1 && !this.op2 && this.res;
                        this.cFlag = this.op1 && this.op2 || this.op1 && !this.res || this.op2 && !this.res;
                        break;
                    }
                    case 0xC00000: {
                        this.registers[n8] = n7 = n12 - n9 - (bl ? 0 : 1);
                        if (n6 == 0) break;
                        this.op1 = n12 < 0;
                        this.op2 = n9 < 0;
                        this.res = n7 < 0;
                        this.vFlag = this.op1 && !this.op2 && !this.res || !this.op1 && this.op2 && this.res;
                        this.cFlag = this.op1 && !this.op2 || this.op1 && !this.res || !this.op2 && !this.res;
                        break;
                    }
                    case 0xE00000: {
                        this.registers[n8] = n7 = n9 - n12 - (bl ? 0 : 1);
                        if (n6 == 0) break;
                        this.op1 = n9 < 0;
                        this.op2 = n12 < 0;
                        this.res = n7 < 0;
                        this.vFlag = this.op1 && !this.op2 && !this.res || !this.op1 && this.op2 && this.res;
                        this.cFlag = this.op1 && !this.op2 || this.op1 && !this.res || !this.op2 && !this.res;
                        break;
                    }
                    case 0x1000000: {
                        n7 = n12 & n9;
                        this.cFlag = bl;
                        break;
                    }
                    case 0x1200000: {
                        n7 = n12 ^ n9;
                        this.cFlag = bl;
                        break;
                    }
                    case 0x1400000: {
                        n7 = n12 - n9;
                        this.op1 = n12 < 0;
                        this.op2 = n9 < 0;
                        this.res = n7 < 0;
                        this.vFlag = this.op1 && !this.op2 && !this.res || !this.op1 && this.op2 && this.res;
                        this.cFlag = this.op1 && !this.op2 || this.op1 && !this.res || !this.op2 && !this.res;
                        break;
                    }
                    case 0x1600000: {
                        n7 = n12 + n9;
                        this.op1 = n12 < 0;
                        this.op2 = n9 < 0;
                        this.res = n7 < 0;
                        this.vFlag = this.op1 && this.op2 && !this.res || !this.op1 && !this.op2 && this.res;
                        this.cFlag = this.op1 && this.op2 || this.op1 && !this.res || this.op2 && !this.res;
                        break;
                    }
                    case 0x1800000: {
                        this.registers[n8] = n7 = n12 | n9;
                        if (n6 == 0) break;
                        this.cFlag = bl;
                        break;
                    }
                    case 0x1A00000: {
                        this.registers[n8] = n7 = n9;
                        if (n6 == 0) break;
                        this.cFlag = bl;
                        break;
                    }
                    case 0x1C00000: {
                        this.registers[n8] = n7 = n12 & ~n9;
                        if (n6 == 0) break;
                        this.cFlag = bl;
                        break;
                    }
                    case 0x1E00000: {
                        this.registers[n8] = n7 = ~n9;
                        if (n6 == 0) break;
                        this.cFlag = bl;
                        break;
                    }
                    default: {
                        n7 = 0;
                    }
                }
                if (n6 != 0) {
                    this.nFlag = n7 < 0;
                    boolean bl2 = this.zFlag = n7 == 0;
                }
                if (n8 != 15) break;
                if (n6 != 0) {
                    n5 = this.registers[SPSR];
                    this.setMode(n5 & 0x1F);
                    this.tFlag = (n5 & 0x20) != 0;
                    this.fFlag = (n5 & 0x40) != 0;
                    this.iFlag = (n5 & 0x80) != 0;
                    this.vFlag = (n5 & 0x10000000) != 0;
                    this.cFlag = (n5 & 0x20000000) != 0;
                    this.zFlag = (n5 & 0x40000000) != 0;
                    boolean bl3 = this.nFlag = (n5 & Integer.MIN_VALUE) != 0;
                }
                if (this.tFlag) {
                    this.registers[15] = this.registers[15] & 0xFFFFFFFE;
                    this.pipelineStage1 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                    this.registers[15] = this.registers[15] + 2;
                    this.pipelineStage2 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                    break;
                }
                this.registers[15] = this.registers[15] & 0xFFFFFFFC;
                this.pipelineStage1 = this.getWord(this.registers[15]);
                this.registers[15] = this.registers[15] + 4;
                this.pipelineStage2 = this.getWord(this.registers[15]);
                break;
            }
            case 6: {
                int n15;
                int n16;
                int n17;
                int n18;
                if (!this.isPreconditionSatisfied(n)) {
                    return;
                }
                if ((n & 0x400000) == 0) {
                    n18 = 16;
                    n17 = 0;
                    n17 = this.tFlag ? n17 | 0x20 : (n17 |= this.mFlag) & 0xFFFFFFDF;
                    n17 = this.fFlag ? n17 | 0x40 : n17 & 0xFFFFFFBF;
                    n17 = this.iFlag ? n17 | 0x80 : n17 & 0xFFFFFF7F;
                    n17 = this.vFlag ? n17 | 0x10000000 : n17 & 0xEFFFFFFF;
                    n17 = this.cFlag ? n17 | 0x20000000 : n17 & 0xDFFFFFFF;
                    n17 = this.zFlag ? n17 | 0x40000000 : n17 & 0xBFFFFFFF;
                    n16 = n17 = this.nFlag ? n17 | Integer.MIN_VALUE : n17 & Integer.MAX_VALUE;
                } else {
                    if (SPSR == -1) {
                        return;
                    }
                    n18 = SPSR;
                    n16 = this.registers[SPSR];
                }
                if ((n & 0x200000) == 0) {
                    n17 = n >>> 12 & 0xF;
                    this.registers[n17] = n16;
                    break;
                }
                if ((n & 0x2000000) == 0) {
                    n15 = n & 0xF;
                    n17 = this.registers[n15];
                } else {
                    n17 = n & 0xFF;
                    n15 = (n & 0xF00) >>> 7;
                    if (n15 != 0) {
                        n17 = n17 << 32 - n15 | n17 >>> n15;
                    }
                }
                if (this.mFlag != 16) {
                    if ((n & 0x10000) != 0) {
                        n16 = n16 & 0xFFFFFF00 | n17 & 0xFF;
                    }
                    if ((n & 0x20000) != 0) {
                        n16 = n16 & 0xFFFF00FF | n17 & 0xFF00;
                    }
                    if ((n & 0x40000) != 0) {
                        n16 = n16 & 0xFF00FFFF | n17 & 0xFF0000;
                    }
                }
                if ((n & 0x80000) != 0) {
                    n16 = n16 & 0xFFFFFF | n17 & 0xFF000000;
                }
                n16 |= 0x10;
                if (n18 == 16) {
                    this.registers[15] = this.registers[15] - (this.tFlag ? 2 : 4);
                    n15 = n16;
                    this.setMode(n15 & 0x1F);
                    this.tFlag = (n15 & 0x20) != 0;
                    this.fFlag = (n15 & 0x40) != 0;
                    this.iFlag = (n15 & 0x80) != 0;
                    this.vFlag = (n15 & 0x10000000) != 0;
                    this.cFlag = (n15 & 0x20000000) != 0;
                    this.zFlag = (n15 & 0x40000000) != 0;
                    boolean bl = this.nFlag = (n15 & Integer.MIN_VALUE) != 0;
                    if (this.tFlag) {
                        this.registers[15] = this.registers[15] & 0xFFFFFFFE;
                        this.pipelineStage1 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                        this.registers[15] = this.registers[15] + 2;
                        this.pipelineStage2 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                        break;
                    }
                    this.registers[15] = this.registers[15] & 0xFFFFFFFC;
                    this.pipelineStage1 = this.getWord(this.registers[15]);
                    this.registers[15] = this.registers[15] + 4;
                    this.pipelineStage2 = this.getWord(this.registers[15]);
                    break;
                }
                this.registers[n18] = n16;
                break;
            }
            case 7: {
                int n19;
                if (!this.isPreconditionSatisfied(n)) {
                    return;
                }
                int n20 = n & 0xF;
                int n21 = this.registers[n20];
                int n22 = n >>> 8 & 0xF;
                int n23 = this.registers[n22];
                int n24 = n >>> 16 & 0xF;
                if ((n & 0x200000) == 0) {
                    n19 = n21 * n23;
                } else {
                    int n25 = n >>> 12 & 0xF;
                    int n26 = this.registers[n25];
                    n19 = n21 * n23 + n26;
                }
                this.registers[n24] = n19;
                if ((n & 0x100000) == 0) break;
                this.zFlag = n19 == 0;
                this.nFlag = n19 < 0;
                break;
            }
            case 8: {
                long l;
                if (!this.isPreconditionSatisfied(n)) {
                    return;
                }
                int n27 = n >>> 12 & 0xF;
                int n28 = n >>> 16 & 0xF;
                int n29 = this.registers[n & 0xF];
                int n30 = this.registers[n >>> 8 & 0xF];
                switch (n & 0x600000) {
                    case 0: {
                        l = ((long)n29 & 0xFFFFFFFFL) * ((long)n30 & 0xFFFFFFFFL);
                        break;
                    }
                    case 0x200000: {
                        int n31 = this.registers[n27];
                        int n32 = this.registers[n28];
                        l = ((long)n29 & 0xFFFFFFFFL) * ((long)n30 & 0xFFFFFFFFL);
                        l += (long)n32 << 32 | (long)n31 & 0xFFFFFFFFL;
                        break;
                    }
                    case 0x400000: {
                        l = n29 * n30;
                        break;
                    }
                    case 0x600000: {
                        int n33 = this.registers[n27];
                        int n34 = this.registers[n28];
                        l = n29 * n30;
                        l += (long)n34 << 32 | (long)n33 & 0xFFFFFFFFL;
                        break;
                    }
                    default: {
                        l = 0L;
                    }
                }
                this.registers[n27] = (int)l;
                this.registers[n28] = (int)(l >>> 32);
                if ((n & 0x100000) == 0) break;
                this.zFlag = l == 0L;
                this.nFlag = l < 0L;
                break;
            }
            case 9: {
                int n35;
                int n36;
                int n37;
                int n38;
                int n39;
                if (!this.isPreconditionSatisfied(n)) {
                    return;
                }
                int n40 = n >>> 12 & 0xF;
                int n41 = n >>> 16 & 0xF;
                int n42 = this.registers[n41];
                if ((n & 0x2000000) == 0) {
                    n39 = n & 0xFFF;
                } else {
                    n38 = n & 0xF;
                    n37 = this.registers[n38];
                    n36 = n & 0x60;
                    n35 = n >>> 7 & 0x1F;
                    n39 = n37;
                    switch (n36) {
                        case 0: {
                            if (n35 == 0) break;
                            n39 <<= n35;
                            break;
                        }
                        case 32: {
                            if (n35 != 0) {
                                n39 >>>= n35;
                                break;
                            }
                            n39 = 0;
                            break;
                        }
                        case 64: {
                            if (n35 != 0) {
                                n39 >>= n35;
                                break;
                            }
                            n39 >>= 31;
                            break;
                        }
                        case 96: {
                            if (n35 != 0) {
                                n39 = n39 << 32 - n35 | n39 >>> n35;
                                break;
                            }
                            n39 >>>= 1;
                            if (!this.cFlag) break;
                            n39 |= Integer.MIN_VALUE;
                        }
                    }
                }
                n38 = (n & 0x1000000) == 0 ? 1 : 0;
                n37 = (n & 0x800000) == 0 ? 1 : 0;
                n36 = (n & 0x400000) == 0 ? 1 : 0;
                int n43 = n35 = n38 != 0 || (n & 0x200000) != 0 ? 1 : 0;
                if (n37 != 0) {
                    n39 = -n39;
                }
                if (n38 == 0) {
                    n42 += n39;
                }
                if ((n & 0x100000) == 0) {
                    int n44 = this.registers[n40];
                    if (n40 == 15) {
                        n44 += 4;
                    }
                    if (n36 != 0) {
                        this.storeWord(n42, n44);
                    } else {
                        this.storeByte(n42, (byte)n44);
                    }
                } else {
                    this.registers[n40] = n36 != 0 ? this.loadWord(n42) : this.loadByte(n42) & 0xFF;
                    if (n40 == 15) {
                        this.registers[15] = this.registers[15] & 0xFFFFFFFC;
                        this.pipelineStage1 = this.getWord(this.registers[15]);
                        this.registers[15] = this.registers[15] + 4;
                        this.pipelineStage2 = this.getWord(this.registers[15]);
                    }
                    if (n40 == n41) {
                        return;
                    }
                }
                if (n35 == 0) break;
                if (n38 != 0) {
                    n42 += n39;
                }
                this.registers[n41] = n42;
                if (n41 != 15) break;
                this.registers[15] = this.registers[15] & 0xFFFFFFFC;
                this.pipelineStage1 = this.getWord(this.registers[15]);
                this.registers[15] = this.registers[15] + 4;
                this.pipelineStage2 = this.getWord(this.registers[15]);
                break;
            }
            case 10: {
                boolean bl;
                int n45;
                int n46;
                int n47;
                if (!this.isPreconditionSatisfied(n)) {
                    return;
                }
                int n48 = n >>> 12 & 0xF;
                int n49 = n >>> 16 & 0xF;
                int n50 = this.registers[n49];
                if ((n & 0x400000) == 0) {
                    n47 = n & 0xF;
                    n45 = n46 = this.registers[n47];
                } else {
                    n45 = (n & 0xF00) >>> 4 | n & 0xF;
                }
                n47 = (n & 0x1000000) == 0 ? 1 : 0;
                n46 = (n & 0x800000) == 0 ? 1 : 0;
                boolean bl4 = bl = n47 != 0 || (n & 0x200000) != 0;
                if (n46 != 0) {
                    n45 = -n45;
                }
                if (n47 == 0) {
                    n50 += n45;
                }
                int n51 = n & 0x60;
                if ((n & 0x100000) == 0) {
                    if (n51 == 32) {
                        int n52 = this.registers[n48];
                        if (n48 == 15) {
                            n52 += 4;
                        }
                        this.storeHalfWord(n50, (short)n52);
                    }
                } else {
                    switch (n51) {
                        case 32: {
                            this.registers[n48] = this.loadHalfWord(n50) & 0xFFFF;
                            break;
                        }
                        case 64: {
                            this.registers[n48] = this.loadByte(n50);
                            break;
                        }
                        case 96: {
                            this.registers[n48] = this.loadHalfWord(n50);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    if (n48 == 15) {
                        this.registers[15] = this.registers[15] & 0xFFFFFFFC;
                        this.pipelineStage1 = this.getWord(this.registers[15]);
                        this.registers[15] = this.registers[15] + 4;
                        this.pipelineStage2 = this.getWord(this.registers[15]);
                    }
                    if (n48 == n49) {
                        return;
                    }
                }
                if (!bl) break;
                if (n47 != 0) {
                    n50 += n45;
                }
                this.registers[n49] = n50;
                if (n49 != 15) break;
                this.registers[15] = this.registers[15] & 0xFFFFFFFC;
                this.pipelineStage1 = this.getWord(this.registers[15]);
                this.registers[15] = this.registers[15] + 4;
                this.pipelineStage2 = this.getWord(this.registers[15]);
                break;
            }
            case 11: {
                int n53;
                int n54;
                boolean bl;
                int n55;
                int n56;
                if (!this.isPreconditionSatisfied(n)) {
                    return;
                }
                int n57 = n >>> 16 & 0xF;
                int n58 = this.registers[n57];
                int n59 = 0;
                for (n56 = 0; n56 <= 15; ++n56) {
                    if ((n & 1 << n56) == 0) continue;
                    ++n59;
                }
                n56 = n58 & 0xFFFFFFFC;
                if ((n & 0x800000) != 0) {
                    n55 = n56 + (n59 << 2);
                    if ((n & 0x1000000) != 0) {
                        n56 += 4;
                    }
                } else {
                    n56 = n55 = n56 - (n59 << 2);
                    if ((n & 0x1000000) == 0) {
                        n56 += 4;
                    }
                }
                boolean bl5 = (n & 0x8000) != 0;
                boolean bl6 = bl = (n & 0x400000) != 0;
                if ((n & 0x100000) == 0) {
                    int n60;
                    int n61 = bl ? 16 : this.mFlag;
                    for (n60 = 0; n60 < 15; ++n60) {
                        if ((n & 1 << n60) == 0) continue;
                        this.storeWord(n56, this.registers[n60]);
                        n56 += 4;
                        break;
                    }
                    if ((n & 0x200000) != 0) {
                        this.registers[n57] = n58 & 3 | n55;
                    }
                    ++n60;
                    while (n60 < 15) {
                        if ((n & 1 << n60) != 0) {
                            this.storeWord(n56, this.registers[n60]);
                            n56 += 4;
                        }
                        ++n60;
                    }
                    if (!bl5) break;
                    this.storeWord(n56, this.registers[15] + 4);
                    break;
                }
                int n62 = n54 = bl && !bl5 ? 16 : this.mFlag;
                if ((n & 0x200000) != 0) {
                    this.registers[n57] = n58 & 3 | n55;
                }
                for (n53 = 0; n53 < 15; ++n53) {
                    if ((n & 1 << n53) == 0) continue;
                    this.registers[n53] = this.loadWord(n56);
                    n56 += 4;
                }
                if (!bl5) break;
                this.registers[15] = this.loadWord(n56);
                if (bl) {
                    n53 = this.registers[SPSR];
                    this.setMode(n53 & 0x1F);
                    this.tFlag = (n53 & 0x20) != 0;
                    this.fFlag = (n53 & 0x40) != 0;
                    this.iFlag = (n53 & 0x80) != 0;
                    this.vFlag = (n53 & 0x10000000) != 0;
                    this.cFlag = (n53 & 0x20000000) != 0;
                    this.zFlag = (n53 & 0x40000000) != 0;
                    boolean bl7 = this.nFlag = (n53 & Integer.MIN_VALUE) != 0;
                }
                if (this.tFlag) {
                    this.registers[15] = this.registers[15] & 0xFFFFFFFE;
                    this.pipelineStage1 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                    this.registers[15] = this.registers[15] + 2;
                    this.pipelineStage2 = this.getHalfWord(this.registers[15]) & 0xFFFF;
                    break;
                }
                this.registers[15] = this.registers[15] & 0xFFFFFFFC;
                this.pipelineStage1 = this.getWord(this.registers[15]);
                this.registers[15] = this.registers[15] + 4;
                this.pipelineStage2 = this.getWord(this.registers[15]);
                break;
            }
            case 12: {
                if (!this.isPreconditionSatisfied(n)) {
                    return;
                }
                int n63 = n >>> 16 & 0xF;
                int n64 = this.registers[n63];
                int n65 = n & 0xF;
                int n66 = this.registers[n65];
                int n67 = n >>> 12 & 0xF;
                int n68 = this.loadWord(n64);
                if ((n & 0x400000) == 0) {
                    this.registers[n67] = n68;
                    this.storeWord(n64, n66);
                    break;
                }
                this.registers[n67] = n68 & 0xFF;
                this.storeByte(n64, (byte)n66);
                break;
            }
            case 13: {
                if (!this.isPreconditionSatisfied(n)) {
                    return;
                }
                this.generateInterrupt(19, 8, this.registers[15] - (this.tFlag ? 2 : 4));
                break;
            }
            case 17: {
                this.generateInterrupt(27, 4, this.registers[15] - (this.tFlag ? 2 : 4));
            }
        }
    }

    private static final void initARM() {
        armInstruction = new byte[65536];
        for (int i = 0; i < armInstruction.length; ++i) {
            int n;
            int n2 = (i & 0xFF00) << 12 | (i & 0xFF) << 4;
            switch (n2 >>> 25 & 7) {
                case 0: {
                    if ((n2 & 0xFC000F0) == 144) {
                        n = 7;
                        break;
                    }
                    if ((n2 & 0xF8000F0) == 0x800090) {
                        n = 8;
                        break;
                    }
                    if ((n2 & 0xF0000F0) == 0x1000090) {
                        n = 12;
                        break;
                    }
                    if ((n2 & 0xE000090) == 144) {
                        n = 10;
                        break;
                    }
                    if ((n2 & 0xFF00FF0) == 18878224) {
                        n = 3;
                        break;
                    }
                }
                case 1: {
                    if ((n2 & 0xFB00FF0) == 0x1000000 || (n2 & 0xFB00FF0) == 0x1200000 || (n2 & 0xFB00000) == 0x3200000) {
                        n = 6;
                        break;
                    }
                    n = 5;
                    break;
                }
                case 2: 
                case 3: {
                    if ((n2 & 0xE000010) == 0x6000010) {
                        n = 17;
                        break;
                    }
                    n = 9;
                    break;
                }
                case 4: {
                    n = 11;
                    break;
                }
                case 5: {
                    n = 4;
                    break;
                }
                case 6: 
                case 7: {
                    if ((n2 & 0xE000000) == 0xC000000 || (n2 & 0xF000000) == 0xE000000) {
                        n = 18;
                        break;
                    }
                    n = 13;
                    break;
                }
                default: {
                    n = 17;
                }
            }
            GBACore.armInstruction[i] = n;
        }
    }

    private final boolean isPreconditionSatisfied(int n) {
        boolean bl;
        switch (n & 0xF0000000) {
            case 0: {
                bl = this.zFlag;
                break;
            }
            case 0x10000000: {
                bl = !this.zFlag;
                break;
            }
            case 0x20000000: {
                bl = this.cFlag;
                break;
            }
            case 0x30000000: {
                bl = !this.cFlag;
                break;
            }
            case 0x40000000: {
                bl = this.nFlag;
                break;
            }
            case 0x50000000: {
                bl = !this.nFlag;
                break;
            }
            case 0x60000000: {
                bl = this.vFlag;
                break;
            }
            case 0x70000000: {
                bl = !this.vFlag;
                break;
            }
            case -2147483648: {
                bl = this.cFlag && !this.zFlag;
                break;
            }
            case -1879048192: {
                bl = !this.cFlag || this.zFlag;
                break;
            }
            case -1610612736: {
                bl = this.nFlag == this.vFlag;
                break;
            }
            case -1342177280: {
                bl = this.nFlag != this.vFlag;
                break;
            }
            case -1073741824: {
                bl = !this.zFlag && this.nFlag == this.vFlag;
                break;
            }
            case -805306368: {
                bl = this.zFlag || this.nFlag != this.vFlag;
                break;
            }
            case -536870912: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private void Memory_reset() {
        this.writeIO16(0, (short)128);
        this.writeIO16(32, (short)256);
        this.writeIO16(38, (short)256);
        this.writeIO16(48, (short)256);
        this.writeIO16(54, (short)256);
        this.writeIO16(304, (short)1023);
    }

    private void connectToDMA(DirectMemoryAccess directMemoryAccess) {
        this.dma0 = directMemoryAccess.getDMA(0);
        this.dma1 = directMemoryAccess.getDMA(1);
        this.dma2 = directMemoryAccess.getDMA(2);
        this.dma3 = directMemoryAccess.getDMA(3);
    }

    private void connectToTime(Time time) {
        this.timer0 = time.getTimer(0);
        this.timer1 = time.getTimer(1);
        this.timer2 = time.getTimer(2);
        this.timer3 = time.getTimer(3);
    }

    private static short getValue16(boolean bl, short s, byte by) {
        return (short)(bl ? s & 0xFF00 | by & 0xFF : s & 0xFF | by << 8);
    }

    public void generateInterrupt(int n) {
        this.writeIO16(514, (short)(this.readIO16(514) | this.readIO16(512) & n));
    }

    private void enterHBlank() {
        int n = this.ioram[6] & 0xFF;
        this.dma0.signalHBlank();
        this.dma1.signalHBlank();
        this.dma2.signalHBlank();
        this.dma3.signalHBlank();
        this.writeIO16(514, (short)(this.readIO16(514) | this.readIO16(512) & 2));
        byte by = this.ioram[4];
        this.ioram[4] = by = (byte)(by | 2);
        if ((this.ioram[4] & 0x20) != 0 && n == (this.ioram[5] & 0xFF)) {
            this.writeIO16(514, (short)(this.readIO16(514) | this.readIO16(512) & 4));
        }
    }

    private int getXSize(int n) {
        int n2 = n << 3;
        switch ((this.oam[n2 + 1] & 0xC0) >>> 6 | (this.oam[n2 + 3] & 0xC0) >>> 4) {
            case 0: 
            case 2: 
            case 6: {
                return 8;
            }
            case 1: 
            case 4: 
            case 10: {
                return 16;
            }
            case 5: 
            case 8: 
            case 9: 
            case 14: {
                return 32;
            }
            case 12: 
            case 13: {
                return 64;
            }
        }
        return 0;
    }

    private int getYSize(int n) {
        int n2 = n << 3;
        switch ((this.oam[n2 + 1] & 0xC0) >>> 6 | (this.oam[n2 + 3] & 0xC0) >>> 4) {
            case 0: 
            case 1: 
            case 5: {
                return 8;
            }
            case 2: 
            case 4: 
            case 9: {
                return 16;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                return 32;
            }
            case 12: 
            case 14: {
                return 64;
            }
        }
        return 0;
    }

    private short getHalfWord(int n) {
        switch (n >>> 24 & 0xF) {
            case 0: {
                return (short)(this.sysrom[n &= 0x3FFF] & 0xFF | this.sysrom[n + 1] << 8);
            }
            case 1: 
            case 14: 
            case 15: {
                return 0;
            }
            case 2: {
                return (short)(this.ewram[n &= 0x3FFFF] & 0xFF | this.ewram[n + 1] << 8);
            }
            case 3: {
                return (short)(this.iwram[n &= Short.MAX_VALUE] & 0xFF | this.iwram[n + 1] << 8);
            }
            case 4: {
                return (short)(this.ioram[n &= 0x3FF] & 0xFF | this.ioram[n + 1] << 8);
            }
            case 5: {
                return (short)(this.palram[n &= 0x3FF] & 0xFF | this.palram[n + 1] << 8);
            }
            case 6: {
                n = (n & 0xFFFFFF) % this.vram.length;
                return (short)(this.vram[n] & 0xFF | this.vram[n + 1] << 8);
            }
            case 7: {
                return (short)(this.oam[n &= 0x3FF] & 0xFF | this.oam[n + 1] << 8);
            }
        }
        return (short)(this.rom[n &= this.romMask] & 0xFF | this.rom[n + 1] << 8);
    }

    private int getWord(int n) {
        switch (n >>> 24 & 0xF) {
            case 0: {
                return this.sysrom[n &= 0x3FFF] & 0xFF | (this.sysrom[n + 1] & 0xFF) << 8 | (this.sysrom[n + 2] & 0xFF) << 16 | this.sysrom[n + 3] << 24;
            }
            case 1: 
            case 14: 
            case 15: {
                return 0;
            }
            case 2: {
                return this.ewram[n &= 0x3FFFF] & 0xFF | (this.ewram[n + 1] & 0xFF) << 8 | (this.ewram[n + 2] & 0xFF) << 16 | this.ewram[n + 3] << 24;
            }
            case 3: {
                return this.iwram[n &= Short.MAX_VALUE] & 0xFF | (this.iwram[n + 1] & 0xFF) << 8 | (this.iwram[n + 2] & 0xFF) << 16 | this.iwram[n + 3] << 24;
            }
            case 4: {
                return this.ioram[n &= 0x3FF] & 0xFF | (this.ioram[n + 1] & 0xFF) << 8 | (this.ioram[n + 2] & 0xFF) << 16 | this.ioram[n + 3] << 24;
            }
            case 5: {
                return this.palram[n &= 0x3FF] & 0xFF | (this.palram[n + 1] & 0xFF) << 8 | (this.palram[n + 2] & 0xFF) << 16 | this.palram[n + 3] << 24;
            }
            case 6: {
                n = (n & 0xFFFFFF) % this.vram.length;
                return this.vram[n] & 0xFF | (this.vram[n + 1] & 0xFF) << 8 | (this.vram[n + 2] & 0xFF) << 16 | this.vram[n + 3] << 24;
            }
            case 7: {
                return this.oam[n &= 0x3FF] & 0xFF | (this.oam[n + 1] & 0xFF) << 8 | (this.oam[n + 2] & 0xFF) << 16 | this.oam[n + 3] << 24;
            }
        }
        return this.rom[n &= this.romMask] & 0xFF | (this.rom[n + 1] & 0xFF) << 8 | (this.rom[n + 2] & 0xFF) << 16 | this.rom[n + 3] << 24;
    }

    private void setWord(int n, int n2) {
        switch (n >>> 24 & 0xF) {
            case 2: {
                this.ewram[n &= 0x3FFFF] = (byte)n2;
                this.ewram[n + 1] = (byte)(n2 >>> 8);
                this.ewram[n + 2] = (byte)(n2 >>> 16);
                this.ewram[n + 3] = (byte)(n2 >>> 24);
                break;
            }
            case 3: {
                this.iwram[n &= Short.MAX_VALUE] = (byte)n2;
                this.iwram[n + 1] = (byte)(n2 >>> 8);
                this.iwram[n + 2] = (byte)(n2 >>> 16);
                this.iwram[n + 3] = (byte)(n2 >>> 24);
                break;
            }
            case 4: {
                this.ioram[n &= 0x3FF] = (byte)n2;
                this.ioram[n + 1] = (byte)(n2 >>> 8);
                this.ioram[n + 2] = (byte)(n2 >>> 16);
                this.ioram[n + 3] = (byte)(n2 >>> 24);
                break;
            }
            case 5: {
                this.palram[n &= 0x3FF] = (byte)n2;
                this.palram[n + 1] = (byte)(n2 >>> 8);
                this.palram[n + 2] = (byte)(n2 >>> 16);
                this.palram[n + 3] = (byte)(n2 >>> 24);
                break;
            }
            case 6: {
                n = (n & 0xFFFFFF) % this.vram.length;
                this.vram[n] = (byte)n2;
                this.vram[n + 1] = (byte)(n2 >>> 8);
                this.vram[n + 2] = (byte)(n2 >>> 16);
                this.vram[n + 3] = (byte)(n2 >>> 24);
                break;
            }
            case 7: {
                this.oam[n &= 0x3FF] = (byte)n2;
                this.oam[n + 1] = (byte)(n2 >>> 8);
                this.oam[n + 2] = (byte)(n2 >>> 16);
                this.oam[n + 3] = (byte)(n2 >>> 24);
            }
        }
    }

    private byte loadByte(int n) {
        switch (n >>> 24 & 0xF) {
            case 0: {
                return this.sysrom[n & 0x3FFF];
            }
            case 1: 
            case 15: {
                return 0;
            }
            case 2: {
                return this.ewram[n & 0x3FFFF];
            }
            case 3: {
                return this.iwram[n & Short.MAX_VALUE];
            }
            case 4: {
                return this.in(n);
            }
            case 5: {
                return this.palram[n & 0x3FF];
            }
            case 6: {
                return this.vram[(n & 0xFFFFFF) % this.vram.length];
            }
            case 7: {
                return this.oam[n & 0x3FF];
            }
            case 14: {
                return this.sram[n & 0xFFFF];
            }
        }
        return this.rom[n & this.romMask];
    }

    public short loadHalfWord(int n) {
        switch (n >>> 24 & 0xF) {
            case 0: {
                return (short)(this.sysrom[n &= 0x3FFF] & 0xFF | this.sysrom[n + 1] << 8);
            }
            case 1: 
            case 14: 
            case 15: {
                return 0;
            }
            case 2: {
                return (short)(this.ewram[n &= 0x3FFFF] & 0xFF | this.ewram[n + 1] << 8);
            }
            case 3: {
                return (short)(this.iwram[n &= Short.MAX_VALUE] & 0xFF | this.iwram[n + 1] << 8);
            }
            case 4: {
                return (short)(this.in(n &= 0xFFFFFFFE) & 0xFF | this.in(n + 1) << 8);
            }
            case 5: {
                return (short)(this.palram[n &= 0x3FF] & 0xFF | this.palram[n + 1] << 8);
            }
            case 6: {
                n = (n & 0xFFFFFF) % this.vram.length;
                return (short)(this.vram[n] & 0xFF | this.vram[n + 1] << 8);
            }
            case 7: {
                return (short)(this.oam[n &= 0x3FF] & 0xFF | this.oam[n + 1] << 8);
            }
        }
        return (short)(this.rom[n &= this.romMask] & 0xFF | this.rom[n + 1] << 8);
    }

    public int loadWord(int n) {
        switch (n >>> 24 & 0xF) {
            case 0: {
                return this.sysrom[n &= 0x3FFF] & 0xFF | (this.sysrom[n + 1] & 0xFF) << 8 | (this.sysrom[n + 2] & 0xFF) << 16 | this.sysrom[n + 3] << 24;
            }
            case 1: 
            case 14: 
            case 15: {
                return 0;
            }
            case 2: {
                return this.ewram[n &= 0x3FFFF] & 0xFF | (this.ewram[n + 1] & 0xFF) << 8 | (this.ewram[n + 2] & 0xFF) << 16 | this.ewram[n + 3] << 24;
            }
            case 3: {
                return this.iwram[n &= Short.MAX_VALUE] & 0xFF | (this.iwram[n + 1] & 0xFF) << 8 | (this.iwram[n + 2] & 0xFF) << 16 | this.iwram[n + 3] << 24;
            }
            case 4: {
                return this.in(n &= 0xFFFFFFFC) & 0xFF | (this.in(n + 1) & 0xFF) << 8 | (this.in(n + 2) & 0xFF) << 16 | this.in(n + 3) << 24;
            }
            case 5: {
                return this.palram[n &= 0x3FF] & 0xFF | (this.palram[n + 1] & 0xFF) << 8 | (this.palram[n + 2] & 0xFF) << 16 | this.palram[n + 3] << 24;
            }
            case 6: {
                n = (n & 0xFFFFFF) % this.vram.length;
                return this.vram[n] & 0xFF | (this.vram[n + 1] & 0xFF) << 8 | (this.vram[n + 2] & 0xFF) << 16 | this.vram[n + 3] << 24;
            }
            case 7: {
                return this.oam[n &= 0x3FF] & 0xFF | (this.oam[n + 1] & 0xFF) << 8 | (this.oam[n + 2] & 0xFF) << 16 | this.oam[n + 3] << 24;
            }
        }
        return this.rom[n &= this.romMask] & 0xFF | (this.rom[n + 1] & 0xFF) << 8 | (this.rom[n + 2] & 0xFF) << 16 | this.rom[n + 3] << 24;
    }

    private void storeByte(int n, byte by) {
        switch (n >>> 24 & 0xF) {
            case 2: {
                this.ewram[n & 0x3FFFF] = by;
                break;
            }
            case 3: {
                this.iwram[n & Short.MAX_VALUE] = by;
                break;
            }
            case 4: {
                this.out(n, by);
                break;
            }
            case 14: {
                this.sram[n & 0xFFFF] = by;
            }
        }
    }

    public void storeHalfWord(int n, short s) {
        switch (n >>> 24 & 0xF) {
            case 2: {
                this.ewram[n &= 0x3FFFF] = (byte)s;
                this.ewram[n + 1] = (byte)(s >>> 8);
                break;
            }
            case 3: {
                this.iwram[n &= Short.MAX_VALUE] = (byte)s;
                this.iwram[n + 1] = (byte)(s >>> 8);
                break;
            }
            case 4: {
                this.out(n &= 0xFFFFFFFE, (byte)s);
                this.out(n + 1, (byte)(s >>> 8));
                break;
            }
            case 5: {
                this.palram[n &= 0x3FF] = (byte)s;
                this.palram[n + 1] = (byte)(s >>> 8);
                break;
            }
            case 6: {
                n = (n & 0xFFFFFF) % this.vram.length;
                this.vram[n] = (byte)s;
                this.vram[n + 1] = (byte)(s >>> 8);
                break;
            }
            case 7: {
                this.oam[n &= 0x3FF] = (byte)s;
                this.oam[n + 1] = (byte)(s >>> 8);
            }
        }
    }

    public void storeWord(int n, int n2) {
        switch (n >>> 24 & 0xF) {
            case 2: {
                this.ewram[n &= 0x3FFFF] = (byte)n2;
                this.ewram[n + 1] = (byte)(n2 >>> 8);
                this.ewram[n + 2] = (byte)(n2 >>> 16);
                this.ewram[n + 3] = (byte)(n2 >>> 24);
                break;
            }
            case 3: {
                this.iwram[n &= Short.MAX_VALUE] = (byte)n2;
                this.iwram[n + 1] = (byte)(n2 >>> 8);
                this.iwram[n + 2] = (byte)(n2 >>> 16);
                this.iwram[n + 3] = (byte)(n2 >>> 24);
                break;
            }
            case 4: {
                this.out(n &= 0xFFFFFFFC, (byte)n2);
                this.out(n + 1, (byte)(n2 >>> 8));
                this.out(n + 2, (byte)(n2 >>> 16));
                this.out(n + 3, (byte)(n2 >>> 24));
                break;
            }
            case 5: {
                this.palram[n &= 0x3FF] = (byte)n2;
                this.palram[n + 1] = (byte)(n2 >>> 8);
                this.palram[n + 2] = (byte)(n2 >>> 16);
                this.palram[n + 3] = (byte)(n2 >>> 24);
                break;
            }
            case 6: {
                n = (n & 0xFFFFFF) % this.vram.length;
                this.vram[n] = (byte)n2;
                this.vram[n + 1] = (byte)(n2 >>> 8);
                this.vram[n + 2] = (byte)(n2 >>> 16);
                this.vram[n + 3] = (byte)(n2 >>> 24);
                break;
            }
            case 7: {
                this.oam[n &= 0x3FF] = (byte)n2;
                this.oam[n + 1] = (byte)(n2 >>> 8);
                this.oam[n + 2] = (byte)(n2 >>> 16);
                this.oam[n + 3] = (byte)(n2 >>> 24);
            }
        }
    }

    private byte in(int n) {
        int n2 = (n &= 0x3FF) & 0xFFFFFFFE;
        switch (n2) {
            case 176: {
                this.writeIO16(n2, this.dma0.getSourceLRegister());
                break;
            }
            case 178: {
                this.writeIO16(n2, this.dma0.getSourceHRegister());
                break;
            }
            case 180: {
                this.writeIO16(n2, this.dma0.getDestinationLRegister());
                break;
            }
            case 182: {
                this.writeIO16(n2, this.dma0.getDestinationHRegister());
                break;
            }
            case 184: {
                this.writeIO16(n2, this.dma0.getCountRegister());
                break;
            }
            case 186: {
                this.writeIO16(n2, this.dma0.getControlRegister());
                break;
            }
            case 188: {
                this.writeIO16(n2, this.dma1.getSourceLRegister());
                break;
            }
            case 190: {
                this.writeIO16(n2, this.dma1.getSourceHRegister());
                break;
            }
            case 192: {
                this.writeIO16(n2, this.dma1.getDestinationLRegister());
                break;
            }
            case 194: {
                this.writeIO16(n2, this.dma1.getDestinationHRegister());
                break;
            }
            case 196: {
                this.writeIO16(n2, this.dma1.getCountRegister());
                break;
            }
            case 198: {
                this.writeIO16(n2, this.dma1.getControlRegister());
                break;
            }
            case 200: {
                this.writeIO16(n2, this.dma2.getSourceLRegister());
                break;
            }
            case 202: {
                this.writeIO16(n2, this.dma2.getSourceHRegister());
                break;
            }
            case 204: {
                this.writeIO16(n2, this.dma2.getDestinationLRegister());
                break;
            }
            case 206: {
                this.writeIO16(n2, this.dma2.getDestinationHRegister());
                break;
            }
            case 208: {
                this.writeIO16(n2, this.dma2.getCountRegister());
                break;
            }
            case 210: {
                this.writeIO16(n2, this.dma2.getControlRegister());
                break;
            }
            case 212: {
                this.writeIO16(n2, this.dma3.getSourceLRegister());
                break;
            }
            case 214: {
                this.writeIO16(n2, this.dma3.getSourceHRegister());
                break;
            }
            case 216: {
                this.writeIO16(n2, this.dma3.getDestinationLRegister());
                break;
            }
            case 218: {
                this.writeIO16(n2, this.dma3.getDestinationHRegister());
                break;
            }
            case 220: {
                this.writeIO16(n2, this.dma3.getCountRegister());
                break;
            }
            case 222: {
                this.writeIO16(n2, this.dma3.getControlRegister());
                break;
            }
            case 256: {
                this.writeIO16(n2, this.timer0.getTime());
                break;
            }
            case 260: {
                this.writeIO16(n2, this.timer1.getTime());
                break;
            }
            case 264: {
                this.writeIO16(n2, this.timer2.getTime());
                break;
            }
            case 268: {
                this.writeIO16(n2, this.timer3.getTime());
            }
        }
        return this.ioram[n];
    }

    private void out(int n, byte by) {
        int n2 = (n &= 0x3FF) & 0xFFFFFFFE;
        boolean bl = (n & 1) == 0;
        short s = GBACore.getValue16(bl, this.readIO16(n2), by);
        switch (n2) {
            case 6: {
                return;
            }
            case 176: {
                this.dma0.setSourceLRegister(s);
                break;
            }
            case 178: {
                this.dma0.setSourceHRegister(s);
                break;
            }
            case 180: {
                this.dma0.setDestinationLRegister(s);
                break;
            }
            case 182: {
                this.dma0.setDestinationHRegister(s);
                break;
            }
            case 184: {
                this.dma0.setCountRegister(s);
                break;
            }
            case 186: {
                this.dma0.setControlRegister(s);
                break;
            }
            case 188: {
                this.dma1.setSourceLRegister(s);
                break;
            }
            case 190: {
                this.dma1.setSourceHRegister(s);
                break;
            }
            case 192: {
                this.dma1.setDestinationLRegister(s);
                break;
            }
            case 194: {
                this.dma1.setDestinationHRegister(s);
                break;
            }
            case 196: {
                this.dma1.setCountRegister(s);
                break;
            }
            case 198: {
                this.dma1.setControlRegister(s);
                break;
            }
            case 200: {
                this.dma2.setSourceLRegister(s);
                break;
            }
            case 202: {
                this.dma2.setSourceHRegister(s);
                break;
            }
            case 204: {
                this.dma2.setDestinationLRegister(s);
                break;
            }
            case 206: {
                this.dma2.setDestinationHRegister(s);
                break;
            }
            case 208: {
                this.dma2.setCountRegister(s);
                break;
            }
            case 210: {
                this.dma2.setControlRegister(s);
                break;
            }
            case 212: {
                s = GBACore.getValue16(bl, this.dma3.getSourceLRegister(), by);
                this.dma3.setSourceLRegister(s);
                break;
            }
            case 214: {
                s = GBACore.getValue16(bl, this.dma3.getSourceHRegister(), by);
                this.dma3.setSourceHRegister(s);
                break;
            }
            case 216: {
                s = GBACore.getValue16(bl, this.dma3.getDestinationLRegister(), by);
                this.dma3.setDestinationLRegister(s);
                break;
            }
            case 218: {
                s = GBACore.getValue16(bl, this.dma3.getDestinationHRegister(), by);
                this.dma3.setDestinationHRegister(s);
                break;
            }
            case 220: {
                s = GBACore.getValue16(bl, this.dma3.getCountRegister(), by);
                this.dma3.setCountRegister(s);
                break;
            }
            case 222: {
                s = GBACore.getValue16(bl, this.dma3.getControlRegister(), by);
                this.dma3.setControlRegister(s);
                break;
            }
            case 256: {
                this.timer0.setTime(s);
                break;
            }
            case 258: {
                this.timer0.updateState(s);
                break;
            }
            case 260: {
                this.timer1.setTime(s);
                break;
            }
            case 262: {
                this.timer1.updateState(s);
                break;
            }
            case 264: {
                this.timer2.setTime(s);
                break;
            }
            case 266: {
                this.timer2.updateState(s);
                break;
            }
            case 268: {
                this.timer3.setTime(s);
                break;
            }
            case 270: {
                this.timer3.updateState(s);
                break;
            }
            case 304: {
                return;
            }
            case 514: {
                int n3 = n;
                this.ioram[n3] = (byte)(this.ioram[n3] & ~by);
                return;
            }
        }
        this.ioram[n] = by;
    }

    private short readIO16(int n) {
        return (short)(this.ioram[n] & 0xFF | this.ioram[n + 1] << 8);
    }

    private void writeIO16(int n, short s) {
        this.ioram[n] = (byte)s;
        this.ioram[n + 1] = (byte)(s >>> 8);
    }

    private short readPal16(int n) {
        return (short)(this.palram[n &= 0x3FF] & 0xFF | this.palram[n + 1] << 8);
    }

    private short readVRam16(int n) {
        n = (n & 0xFFFFFF) % this.vram.length;
        return (short)(this.vram[n] & 0xFF | this.vram[n + 1] << 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int loadROM(InputStream inputStream, int n) {
        int n2 = 0;
        try {
            this.rom = new byte[n];
            inputStream.read(this.rom, 0, n);
            inputStream.close();
            this.romMask = 1;
            while (this.romMask <= 0x1FFFFFF && n - 1 > this.romMask) {
                this.romMask = this.romMask << 1 | 1;
            }
            inputStream = this.getClass().getResourceAsStream("/bios.bin");
            inputStream.read(this.sysrom, 0, 16384);
            inputStream.close();
        }
        catch (IOException iOException) {
            n2 = -1;
        }
        finally {
            inputStream = null;
        }
        return n2;
    }

    private void connectToGBACanvas(GBACanvas gBACanvas) {
        this.gui = gBACanvas;
    }

    private void gfx_reset() {
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = 0;
        }
    }

    public void drawLine() {
        block26: for (int i = 0; i < 160; ++i) {
            switch (this.ioram[0] & 7) {
                case 0: {
                    short s;
                    int n;
                    int n2;
                    int n3;
                    short s2;
                    short s3;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    boolean bl;
                    short s4;
                    short s5;
                    int n15;
                    int n16;
                    int n17;
                    int n18;
                    int n19;
                    int n20;
                    int n21;
                    int n22;
                    int n23;
                    this.bg0Enabled = (this.ioram[1] & 1) != 0;
                    this.bg1Enabled = (this.ioram[1] & 2) != 0;
                    this.bg2Enabled = (this.ioram[1] & 4) != 0;
                    this.bg3Enabled = (this.ioram[1] & 8) != 0;
                    this.objEnabled = (this.ioram[1] & 0x10) != 0;
                    this.bg0Priority = this.ioram[8] & 3;
                    this.bg1Priority = this.ioram[10] & 3;
                    this.bg2Priority = this.ioram[12] & 3;
                    this.bg3Priority = this.ioram[14] & 3;
                    this.drawBGLine(i);
                    for (n23 = 3; n23 >= 0; --n23) {
                        if (this.bg3Enabled && this.bg3Priority == n23) {
                            n22 = (this.ioram[14] & 0xC) << 12;
                            n21 = (this.ioram[15] & 0x1F) << 11;
                            n20 = (this.ioram[15] & 0x40) == 0 ? 256 : 512;
                            n19 = (this.ioram[15] & 0x80) == 0 ? 256 : 512;
                            n18 = n20 - 1;
                            n17 = n19 - 1;
                            n16 = (short)(this.ioram[28] & 0xFF | this.ioram[29] << 8) & 0x1FF;
                            n15 = (short)(this.ioram[30] & 0xFF | this.ioram[31] << 8) & 0x1FF;
                            s5 = n20 != 256 ? (short)1 : 0;
                            s4 = (this.ioram[14] & 0x80) != 0 ? (short)1 : 0;
                            bl = (this.ioram[14] & 0x40) != 0;
                            n14 = (this.ioram[76] & 0xF) + 1;
                            n13 = (this.ioram[76] >>> 4 & 0xF) + 1;
                            n12 = bl ? i - i % n13 : i;
                            n12 = n12 + n15 & n17;
                            n11 = 0;
                            if (s5 != 0) {
                                if (n12 >= 256) {
                                    n11 = 4096;
                                }
                                n12 &= 0xFF;
                            }
                            n10 = (n12 >>> 3) * 32;
                            n9 = n12 & 7;
                            for (n8 = 0; n8 < 240; ++n8) {
                                n7 = bl ? n8 - n8 % n14 : n8;
                                n7 = n7 + n16 & n18;
                                n6 = 0;
                                if (s5 != 0) {
                                    if (n7 >= 256) {
                                        n6 = 2048;
                                    }
                                    n7 &= 0xFF;
                                }
                                n5 = n7 >>> 3;
                                n4 = n7 & 7;
                                s3 = (n10 + n5) * 2 + (n11 + n6);
                                s2 = this.readVRam16(n21 + s3);
                                n3 = s2 & 0x3FF;
                                if ((s2 & 0x400) != 0) {
                                    n4 = 7 - n4;
                                }
                                if ((s2 & 0x800) != 0) {
                                    n9 = 7 - n9;
                                }
                                if (s4 != 0) {
                                    n2 = this.vram[(n22 + n3 * 8 * 8 + n9 * 8 + n4 & 0xFFFFFF) % this.vram.length] & 0xFF;
                                    if (n2 == 0) continue;
                                    n = this.readPal16(n2 * 2);
                                    this.pixels[i * 240 + n8] = GBACore.toRGBA((short)n);
                                    continue;
                                }
                                n2 = this.vram[(n22 + n3 * 8 * 4 + n9 * 4 + n4 / 2 & 0xFFFFFF) % this.vram.length] & 0xFF;
                                n2 = (n4 & 1) != 0 ? (n2 >>>= 4) : (n2 &= 0xF);
                                if (n2 == 0) continue;
                                n = s2 >>> 12 & 0xF;
                                s = this.readPal16((n * 16 + n2) * 2);
                                this.pixels[i * 240 + n8] = GBACore.toRGBA(s);
                            }
                        }
                        if (this.bg2Enabled && this.bg2Priority == n23) {
                            n22 = (this.ioram[12] & 0xC) << 12;
                            n21 = (this.ioram[13] & 0x1F) << 11;
                            n20 = (this.ioram[13] & 0x40) == 0 ? 256 : 512;
                            n19 = (this.ioram[13] & 0x80) == 0 ? 256 : 512;
                            n18 = n20 - 1;
                            n17 = n19 - 1;
                            n16 = (short)(this.ioram[24] & 0xFF | this.ioram[25] << 8) & 0x1FF;
                            n15 = (short)(this.ioram[26] & 0xFF | this.ioram[27] << 8) & 0x1FF;
                            s5 = n20 != 256 ? (short)1 : 0;
                            s4 = (this.ioram[12] & 0x80) != 0 ? (short)1 : 0;
                            bl = (this.ioram[12] & 0x40) != 0;
                            n14 = (this.ioram[76] & 0xF) + 1;
                            n13 = (this.ioram[76] >>> 4 & 0xF) + 1;
                            n12 = bl ? i - i % n13 : i;
                            n12 = n12 + n15 & n17;
                            n11 = 0;
                            if (s5 != 0) {
                                if (n12 >= 256) {
                                    n11 = 4096;
                                }
                                n12 &= 0xFF;
                            }
                            n10 = (n12 >>> 3) * 32;
                            n9 = n12 & 7;
                            for (n8 = 0; n8 < 240; ++n8) {
                                n7 = bl ? n8 - n8 % n14 : n8;
                                n7 = n7 + n16 & n18;
                                n6 = 0;
                                if (s5 != 0) {
                                    if (n7 >= 256) {
                                        n6 = 2048;
                                    }
                                    n7 &= 0xFF;
                                }
                                n5 = n7 >>> 3;
                                n4 = n7 & 7;
                                s3 = (n10 + n5) * 2 + (n11 + n6);
                                s2 = this.readVRam16(n21 + s3);
                                n3 = s2 & 0x3FF;
                                if ((s2 & 0x400) != 0) {
                                    n4 = 7 - n4;
                                }
                                if ((s2 & 0x800) != 0) {
                                    n9 = 7 - n9;
                                }
                                if (s4 != 0) {
                                    n2 = this.vram[(n22 + n3 * 8 * 8 + n9 * 8 + n4 & 0xFFFFFF) % this.vram.length] & 0xFF;
                                    if (n2 == 0) continue;
                                    n = this.readPal16(n2 * 2);
                                    this.pixels[i * 240 + n8] = GBACore.toRGBA((short)n);
                                    continue;
                                }
                                n2 = this.vram[(n22 + n3 * 8 * 4 + n9 * 4 + n4 / 2 & 0xFFFFFF) % this.vram.length] & 0xFF;
                                n2 = (n4 & 1) != 0 ? (n2 >>>= 4) : (n2 &= 0xF);
                                if (n2 == 0) continue;
                                n = s2 >>> 12 & 0xF;
                                s = this.readPal16((n * 16 + n2) * 2);
                                this.pixels[i * 240 + n8] = GBACore.toRGBA(s);
                            }
                        }
                        if (this.bg1Enabled && this.bg1Priority == n23) {
                            n22 = (this.ioram[10] & 0xC) << 12;
                            n21 = (this.ioram[11] & 0x1F) << 11;
                            n20 = (this.ioram[11] & 0x40) == 0 ? 256 : 512;
                            n19 = (this.ioram[11] & 0x80) == 0 ? 256 : 512;
                            n18 = n20 - 1;
                            n17 = n19 - 1;
                            n16 = (short)(this.ioram[20] & 0xFF | this.ioram[21] << 8) & 0x1FF;
                            n15 = (short)(this.ioram[22] & 0xFF | this.ioram[23] << 8) & 0x1FF;
                            s5 = n20 != 256 ? (short)1 : 0;
                            s4 = (this.ioram[10] & 0x80) != 0 ? (short)1 : 0;
                            bl = (this.ioram[10] & 0x40) != 0;
                            n14 = (this.ioram[76] & 0xF) + 1;
                            n13 = (this.ioram[76] >>> 4 & 0xF) + 1;
                            n12 = bl ? i - i % n13 : i;
                            n12 = n12 + n15 & n17;
                            n11 = 0;
                            if (s5 != 0) {
                                if (n12 >= 256) {
                                    n11 = 4096;
                                }
                                n12 &= 0xFF;
                            }
                            n10 = (n12 >>> 3) * 32;
                            n9 = n12 & 7;
                            for (n8 = 0; n8 < 240; ++n8) {
                                n7 = bl ? n8 - n8 % n14 : n8;
                                n7 = n7 + n16 & n18;
                                n6 = 0;
                                if (s5 != 0) {
                                    if (n7 >= 256) {
                                        n6 = 2048;
                                    }
                                    n7 &= 0xFF;
                                }
                                n5 = n7 >>> 3;
                                n4 = n7 & 7;
                                s3 = (n10 + n5) * 2 + (n11 + n6);
                                s2 = this.readVRam16(n21 + s3);
                                n3 = s2 & 0x3FF;
                                if ((s2 & 0x400) != 0) {
                                    n4 = 7 - n4;
                                }
                                if ((s2 & 0x800) != 0) {
                                    n9 = 7 - n9;
                                }
                                if (s4 != 0) {
                                    n2 = this.vram[(n22 + n3 * 8 * 8 + n9 * 8 + n4 & 0xFFFFFF) % this.vram.length] & 0xFF;
                                    if (n2 == 0) continue;
                                    n = this.readPal16(n2 * 2);
                                    this.pixels[i * 240 + n8] = GBACore.toRGBA((short)n);
                                    continue;
                                }
                                n2 = this.vram[(n22 + n3 * 8 * 4 + n9 * 4 + n4 / 2 & 0xFFFFFF) % this.vram.length] & 0xFF;
                                n2 = (n4 & 1) != 0 ? (n2 >>>= 4) : (n2 &= 0xF);
                                if (n2 == 0) continue;
                                n = s2 >>> 12 & 0xF;
                                s = this.readPal16((n * 16 + n2) * 2);
                                this.pixels[i * 240 + n8] = GBACore.toRGBA(s);
                            }
                        }
                        if (this.bg0Enabled && this.bg0Priority == n23) {
                            n22 = (this.ioram[8] & 0xC) << 12;
                            n21 = (this.ioram[9] & 0x1F) << 11;
                            n20 = (this.ioram[9] & 0x40) == 0 ? 256 : 512;
                            n19 = (this.ioram[9] & 0x80) == 0 ? 256 : 512;
                            n18 = n20 - 1;
                            n17 = n19 - 1;
                            n16 = (short)(this.ioram[16] & 0xFF | this.ioram[17] << 8) & 0x1FF;
                            n15 = (short)(this.ioram[18] & 0xFF | this.ioram[19] << 8) & 0x1FF;
                            s5 = n20 != 256 ? (short)1 : 0;
                            s4 = (this.ioram[8] & 0x80) != 0 ? (short)1 : 0;
                            bl = (this.ioram[8] & 0x40) != 0;
                            n14 = (this.ioram[76] & 0xF) + 1;
                            n13 = (this.ioram[76] >>> 4 & 0xF) + 1;
                            n12 = bl ? i - i % n13 : i;
                            n12 = n12 + n15 & n17;
                            n11 = 0;
                            if (s5 != 0) {
                                if (n12 >= 256) {
                                    n11 = 4096;
                                }
                                n12 &= 0xFF;
                            }
                            n10 = (n12 >>> 3) * 32;
                            n9 = n12 & 7;
                            for (n8 = 0; n8 < 240; ++n8) {
                                n7 = bl ? n8 - n8 % n14 : n8;
                                n7 = n7 + n16 & n18;
                                n6 = 0;
                                if (s5 != 0) {
                                    if (n7 >= 256) {
                                        n6 = 2048;
                                    }
                                    n7 &= 0xFF;
                                }
                                n5 = n7 >>> 3;
                                n4 = n7 & 7;
                                s3 = (n10 + n5) * 2 + (n11 + n6);
                                s2 = this.readVRam16(n21 + s3);
                                n3 = s2 & 0x3FF;
                                if ((s2 & 0x400) != 0) {
                                    n4 = 7 - n4;
                                }
                                if ((s2 & 0x800) != 0) {
                                    n9 = 7 - n9;
                                }
                                if (s4 != 0) {
                                    n2 = this.vram[(n22 + n3 * 8 * 8 + n9 * 8 + n4 & 0xFFFFFF) % this.vram.length] & 0xFF;
                                    if (n2 == 0) continue;
                                    n = this.readPal16(n2 * 2);
                                    this.pixels[i * 240 + n8] = GBACore.toRGBA((short)n);
                                    continue;
                                }
                                n2 = this.vram[(n22 + n3 * 8 * 4 + n9 * 4 + n4 / 2 & 0xFFFFFF) % this.vram.length] & 0xFF;
                                n2 = (n4 & 1) != 0 ? (n2 >>>= 4) : (n2 &= 0xF);
                                if (n2 == 0) continue;
                                n = s2 >>> 12 & 0xF;
                                s = this.readPal16((n * 16 + n2) * 2);
                                this.pixels[i * 240 + n8] = GBACore.toRGBA(s);
                            }
                        }
                        if (!this.objEnabled) continue;
                        this.drawOBJLine(i, n23);
                    }
                    continue block26;
                }
                case 1: {
                    short s;
                    int n;
                    int n2;
                    int n3;
                    short s2;
                    short s3;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    boolean bl;
                    short s4;
                    short s5;
                    int n15;
                    int n16;
                    int n17;
                    int n18;
                    int n19;
                    int n20;
                    int n21;
                    int n22;
                    int n23;
                    this.bg0Enabled = (this.ioram[1] & 1) != 0;
                    this.bg1Enabled = (this.ioram[1] & 2) != 0;
                    this.bg2Enabled = (this.ioram[1] & 4) != 0;
                    this.objEnabled = (this.ioram[1] & 0x10) != 0;
                    this.bg0Priority = this.ioram[8] & 3;
                    this.bg1Priority = this.ioram[10] & 3;
                    this.bg2Priority = this.ioram[12] & 3;
                    this.drawBGLine(i);
                    for (n23 = 3; n23 >= 0; --n23) {
                        if (this.bg2Enabled & this.bg2Priority == n23) {
                            n22 = (this.ioram[12] & 0xC) << 12;
                            n21 = (this.ioram[13] & 0x1F) << 11;
                            switch (this.ioram[13] & 0xC0) {
                                case 0: {
                                    n20 = 128;
                                    n19 = 127;
                                    break;
                                }
                                case 64: {
                                    n20 = 256;
                                    n19 = 255;
                                    break;
                                }
                                case 128: {
                                    n20 = 512;
                                    n19 = 511;
                                    break;
                                }
                                case 192: {
                                    n20 = 1024;
                                    n19 = 1023;
                                    break;
                                }
                                default: {
                                    n20 = 0;
                                    n19 = -1;
                                }
                            }
                            n18 = (this.ioram[40] & 0xFF | (this.ioram[41] & 0xFF) << 8 | (this.ioram[42] & 0xFF) << 16 | this.ioram[43] << 24) << 4 >> 4;
                            n17 = (this.ioram[44] & 0xFF | (this.ioram[45] & 0xFF) << 8 | (this.ioram[46] & 0xFF) << 16 | this.ioram[47] << 24) << 4 >> 4;
                            n16 = (short)(this.ioram[32] & 0xFF | this.ioram[33] << 8);
                            n15 = (short)(this.ioram[34] & 0xFF | this.ioram[35] << 8);
                            s5 = (short)(this.ioram[36] & 0xFF | this.ioram[37] << 8);
                            s4 = (short)(this.ioram[38] & 0xFF | this.ioram[39] << 8);
                            bl = (this.ioram[13] & 0x20) != 0;
                            n14 = i * n15 + n18;
                            n13 = i * s4 + n17;
                            for (n12 = 0; n12 < 240; ++n12) {
                                n11 = n14 >> 8;
                                n10 = n13 >> 8;
                                if (bl) {
                                    n11 &= n19;
                                    n10 &= n19;
                                }
                                if (n11 >= 0 && n11 < n20 && n10 >= 0 && n10 < n20 && (n4 = this.vram[(n22 + (n5 = this.vram[(n21 + (n8 = n10 >>> 3) * (n20 / 8) + (n9 = n11 >>> 3) & 0xFFFFFF) % this.vram.length] & 0xFF) * 8 * 8 + (n6 = n10 & 7) * 8 + (n7 = n11 & 7) & 0xFFFFFF) % this.vram.length] & 0xFF) != 0) {
                                    s3 = this.readPal16(n4 * 2);
                                    this.pixels[i * 240 + n12] = GBACore.toRGBA(s3);
                                }
                                n14 += n16;
                                n13 += s5;
                            }
                        }
                        if (this.bg1Enabled & this.bg1Priority == n23) {
                            n22 = (this.ioram[10] & 0xC) << 12;
                            n21 = (this.ioram[11] & 0x1F) << 11;
                            n20 = (this.ioram[11] & 0x40) == 0 ? 256 : 512;
                            n19 = (this.ioram[11] & 0x80) == 0 ? 256 : 512;
                            n18 = n20 - 1;
                            n17 = n19 - 1;
                            n16 = (short)(this.ioram[20] & 0xFF | this.ioram[21] << 8) & 0x1FF;
                            n15 = (short)(this.ioram[22] & 0xFF | this.ioram[23] << 8) & 0x1FF;
                            s5 = n20 != 256 ? (short)1 : 0;
                            s4 = (this.ioram[10] & 0x80) != 0 ? (short)1 : 0;
                            bl = (this.ioram[10] & 0x40) != 0;
                            n14 = (this.ioram[76] & 0xF) + 1;
                            n13 = (this.ioram[76] >>> 4 & 0xF) + 1;
                            n12 = bl ? i - i % n13 : i;
                            n12 = n12 + n15 & n17;
                            n11 = 0;
                            if (s5 != 0) {
                                if (n12 >= 256) {
                                    n11 = 4096;
                                }
                                n12 &= 0xFF;
                            }
                            n10 = (n12 >>> 3) * 32;
                            n9 = n12 & 7;
                            for (n8 = 0; n8 < 240; ++n8) {
                                n7 = bl ? n8 - n8 % n14 : n8;
                                n7 = n7 + n16 & n18;
                                n6 = 0;
                                if (s5 != 0) {
                                    if (n7 >= 256) {
                                        n6 = 2048;
                                    }
                                    n7 &= 0xFF;
                                }
                                n5 = n7 >>> 3;
                                n4 = n7 & 7;
                                s3 = (n10 + n5) * 2 + (n11 + n6);
                                s2 = this.readVRam16(n21 + s3);
                                n3 = s2 & 0x3FF;
                                if ((s2 & 0x400) != 0) {
                                    n4 = 7 - n4;
                                }
                                if ((s2 & 0x800) != 0) {
                                    n9 = 7 - n9;
                                }
                                if (s4 != 0) {
                                    n2 = this.vram[(n22 + n3 * 8 * 8 + n9 * 8 + n4 & 0xFFFFFF) % this.vram.length] & 0xFF;
                                    if (n2 == 0) continue;
                                    n = this.readPal16(n2 * 2);
                                    this.pixels[i * 240 + n8] = GBACore.toRGBA((short)n);
                                    continue;
                                }
                                n2 = this.vram[(n22 + n3 * 8 * 4 + n9 * 4 + n4 / 2 & 0xFFFFFF) % this.vram.length] & 0xFF;
                                n2 = (n4 & 1) != 0 ? (n2 >>>= 4) : (n2 &= 0xF);
                                if (n2 == 0) continue;
                                n = s2 >>> 12 & 0xF;
                                s = this.readPal16((n * 16 + n2) * 2);
                                this.pixels[i * 240 + n8] = GBACore.toRGBA(s);
                            }
                        }
                        if (this.bg0Enabled & this.bg0Priority == n23) {
                            n22 = (this.ioram[8] & 0xC) << 12;
                            n21 = (this.ioram[9] & 0x1F) << 11;
                            n20 = (this.ioram[9] & 0x40) == 0 ? 256 : 512;
                            n19 = (this.ioram[9] & 0x80) == 0 ? 256 : 512;
                            n18 = n20 - 1;
                            n17 = n19 - 1;
                            n16 = (short)(this.ioram[16] & 0xFF | this.ioram[17] << 8) & 0x1FF;
                            n15 = (short)(this.ioram[18] & 0xFF | this.ioram[19] << 8) & 0x1FF;
                            s5 = n20 != 256 ? (short)1 : 0;
                            s4 = (this.ioram[8] & 0x80) != 0 ? (short)1 : 0;
                            bl = (this.ioram[8] & 0x40) != 0;
                            n14 = (this.ioram[76] & 0xF) + 1;
                            n13 = (this.ioram[76] >>> 4 & 0xF) + 1;
                            n12 = bl ? i - i % n13 : i;
                            n12 = n12 + n15 & n17;
                            n11 = 0;
                            if (s5 != 0) {
                                if (n12 >= 256) {
                                    n11 = 4096;
                                }
                                n12 &= 0xFF;
                            }
                            n10 = (n12 >>> 3) * 32;
                            n9 = n12 & 7;
                            for (n8 = 0; n8 < 240; ++n8) {
                                n7 = bl ? n8 - n8 % n14 : n8;
                                n7 = n7 + n16 & n18;
                                n6 = 0;
                                if (s5 != 0) {
                                    if (n7 >= 256) {
                                        n6 = 2048;
                                    }
                                    n7 &= 0xFF;
                                }
                                n5 = n7 >>> 3;
                                n4 = n7 & 7;
                                s3 = (n10 + n5) * 2 + (n11 + n6);
                                s2 = this.readVRam16(n21 + s3);
                                n3 = s2 & 0x3FF;
                                if ((s2 & 0x400) != 0) {
                                    n4 = 7 - n4;
                                }
                                if ((s2 & 0x800) != 0) {
                                    n9 = 7 - n9;
                                }
                                if (s4 != 0) {
                                    n2 = this.vram[(n22 + n3 * 8 * 8 + n9 * 8 + n4 & 0xFFFFFF) % this.vram.length] & 0xFF;
                                    if (n2 == 0) continue;
                                    n = this.readPal16(n2 * 2);
                                    this.pixels[i * 240 + n8] = GBACore.toRGBA((short)n);
                                    continue;
                                }
                                n2 = this.vram[(n22 + n3 * 8 * 4 + n9 * 4 + n4 / 2 & 0xFFFFFF) % this.vram.length] & 0xFF;
                                n2 = (n4 & 1) != 0 ? (n2 >>>= 4) : (n2 &= 0xF);
                                if (n2 == 0) continue;
                                n = s2 >>> 12 & 0xF;
                                s = this.readPal16((n * 16 + n2) * 2);
                                this.pixels[i * 240 + n8] = GBACore.toRGBA(s);
                            }
                        }
                        if (!this.objEnabled) continue;
                        this.drawOBJLine(i, n23);
                    }
                    continue block26;
                }
                case 2: {
                    short s3;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    boolean bl;
                    short s4;
                    short s5;
                    int n15;
                    int n16;
                    int n17;
                    int n18;
                    int n19;
                    int n20;
                    int n21;
                    int n22;
                    int n23;
                    this.bg2Enabled = (this.ioram[1] & 4) != 0;
                    this.bg3Enabled = (this.ioram[1] & 8) != 0;
                    this.objEnabled = (this.ioram[1] & 0x10) != 0;
                    this.bg2Priority = this.ioram[12] & 3;
                    this.bg3Priority = this.ioram[14] & 3;
                    this.drawBGLine(i);
                    for (n23 = 3; n23 >= 0; --n23) {
                        if (this.bg3Enabled & this.bg3Priority == n23) {
                            n22 = (this.ioram[14] & 0xC) << 12;
                            n21 = (this.ioram[15] & 0x1F) << 11;
                            switch (this.ioram[15] & 0xC0) {
                                case 0: {
                                    n20 = 128;
                                    n19 = 127;
                                    break;
                                }
                                case 64: {
                                    n20 = 256;
                                    n19 = 255;
                                    break;
                                }
                                case 128: {
                                    n20 = 512;
                                    n19 = 511;
                                    break;
                                }
                                case 192: {
                                    n20 = 1024;
                                    n19 = 1023;
                                    break;
                                }
                                default: {
                                    n20 = 0;
                                    n19 = -1;
                                }
                            }
                            n18 = (this.ioram[56] & 0xFF | (this.ioram[57] & 0xFF) << 8 | (this.ioram[58] & 0xFF) << 16 | this.ioram[59] << 24) << 4 >> 4;
                            n17 = (this.ioram[60] & 0xFF | (this.ioram[61] & 0xFF) << 8 | (this.ioram[62] & 0xFF) << 16 | this.ioram[63] << 24) << 4 >> 4;
                            n16 = (short)(this.ioram[48] & 0xFF | this.ioram[49] << 8);
                            n15 = (short)(this.ioram[50] & 0xFF | this.ioram[51] << 8);
                            s5 = (short)(this.ioram[52] & 0xFF | this.ioram[53] << 8);
                            s4 = (short)(this.ioram[54] & 0xFF | this.ioram[55] << 8);
                            bl = (this.ioram[15] & 0x20) != 0;
                            n14 = i * n15 + n18;
                            n13 = i * s4 + n17;
                            for (n12 = 0; n12 < 240; ++n12) {
                                n11 = n14 >> 8;
                                n10 = n13 >> 8;
                                if (bl) {
                                    n11 &= n19;
                                    n10 &= n19;
                                }
                                if (n11 >= 0 && n11 < n20 && n10 >= 0 && n10 < n20 && (n4 = this.vram[(n22 + (n5 = this.vram[(n21 + (n8 = n10 >>> 3) * (n20 / 8) + (n9 = n11 >>> 3) & 0xFFFFFF) % this.vram.length] & 0xFF) * 8 * 8 + (n6 = n10 & 7) * 8 + (n7 = n11 & 7) & 0xFFFFFF) % this.vram.length] & 0xFF) != 0) {
                                    s3 = this.readPal16(n4 * 2);
                                    this.pixels[i * 240 + n12] = GBACore.toRGBA(s3);
                                }
                                n14 += n16;
                                n13 += s5;
                            }
                        }
                        if (this.bg2Enabled & this.bg2Priority == n23) {
                            n22 = (this.ioram[12] & 0xC) << 12;
                            n21 = (this.ioram[13] & 0x1F) << 11;
                            switch (this.ioram[13] & 0xC0) {
                                case 0: {
                                    n20 = 128;
                                    n19 = 127;
                                    break;
                                }
                                case 64: {
                                    n20 = 256;
                                    n19 = 255;
                                    break;
                                }
                                case 128: {
                                    n20 = 512;
                                    n19 = 511;
                                    break;
                                }
                                case 192: {
                                    n20 = 1024;
                                    n19 = 1023;
                                    break;
                                }
                                default: {
                                    n20 = 0;
                                    n19 = -1;
                                }
                            }
                            n18 = (this.ioram[40] & 0xFF | (this.ioram[41] & 0xFF) << 8 | (this.ioram[42] & 0xFF) << 16 | this.ioram[43] << 24) << 4 >> 4;
                            n17 = (this.ioram[44] & 0xFF | (this.ioram[45] & 0xFF) << 8 | (this.ioram[46] & 0xFF) << 16 | this.ioram[47] << 24) << 4 >> 4;
                            n16 = (short)(this.ioram[32] & 0xFF | this.ioram[33] << 8);
                            n15 = (short)(this.ioram[34] & 0xFF | this.ioram[35] << 8);
                            s5 = (short)(this.ioram[36] & 0xFF | this.ioram[37] << 8);
                            s4 = (short)(this.ioram[38] & 0xFF | this.ioram[39] << 8);
                            bl = (this.ioram[13] & 0x20) != 0;
                            n14 = i * n15 + n18;
                            n13 = i * s4 + n17;
                            for (n12 = 0; n12 < 240; ++n12) {
                                n11 = n14 >> 8;
                                n10 = n13 >> 8;
                                if (bl) {
                                    n11 &= n19;
                                    n10 &= n19;
                                }
                                if (n11 >= 0 && n11 < n20 && n10 >= 0 && n10 < n20 && (n4 = this.vram[(n22 + (n5 = this.vram[(n21 + (n8 = n10 >>> 3) * (n20 / 8) + (n9 = n11 >>> 3) & 0xFFFFFF) % this.vram.length] & 0xFF) * 8 * 8 + (n6 = n10 & 7) * 8 + (n7 = n11 & 7) & 0xFFFFFF) % this.vram.length] & 0xFF) != 0) {
                                    s3 = this.readPal16(n4 * 2);
                                    this.pixels[i * 240 + n12] = GBACore.toRGBA(s3);
                                }
                                n14 += n16;
                                n13 += s5;
                            }
                        }
                        if (!this.objEnabled) continue;
                        this.drawOBJLine(i, n23);
                    }
                    continue block26;
                }
                case 3: {
                    int n22;
                    int n23;
                    boolean bl = this.bg2Enabled = (this.ioram[1] & 4) != 0;
                    if (!this.bg2Enabled) continue block26;
                    this.isMosaicEnabled = (this.ioram[12] & 0x40) != 0;
                    this.xMosaic = (this.ioram[76] & 0xF) + 1;
                    this.yMosaic = (this.ioram[76] >>> 4 & 0xF) + 1;
                    this.drawMode_y = this.isMosaicEnabled ? i - i % this.yMosaic : i;
                    for (n23 = 0; n23 < 240; ++n23) {
                        this.drawMode_x = this.isMosaicEnabled ? n23 - n23 % this.xMosaic : n23;
                        n22 = this.readVRam16((this.drawMode_y * 240 + this.drawMode_x) * 2);
                        this.pixels[i * 240 + n23] = GBACore.toRGBA((short)n22);
                    }
                    boolean bl2 = this.objEnabled = (this.ioram[1] & 0x10) != 0;
                    if (!this.objEnabled) continue block26;
                    for (n23 = 3; n23 >= 0; --n23) {
                        this.drawOBJLine(i, n23);
                    }
                    continue block26;
                }
                case 4: {
                    int n20;
                    int n21;
                    int n22;
                    boolean bl = this.bg2Enabled = (this.ioram[1] & 4) != 0;
                    if (!this.bg2Enabled) continue block26;
                    int n23 = (this.ioram[0] & 0x10) != 0 ? 40960 : 0;
                    this.isMosaicEnabled = (this.ioram[12] & 0x40) != 0;
                    this.xMosaic = (this.ioram[76] & 0xF) + 1;
                    this.yMosaic = (this.ioram[76] >>> 4 & 0xF) + 1;
                    this.drawMode_y = this.isMosaicEnabled ? i - i % this.yMosaic : i;
                    for (n22 = 0; n22 < 240; ++n22) {
                        this.drawMode_x = this.isMosaicEnabled ? n22 - n22 % this.xMosaic : n22;
                        n21 = this.vram[(n23 + (this.drawMode_y * 240 + this.drawMode_x) & 0xFFFFFF) % this.vram.length] & 0xFF;
                        n20 = this.readPal16(n21 * 2);
                        this.pixels[i * 240 + n22] = GBACore.toRGBA((short)n20);
                    }
                    boolean bl3 = this.objEnabled = (this.ioram[1] & 0x10) != 0;
                    if (!this.objEnabled) continue block26;
                    for (n22 = 3; n22 >= 0; --n22) {
                        this.drawOBJLine(i, n22);
                    }
                    continue block26;
                }
                case 5: {
                    System.out.println("Video Mode 5 unsupported");
                }
            }
        }
    }

    private void drawBGLine(int n) {
        int n2 = GBACore.toRGBA((short)(this.palram[0] & 0xFF | this.palram[1] << 8));
        int n3 = n * 240;
        int n4 = (n + 1) * 240;
        for (int i = n3; i < n4; ++i) {
            this.pixels[i] = n2;
        }
    }

    private void drawOBJLine(int n, int n2) {
        boolean bl = (this.ioram[0] & 0x40) != 0;
        int n3 = (this.ioram[77] & 0xF) + 1;
        int n4 = (this.ioram[77] >>> 4 & 0xF) + 1;
        for (int i = 127; i >= 0; --i) {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            int n5;
            int n6 = this.oam[(i << 3) + 5] >>> 2 & 3;
            if (n6 != n2) continue;
            boolean bl5 = (this.oam[(i << 3) + 1] & 1) != 0;
            int n7 = this.getXSize(i);
            int n8 = this.getYSize(i);
            int n9 = n7 >>> 3;
            int n10 = n8 >>> 3;
            int n11 = this.oam[(i << 3) + 2] & 0xFF | this.oam[(i << 3) + 3] << 31 >> 23;
            int n12 = this.oam[i << 3] & 0xFF;
            boolean bl6 = (this.oam[(i << 3) + 1] & 0x20) != 0;
            int n13 = (this.oam[(i << 3) + 5] & 0xF0) >>> 4;
            int n14 = this.oam[(i << 3) + 4] & 0xFF | (this.oam[(i << 3) + 5] & 3) << 8;
            if (bl) {
                n5 = bl6 ? n9 * 2 : n9;
            } else {
                n5 = 32;
                if (bl6) {
                    n14 &= 0xFFFE;
                }
            }
            boolean bl7 = bl4 = (this.oam[(i << 3) + 1] & 0x10) != 0;
            if (bl5) continue;
            boolean bl8 = bl3 = (this.oam[(i << 3) + 1] & 2) == 0;
            if (!bl3) continue;
            boolean bl9 = (this.oam[(i << 3) + 3] & 0x10) != 0;
            boolean bl10 = bl2 = (this.oam[(i << 3) + 3] & 0x20) != 0;
            if (n12 >= 160) {
                n12 -= 256;
            }
            if (n < n12 || n >= n12 + n8) continue;
            int n15 = n - n12;
            for (int j = 0; j < n7; ++j) {
                short s;
                int n16;
                int n17;
                int n18 = n11 + j;
                if (n18 < 0 || n18 >= 240) continue;
                int n19 = bl9 ? n7 - 1 - j : j;
                int n20 = bl2 ? n8 - 1 - n15 : n15;
                int n21 = n19 >>> 3;
                int n22 = n20 >>> 3;
                int n23 = n19 & 7;
                int n24 = n20 & 7;
                if (bl6) {
                    n17 = n14 + n22 * n5 + n21 * 2;
                    n16 = this.vram[(65536 + n17 * 32 + n24 * 8 + n23 & 0xFFFFFF) % this.vram.length] & 0xFF;
                    if (n16 == 0) continue;
                    s = this.readPal16(512 + n16 * 2);
                    this.pixels[n * 240 + n18] = GBACore.toRGBA(s);
                    continue;
                }
                n17 = n14 + n22 * n5 + n21;
                n16 = this.vram[(65536 + n17 * 32 + n24 * 4 + n23 / 2 & 0xFFFFFF) % this.vram.length] & 0xFF;
                n16 = (n23 & 1) != 0 ? (n16 >>>= 4) : (n16 &= 0xF);
                if (n16 == 0) continue;
                s = this.readPal16(512 + (n13 * 16 + n16) * 2);
                this.pixels[n * 240 + n18] = GBACore.toRGBA(s);
            }
        }
    }

    private static int toRGBA(short s) {
        int n = (s & 0x1F) << 19;
        int n2 = (s & 0x3E0) << 6;
        int n3 = (s & 0x7C00) >>> 7;
        int n4 = -16777216;
        return n | n2 | n3 | n4;
    }

    static {
        thumbInstruction = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 8, 8, 7, 7, 8, 8, 7, 7, 8, 8, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 127, 127, 127, 14, 14, 127, 127, 127, 127, 127, 127, 14, 14, 127, 127, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 127, 127, 127, 127, 127, 127, 127, 127, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19};
    }
}

