/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.App;
import app.GBACore;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class GBACanvas
extends Canvas {
    private int frame_count;
    private int sleep;
    private boolean fpsOff = false;
    private String messageStr;
    private int skippedFrameCount;
    private long startTime;
    private int last_frame;
    private int frameSkip = 4;
    private int fps;
    private long lastTime;
    GBACore core = new GBACore(this);
    private boolean romload;
    private boolean displayClear;
    private boolean rp = true;
    static int Input = 1023;

    public GBACanvas() {
        this.loadRom();
    }

    protected void paint(Graphics graphics) {
        this.rp = false;
        this.core.drawLine();
        graphics.drawRGB(this.core.pixels, 0, 240, 0, 0, 240, 160, false);
        if (!this.fpsOff) {
            graphics.setColor(0xFFFFFF);
            graphics.drawString(this.messageStr, 0, 0, 20);
        }
        this.rp = true;
    }

    public boolean startFrame() {
        ++this.frame_count;
        if (this.sleep == 2) {
            double d;
            long l;
            double d2;
            if (this.frame_count % 61 == 0) {
                if (!this.fpsOff) {
                    this.messageStr = 60 - this.skippedFrameCount + "/60 frames.";
                }
                this.skippedFrameCount = 0;
            }
            if ((d2 = (double)(l = System.currentTimeMillis()) - (d = (double)this.startTime + 16.66666 * (double)this.frame_count)) > 500.0 || d2 < -500.0) {
                this.startTime = System.currentTimeMillis();
                this.frame_count = 0;
                this.last_frame = 0;
            }
            if ((double)l < d) {
                return true;
            }
            ++this.skippedFrameCount;
            return this.skippedFrameCount == 60;
        }
        return this.frame_count % this.frameSkip == 0;
    }

    public void endFrame() {
        long l;
        if (this.frame_count - this.last_frame >= 60) {
            l = System.currentTimeMillis();
            this.fps = 60000 / (int)(l - this.lastTime);
            this.last_frame += 60;
            this.lastTime = l;
            if (!this.fpsOff && this.sleep < 2) {
                this.messageStr = this.fps + "FPS FS=" + this.frameSkip;
            }
        }
        if (this.rp) {
            this.repaint();
        }
        if (this.sleep == 1) {
            l = this.startTime + (long)(1667 * this.frameSkip / 100);
            do {
                this.startTime = System.currentTimeMillis();
            } while (l > this.startTime);
            long l2 = this.startTime - l;
            if (l2 > 0L && l2 < 50L) {
                this.startTime -= l2;
            }
        }
    }

    public short readJoyPad() {
        if ((short)Input < 0) {
            return (short)((Input &= 0x3FF) | 0x8000);
        }
        return (short)Input;
    }

    static final int keyInp(int n) {
        if (n == 49 | n == 53) {
            return 1;
        }
        if (n == -5 || n == 51) {
            return 2;
        }
        if (n == -7) {
            return 4;
        }
        if (n == -6) {
            return 8;
        }
        if (n == -4 || n == 54) {
            return 16;
        }
        if (n == -3 || n == 52) {
            return 32;
        }
        if (n == -1 || n == 50) {
            return 64;
        }
        if (n == -2 || n == 56) {
            return 128;
        }
        if (n == 57) {
            return 256;
        }
        if (n == 55) {
            return 512;
        }
        return 0;
    }

    public void keyPressed(int n) {
        if (n == 42) {
            if (this.frameSkip > 1) {
                --this.frameSkip;
            }
        } else if (n == 35) {
            ++this.frameSkip;
        } else if (n == 48) {
            this.fpsOff = !this.fpsOff;
        } else {
            Input &= ~GBACanvas.keyInp(n);
            Input |= 0x8000;
        }
    }

    public void keyReleased(int n) {
        Input |= GBACanvas.keyInp(n) | 0x8000;
    }

    private void loadRom() {
        try {
            int n;
            this.core.request(2, 0);
            this.core = new GBACore(this);
            System.gc();
            if (App.is != null && (n = this.core.loadROM(App.is, App.is.available())) == 0) {
                this.romload = true;
                this.displayClear = true;
                this.messageStr = "";
                this.core.reset();
                this.core.start();
                this.core.request(0, 0);
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            throw error;
        }
        finally {
            App.is = null;
        }
    }
}

