/*
 * Decompiled with CFR 0.152.
 */
package net.benhui.btgallery.discovery_bt;

import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Screen;
import net.benhui.btgallery.Util;
import net.benhui.btgallery.discovery_gui.Discovery_MIDlet;

public class DiscoveryImpl {
    LocalDevice device;
    DiscoveryAgent agent;
    public static Vector devices = new Vector();
    public static Vector deviceClasses = new Vector();
    public static Vector services = new Vector();

    public void doDiscoverDevice() {
        try {
            this.device = LocalDevice.getLocalDevice();
            this.device.setDiscoverable(10390323);
            this.agent = this.device.getDiscoveryAgent();
            this.agent.startInquiry(10390323, (DiscoveryListener)new Listener());
        }
        catch (BluetoothStateException e) {
            e.printStackTrace();
            Discovery_MIDlet.alert((Exception)((Object)e), (Screen)Discovery_MIDlet.instance.deviceDiscoveryUI);
        }
    }

    public void doDiscoverService(RemoteDevice remote) {
        try {
            int[] attr = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 256, 257, 258, 512, 513, 769, 770, 771, 772, 773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 784, 785, 786, 787};
            this.agent.searchServices(attr, new UUID[]{new UUID(256L)}, remote, (DiscoveryListener)new Listener());
        }
        catch (BluetoothStateException e) {
            e.printStackTrace();
            Discovery_MIDlet.alert((Exception)((Object)e), (Screen)Discovery_MIDlet.instance.deviceDiscoveryUI);
        }
    }

    public void log(String m) {
        Discovery_MIDlet.log(m);
    }

    class Listener
    implements DiscoveryListener {
        Listener() {
        }

        public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
            DiscoveryImpl.this.log("A remote Bluetooth device is discovered:");
            Util.printRemoteDevice(remoteDevice, deviceClass);
            devices.addElement(remoteDevice);
            deviceClasses.addElement(deviceClass);
        }

        public void inquiryCompleted(int complete) {
            DiscoveryImpl.this.log("service discovery completed with return code:" + complete);
            DiscoveryImpl.this.log("" + devices.size() + " devices are discovered");
            if (devices.size() == 0) {
                Alert alert = new Alert("Problem!", "No Bluetooth device found", null, AlertType.INFO);
                alert.setTimeout(3000);
                Discovery_MIDlet.instance.deviceDiscoveryUI.setMsg("[Press Inquiry]");
                Discovery_MIDlet.display.setCurrent(alert, (Displayable)Discovery_MIDlet.instance.deviceDiscoveryUI);
            } else {
                Discovery_MIDlet.instance.deviceDiscoveryUI.showui();
                Discovery_MIDlet.display.setCurrent((Displayable)Discovery_MIDlet.instance.deviceDiscoveryUI);
            }
        }

        public void servicesDiscovered(int transId, ServiceRecord[] records) {
            DiscoveryImpl.this.log("Remote Bluetooth services is discovered:");
            for (int i = 0; i < records.length; ++i) {
                ServiceRecord record = records[i];
                Util.printServiceRecord(record);
                services.addElement(record);
            }
        }

        public void serviceSearchCompleted(int transId, int complete) {
            DiscoveryImpl.this.log("service discovery completed with return code:" + complete);
            DiscoveryImpl.this.log("" + services.size() + " services are discovered");
            if (complete == 1 || complete == 4) {
                Discovery_MIDlet.instance.serviceDiscoveryUI.showui();
                Discovery_MIDlet.display.setCurrent((Displayable)Discovery_MIDlet.instance.serviceDiscoveryUI);
            } else {
                Discovery_MIDlet.alert("Service Discovery imcomplete", (Screen)Discovery_MIDlet.instance.deviceDiscoveryUI);
            }
        }
    }
}

