/*
 * Decompiled with CFR 0.152.
 */
package Client;

import MIDLetPackage.RoomMIDLet;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.List;

public class Client
implements Runnable,
DiscoveryListener {
    private static final UUID serverUUID = new UUID(4660L);
    private boolean isClosed = false;
    private LocalDevice local;
    private Thread clientThread;
    private RoomMIDLet parent;
    private Vector devices;
    private Vector records;
    private boolean isChanged;
    private DiscoveryAgent agent;
    private UUID[] uuidSet;
    private String message;
    private static final int SEARCH_FOR_DEVICES = 0;
    private static final int TRANSFER_DATA = 1;
    private int state = 1;
    private Vector mark;

    public Client(RoomMIDLet parent) {
        this.parent = parent;
        this.devices = new Vector();
        this.records = new Vector();
        this.mark = new Vector();
        this.clientThread = new Thread(this);
        this.clientThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Client client = this;
        synchronized (client) {
            this.isClosed = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestSearch() {
        Client client = this;
        synchronized (client) {
            this.state = 0;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestSend(String message) {
        Client client = this;
        synchronized (client) {
            this.message = message;
            this.notify();
        }
    }

    public void listDevicesToUser(List list) {
        int i;
        boolean[] marks = new boolean[this.mark.size()];
        for (i = 0; i < this.mark.size(); ++i) {
            marks[i] = (Boolean)this.mark.elementAt(i);
        }
        list.deleteAll();
        for (i = 0; i < this.records.size(); ++i) {
            try {
                list.append(((ServiceRecord)this.records.elementAt(i)).getHostDevice().getFriendlyName(false), this.parent.contactImage);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        list.setSelectedFlags(marks);
    }

    public void setMarksForSend(List list) {
        boolean[] user_marks = new boolean[list.size()];
        list.getSelectedFlags(user_marks);
        this.mark.removeAllElements();
        for (int i = 0; i < user_marks.length; ++i) {
            this.mark.addElement(new Boolean(user_marks[i]));
        }
    }

    public void run() {
        try {
            this.local = LocalDevice.getLocalDevice();
            this.local.setDiscoverable(10390323);
            this.agent = this.local.getDiscoveryAgent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.uuidSet = new UUID[2];
        this.uuidSet[0] = new UUID(4353L);
        this.uuidSet[1] = serverUUID;
        this.processDataTransfer();
    }

    public synchronized void processDataTransfer() {
        while (!this.isClosed) {
            if (this.state == 0) {
                if (!this.searchDevices() || !this.searchServices()) continue;
                this.state = 1;
                this.parent.showSearchFrame(this.devices.size(), this.records.size());
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            if (this.isClosed) {
                return;
            }
            if (this.state != 1) continue;
            this.sendMessageToAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageToAll() {
        if (this.devices.size() == 0 || this.records.size() == 0) {
            return;
        }
        if (this.message == null) {
            System.out.println("unexpected exception!");
            return;
        }
        this.message = this.local.getFriendlyName() + ": " + this.message + "\n";
        for (int i = 0; i < this.records.size(); ++i) {
            if (!((Boolean)this.mark.elementAt(i)).booleanValue()) continue;
            StreamConnection conn = null;
            String url = null;
            try {
                url = ((ServiceRecord)this.records.elementAt(i)).getConnectionURL(0, false);
                conn = (StreamConnection)Connector.open((String)url);
            }
            catch (IOException e) {
                try {
                    this.parent.messageFailure(((ServiceRecord)this.records.elementAt(i)).getHostDevice().getFriendlyName(false));
                    conn.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                e.printStackTrace();
                continue;
            }
            try {
                DataOutputStream out = conn.openDataOutputStream();
                out.writeUTF(this.message);
                out.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            finally {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public boolean searchDevices() {
        this.devices.removeAllElements();
        this.mark.removeAllElements();
        try {
            this.agent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (BluetoothStateException e) {
            e.printStackTrace();
            return true;
        }
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        return !this.isClosed;
    }

    private boolean searchServices() {
        this.records.removeAllElements();
        boolean isSearchStarted = false;
        for (int i = 0; i < this.devices.size(); ++i) {
            RemoteDevice rd = (RemoteDevice)this.devices.elementAt(i);
            try {
                this.agent.searchServices(null, this.uuidSet, rd, (DiscoveryListener)this);
            }
            catch (BluetoothStateException e) {
                e.printStackTrace();
                continue;
            }
            isSearchStarted = true;
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (!isSearchStarted) {
            return true;
        }
        return !this.isClosed;
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        if (this.devices.indexOf(btDevice) == -1) {
            this.devices.addElement(btDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int discType) {
        Client client = this;
        synchronized (client) {
            this.notify();
        }
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        for (int i = 0; i < servRecord.length; ++i) {
            this.records.addElement(servRecord[i]);
            this.mark.addElement(new Boolean(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int transID, int respCode) {
        Client client = this;
        synchronized (client) {
            this.notify();
        }
    }
}

