/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class NetworkLayer
implements Runnable {
    private static final UUID uuid = new UUID("D8511BA0472011D996690800200C9A66", false);
    private LocalDevice device;
    private StreamConnection conn;
    DiscoveryAgent agent = null;
    StreamConnectionNotifier notifier;
    private boolean running = true;
    protected Vector nodesDir = new Vector();
    protected Vector msgqueue = new Vector();
    Vector tempNodesList = new Vector();
    Timer timer = new Timer();
    Timer inquiryTimer = new Timer();
    Hashtable serviceRecordToNode = new Hashtable();
    Object lock = new Object();
    Listener inquiryListener = new Listener();
    ReaderThread readincoming;
    SenderThread sendoutgoing;
    String localname = "";
    int localiconid;
    private boolean firsttime = true;
    MessageData errormsg;
    test t;
    User user;
    GUI gui;
    MessageType m = new MessageType();

    public NetworkLayer(test test2, User user, GUI gUI) {
        this.t = test2;
        this.user = user;
        this.gui = gUI;
        this.localname = this.user.getUserName();
        this.localiconid = this.user.getIconID();
    }

    public void init() {
        try {
            this.device = LocalDevice.getLocalDevice();
            this.device.setDiscoverable(10390323);
            this.agent = this.device.getDiscoveryAgent();
            Thread thread = new Thread(this);
            thread.start();
            System.out.println("Server thread started");
            this.readincoming = new ReaderThread();
            this.sendoutgoing = new SenderThread();
            this.readincoming.NL = this;
            this.sendoutgoing.NL = this;
            Thread thread2 = new Thread(this.readincoming);
            Thread thread3 = new Thread(this.sendoutgoing);
            thread2.start();
            thread3.start();
            this.t.initS.doDiscovery();
        }
        catch (BluetoothStateException bluetoothStateException) {
            String string = "NL: bluetooth problem at init";
            System.out.println((Object)bluetoothStateException);
            bluetoothStateException.printStackTrace();
            this.errormsg = new MessageData(1, string);
            this.writeToGUI(this.errormsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        ServiceRecord serviceRecord;
        try {
            this.notifier = (StreamConnectionNotifier)Connector.open((String)("btspp://localhost:" + uuid.toString() + ";name=BluetoothChat"));
            serviceRecord = this.device.getRecord((Connection)this.notifier);
            serviceRecord.setAttributeValue(8, new DataElement(8, 255L));
            serviceRecord.setDeviceServiceClasses(0x400000);
            System.out.println("NL: notifier ready at run");
            System.out.println("NL: reader sender threads started at run");
        }
        catch (Exception exception) {
            object = "NL: conn error @ run";
            System.out.println((String)object);
            this.errormsg = new MessageData(1, (String)object);
            this.writeToGUI(this.errormsg);
        }
        while (this.running) {
            try {
                System.out.println("NL: server listening for new devices");
                this.conn = this.notifier.acceptAndOpen();
                serviceRecord = RemoteDevice.getRemoteDevice((Connection)this.conn);
                object = this.nodeExists((RemoteDevice)serviceRecord);
                if (object != null) continue;
                object = new Node((RemoteDevice)serviceRecord, this.conn, this);
                NetworkLayer networkLayer = this;
                synchronized (networkLayer) {
                    this.nodesDir.addElement(object);
                }
                System.out.println("New node found");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                if (this.conn == null) continue;
                try {
                    this.conn.close();
                }
                catch (IOException iOException2) {
                }
            }
            catch (Exception exception) {
                this.errormsg = new MessageData(1, "NL: a problem with connection!");
                this.writeToGUI(this.errormsg);
            }
        }
    }

    public synchronized void terminate(Node node) {
        node.cancelTimer();
        try {
            node.dataout.close();
            node.datain.close();
            node.conn.close();
        }
        catch (IOException iOException) {
            System.out.println("NL: Unable to close data stream connections @ terminate method");
        }
        this.nodesDir.removeElement(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToGUI(MessageData messageData) {
        NetworkLayer networkLayer = this;
        synchronized (networkLayer) {
            this.gui.ProcessIncomingMessage(messageData);
        }
    }

    public void stop() {
        try {
            this.notifier.close();
            this.running = false;
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (IOException iOException) {
            System.out.println("NL: problem closing server connection!");
        }
        try {
            this.agent.cancelInquiry((DiscoveryListener)this.inquiryListener);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("NL: error during networklayer.stop() \n " + nullPointerException.toString());
        }
        try {
            MessageData messageData = new MessageData(5, null);
            this.sendMessage(messageData);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("NL: error during networklayer.stop() \n " + nullPointerException.toString());
        }
        this.readincoming.stop();
    }

    public void cleanUp() {
        this.sendoutgoing.stop();
        for (int i = 0; i < this.nodesDir.size(); ++i) {
            Node node = (Node)this.nodesDir.elementAt(i);
            try {
                node.dataout.close();
                node.datain.close();
                node.conn.close();
                continue;
            }
            catch (IOException iOException) {
                System.out.println("NL: Unable to close data stream connections in Node");
            }
        }
        this.nodesDir.removeAllElements();
        this.msgqueue.removeAllElements();
        System.out.println("NL: STOP & CLEANUP HAS BEEN SUCCESSFUL!");
    }

    public void query() {
        try {
            System.out.println("discovery started");
            this.agent.startInquiry(10390323, (DiscoveryListener)this.inquiryListener);
        }
        catch (BluetoothStateException bluetoothStateException) {
            System.out.println("NL: problem at query method!");
        }
    }

    public Node nodeExists(RemoteDevice remoteDevice) {
        for (int i = 0; i < this.nodesDir.size(); ++i) {
            Node node = (Node)this.nodesDir.elementAt(i);
            if (!node.device.equals((Object)remoteDevice)) continue;
            return node;
        }
        return null;
    }

    public Node findNodeByTransId(int n) {
        for (int i = 0; i < this.tempNodesList.size(); ++i) {
            Node node = (Node)this.tempNodesList.elementAt(i);
            if (node.transId != n) continue;
            System.out.println("service discovery: node found with same transaction id");
            return node;
        }
        return null;
    }

    public void sendMessage(MessageData messageData) {
        this.msgqueue.addElement(messageData);
        System.out.println("NL: message added to message queue");
    }

    public Vector getUserVect() {
        return this.nodesDir;
    }

    class DoServiceDiscovery
    extends TimerTask {
        DoServiceDiscovery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (NetworkLayer.this.tempNodesList.size() > 0) {
                System.out.println("Found " + NetworkLayer.this.tempNodesList.size() + " devices. Starting service discovery on each one");
                for (int i = 0; i < NetworkLayer.this.tempNodesList.size(); ++i) {
                    Node node = (Node)NetworkLayer.this.tempNodesList.elementAt(i);
                    try {
                        node.transId = NetworkLayer.this.agent.searchServices(null, new UUID[]{uuid}, node.getRD(), (DiscoveryListener)new Listener());
                        Object object = NetworkLayer.this.lock;
                        synchronized (object) {
                            try {
                                System.out.println("lock initiated");
                                NetworkLayer.this.lock.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    catch (BluetoothStateException bluetoothStateException) {
                        System.out.println("bluetooth problem in service discovery");
                    }
                }
                NetworkLayer.this.tempNodesList.removeAllElements();
            } else {
                System.out.println("No devices found");
            }
            if (NetworkLayer.this.firsttime) {
                NetworkLayer.this.t.initS.progressComplete();
                MessageType cfr_ignored_0 = NetworkLayer.this.m;
                MessageData messageData = new MessageData(0, "Welcome. You are connected to " + NetworkLayer.this.nodesDir.size() + " people!");
                NetworkLayer.this.writeToGUI(messageData);
                System.out.println("done first time");
                NetworkLayer.this.firsttime = false;
            }
            NetworkLayer.this.inquiryTimer.schedule((TimerTask)new startInquiry(), 180000L);
        }
    }

    class Listener
    implements DiscoveryListener {
        Listener() {
        }

        public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
            try {
                Node node = new Node(remoteDevice, NetworkLayer.this);
                if (NetworkLayer.this.nodeExists(remoteDevice) == null) {
                    NetworkLayer.this.tempNodesList.addElement(node);
                    System.out.println("LIST: new node found by device disc and added to vector");
                }
            }
            catch (Exception exception) {
                System.out.println("NL: problem when each device is discovered");
            }
        }

        public void inquiryCompleted(int n) {
            System.out.println("About to start service dicovery");
            NetworkLayer.this.timer.schedule((TimerTask)new DoServiceDiscovery(), 100L);
        }

        public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
            System.out.println("invoke servicesDiscovered: " + n + ", " + serviceRecordArray.length);
            try {
                for (int i = 0; i < serviceRecordArray.length; ++i) {
                    Node node = NetworkLayer.this.findNodeByTransId(n);
                    NetworkLayer.this.serviceRecordToNode.put(serviceRecordArray[i], node);
                    System.out.println("service discovery: node with same trans id put in hash table");
                }
            }
            catch (Exception exception) {
                System.out.println("Problem at servicesDiscovered");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceSearchCompleted(int n, int n2) {
            if (n2 == 1) {
                System.out.println("SERVICE_SEARCH_COMPLETED");
            } else if (n2 == 2) {
                System.out.println("SERVICE_SEARCH_TERMINATED");
            } else if (n2 == 3) {
                System.out.println("SERVICE_SEARCH_ERROR");
            } else if (n2 == 4) {
                System.out.println("SERVICE_SEARCH_NO_RECORDS");
            } else if (n2 == 6) {
                System.out.println("SERVICE_SEARCH_DEVICE_NOT_REACHABLE");
            }
            Object object = NetworkLayer.this.serviceRecordToNode.keys();
            while (object.hasMoreElements()) {
                try {
                    ServiceRecord serviceRecord = (ServiceRecord)object.nextElement();
                    String string = serviceRecord.getConnectionURL(0, false);
                    StreamConnection streamConnection = (StreamConnection)Connector.open((String)string);
                    Node node = (Node)NetworkLayer.this.serviceRecordToNode.get(serviceRecord);
                    if (node == null) continue;
                    node.setSC(streamConnection);
                    Object object2 = this;
                    synchronized (object2) {
                        NetworkLayer.this.nodesDir.addElement(node);
                    }
                    MessageType cfr_ignored_0 = NetworkLayer.this.m;
                    object2 = new MessageData(3, false, node, NetworkLayer.this.localiconid, NetworkLayer.this.localname, null);
                    System.out.println("NL: sending handshake message to device found");
                    NetworkLayer.this.sendMessage((MessageData)object2);
                }
                catch (Exception exception) {
                    System.out.println("Problem at serviceSearchCompleted");
                }
            }
            NetworkLayer.this.serviceRecordToNode.clear();
            object = NetworkLayer.this.lock;
            synchronized (object) {
                NetworkLayer.this.lock.notifyAll();
            }
        }
    }

    class startInquiry
    extends TimerTask {
        startInquiry() {
        }

        public void run() {
            NetworkLayer.this.query();
        }
    }
}

