/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.io.StreamConnection;

public class SenderThread
implements Runnable {
    protected NetworkLayer NL;
    private MessageType m = new MessageType();
    private boolean done = false;
    private boolean connCheck = true;
    private Vector nodesList = new Vector();
    private StreamConnection sc;
    private DataOutputStream dataout;

    public void stop() {
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.done) {
                this.nodesList = this.NL.getUserVect();
                if (this.NL.msgqueue.size() <= 0 || this.nodesList.size() <= 0) continue;
                while (this.NL.msgqueue.size() != 0) {
                    Object object;
                    Object object2;
                    MessageData messageData = (MessageData)this.NL.msgqueue.firstElement();
                    System.out.println("SENDER THRD: Message type signal: " + messageData.signal);
                    System.out.println("SENDER THRD: Message sendtoall: " + messageData.sendtoall);
                    if (messageData.sendtoall) {
                        for (int i = 0; i < this.nodesList.size(); ++i) {
                            object2 = (Node)this.nodesList.elementAt(i);
                            object = ((Node)object2).lock;
                            synchronized (object) {
                                this.dataout = ((Node)object2).getDOS();
                                this.connCheck = true;
                                this.connCheck = this.sendMESSAGE(this.dataout, messageData);
                                if (!this.connCheck) {
                                    MessageData messageData2 = new MessageData(0, "Lost connection to " + ((Node)object2).getUsername());
                                    this.NL.writeToGUI(messageData2);
                                    this.NL.terminate((Node)object2);
                                }
                                continue;
                            }
                        }
                    } else {
                        System.out.println("SENDER THREAD: sending a message to individual user");
                        Node node = messageData.remoteuser;
                        this.connCheck = true;
                        object2 = node.lock;
                        synchronized (object2) {
                            this.dataout = node.getDOS();
                            this.connCheck = this.sendMESSAGE(this.dataout, messageData);
                            if (!this.connCheck) {
                                object = new MessageData(0, "Lost connection to " + node.getUsername());
                                this.NL.writeToGUI((MessageData)object);
                                this.NL.terminate(node);
                            }
                        }
                    }
                    if (messageData.signal == 5) {
                        this.NL.cleanUp();
                    }
                    this.NL.msgqueue.removeElementAt(0);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("SENDER THREAD: There was an error sending messages from network layer message queue");
            System.out.println(exception.toString());
            MessageData messageData = new MessageData(1, exception.toString());
            this.NL.writeToGUI(messageData);
        }
    }

    public boolean sendMESSAGE(DataOutputStream dataOutputStream, MessageData messageData) {
        boolean bl = true;
        if (messageData.signal == 2) {
            bl = this.sendCHAT(dataOutputStream, messageData);
        } else if (messageData.signal == 3) {
            bl = this.sendHANDSHAKE(dataOutputStream, messageData);
        } else if (messageData.signal == 4) {
            bl = this.sendHANDSHAKEACK(dataOutputStream, messageData);
        } else if (messageData.signal == 7) {
            bl = this.sendUPDATE(dataOutputStream, messageData);
        } else if (messageData.signal == 5) {
            bl = this.sendTERMINATE(dataOutputStream, messageData);
        } else if (messageData.signal == 8) {
            bl = this.sendPING(dataOutputStream, messageData);
        } else if (messageData.signal == 9) {
            bl = this.sendPINGACK(dataOutputStream, messageData);
        }
        return bl;
    }

    public boolean sendCHAT(DataOutputStream dataOutputStream, MessageData messageData) {
        try {
            dataOutputStream.writeInt(messageData.signal);
            dataOutputStream.writeInt(messageData.iconid);
            dataOutputStream.writeUTF(messageData.sender);
            dataOutputStream.writeUTF(messageData.message);
            dataOutputStream.flush();
            System.out.println("SENDERTHREAD: Chat message sent");
            return true;
        }
        catch (Exception exception) {
            System.out.println("There was an error sending chat message");
            System.out.println(exception.toString());
            return false;
        }
    }

    public boolean sendHANDSHAKE(DataOutputStream dataOutputStream, MessageData messageData) {
        try {
            dataOutputStream.writeInt(messageData.signal);
            dataOutputStream.writeInt(messageData.iconid);
            dataOutputStream.writeUTF(messageData.sender);
            dataOutputStream.flush();
            System.out.println("SENDERTHREAD: Handshake message sent");
            return true;
        }
        catch (Exception exception) {
            System.out.println("There was an error sending handshake message");
            System.out.println(exception.toString());
            return false;
        }
    }

    public boolean sendHANDSHAKEACK(DataOutputStream dataOutputStream, MessageData messageData) {
        try {
            dataOutputStream.writeInt(messageData.signal);
            dataOutputStream.writeInt(messageData.iconid);
            dataOutputStream.writeUTF(messageData.sender);
            dataOutputStream.flush();
            System.out.println("SENDERTHREAD: Handshake Acknowledgement message sent");
            return true;
        }
        catch (Exception exception) {
            System.out.println("There was an error sending handshake acknowledgement message");
            System.out.println(exception.toString());
            return false;
        }
    }

    public boolean sendUPDATE(DataOutputStream dataOutputStream, MessageData messageData) {
        try {
            dataOutputStream.writeInt(messageData.signal);
            dataOutputStream.writeInt(messageData.iconid);
            dataOutputStream.writeUTF(messageData.sender);
            dataOutputStream.flush();
            System.out.println("SENDERTHREAD: Update message sent");
            return true;
        }
        catch (Exception exception) {
            System.out.println("There was an error sending update message");
            System.out.println(exception.toString());
            return false;
        }
    }

    public boolean sendTERMINATE(DataOutputStream dataOutputStream, MessageData messageData) {
        try {
            dataOutputStream.writeInt(messageData.signal);
            dataOutputStream.flush();
            System.out.println("SENDERTHREAD: Terminate message sent");
            return true;
        }
        catch (Exception exception) {
            System.out.println("There was an error sending terminate message");
            exception.printStackTrace();
            return false;
        }
    }

    public boolean sendPING(DataOutputStream dataOutputStream, MessageData messageData) {
        try {
            dataOutputStream.writeInt(messageData.signal);
            dataOutputStream.flush();
            System.out.println("SENDERTHREAD: ping message sent");
            return true;
        }
        catch (Exception exception) {
            System.out.println("There was an error sending ping message");
            exception.printStackTrace();
            return false;
        }
    }

    public boolean sendPINGACK(DataOutputStream dataOutputStream, MessageData messageData) {
        try {
            dataOutputStream.writeInt(messageData.signal);
            dataOutputStream.flush();
            System.out.println("SENDERTHREAD: ping acknowledgement message sent");
            return true;
        }
        catch (Exception exception) {
            System.out.println("There was an error sending ping acknowledgement message");
            exception.printStackTrace();
            return false;
        }
    }
}

