/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.debug;

import javax.microedition.lcdui.Graphics;

public class Monitor {
    private static final int SIZE = 32;
    public static boolean SHOW_FPS = true;
    public static int COLOR = 65280;
    private static final int HEIGHT = 20;
    private static final int X = 10;
    private static final int Y = 16;
    private static final int DELTA_X = 210;
    private static int size = 0;
    private static String[] names = new String[32];
    private static long[] startTime = new long[32];
    private static int[] time = new int[32];
    private static int[] maxTime = new int[32];
    private static int[] maxTimeInterval = new int[32];
    private static int[] meassureCount = new int[32];
    private static int counterSize = 0;
    private static int[] counterValue = new int[32];
    private static String[] counterName = new String[32];
    private static long startPaintTime;
    private static int framesCounter;
    private static int fps;
    private static int posY;

    public static void add(String name, int maxTimeInterval) {
        Monitor.names[Monitor.size] = name;
        Monitor.time[Monitor.size] = 0;
        Monitor.maxTime[Monitor.size] = -1;
        Monitor.meassureCount[Monitor.size] = 0;
        Monitor.maxTimeInterval[Monitor.size] = maxTimeInterval;
        ++size;
    }

    public static void begin(String name) {
        int index = Monitor.find(name);
        if (index < 0) {
            Monitor.add(name, 50);
            index = size - 1;
        }
        Monitor.startTime[index] = System.currentTimeMillis();
    }

    public static void end(String name) {
        int index = Monitor.find(name);
        long t = System.currentTimeMillis() - startTime[index];
        int n = index;
        time[n] = time[n] + (int)t;
        if (maxTimeInterval[index] > 1) {
            if (time[index] > maxTime[index]) {
                Monitor.maxTime[index] = time[index];
            } else {
                int n2 = index;
                meassureCount[n2] = meassureCount[n2] + 1;
                if (meassureCount[n2] > maxTimeInterval[index]) {
                    Monitor.meassureCount[index] = 0;
                    Monitor.maxTime[index] = time[index];
                }
            }
        }
    }

    public static void draw(Graphics g) {
        g.setColor(COLOR);
        posY = 16;
        if (SHOW_FPS) {
            g.drawString("FPS " + fps, 10, posY, 20);
            posY += 20;
        }
    }

    public static void drawItem(Graphics g, String name) {
        int index = Monitor.find(name);
        Monitor.drawItem(g, index);
    }

    public static void drawValue(Graphics g, String name, int value) {
        g.drawString(name + " " + value, 10, posY, 20);
        posY += 20;
    }

    public static void drawAll(Graphics g) {
        int i;
        Monitor.draw(g);
        for (i = 0; i < size; ++i) {
            Monitor.drawItem(g, i);
        }
        for (i = 0; i < counterSize; ++i) {
            Monitor.drawCounter(g, i);
        }
    }

    public static void onStartPaint() {
        long time = System.currentTimeMillis();
        if (time - startPaintTime > 1000L) {
            fps = framesCounter;
            framesCounter = 0;
            startPaintTime = time;
        }
        ++framesCounter;
    }

    private static void drawItem(Graphics g, int index) {
        g.drawString(names[index] + " " + time[index], 10, posY, 20);
        Monitor.time[index] = 0;
        if (maxTimeInterval[index] > 1) {
            g.drawString(Integer.toString(maxTime[index]), 220, posY, 20);
        }
        posY += 20;
    }

    private static void drawCounter(Graphics g, int index) {
        g.drawString(counterName[index] + " #" + counterValue[index], 10, posY, 20);
        posY += 20;
    }

    private static int find(String name) {
        for (int i = 0; i < size; ++i) {
            if (!names[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    private static int findCounter(String name) {
        for (int i = 0; i < counterSize; ++i) {
            if (!counterName[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public static void addCounter(String name) {
        Monitor.counterName[Monitor.counterSize] = name;
        Monitor.counterValue[Monitor.counterSize] = 0;
        ++counterSize;
    }

    public static void count(String name) {
        int index = Monitor.findCounter(name);
        if (index < 0) {
            Monitor.addCounter(name);
            index = counterSize - 1;
        }
        int n = index;
        counterValue[n] = counterValue[n] + 1;
    }

    public static void resetCounter(String name) {
        int index = Monitor.findCounter(name);
        if (index < 0) {
            Monitor.addCounter(name);
            index = counterSize - 1;
        }
        Monitor.counterValue[index] = 0;
    }
}

