/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game.pandas;

import com.ximad.pvn.engine.Application;
import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.GameObject;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.Launcher;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PandaSetup;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.SpecialEffect;
import com.ximad.pvn.game.TraceEffect;
import com.ximad.pvn.game.pandas.PandaAccelerate;
import com.ximad.pvn.game.pandas.PandaExplode;
import com.ximad.pvn.game.pandas.PandaNormal;
import com.ximad.pvn.game.pandas.PandaTriple;
import com.ximad.pvn.game.pandas.PandaTypes;
import com.ximad.pvn.screens.GameScreen;
import javax.microedition.lcdui.Graphics;

public class Panda
extends PhysicalGameObject {
    boolean trick = true;
    public boolean isDying = false;
    static int forceX = 0;
    static int forceY = 0;
    int timeToDie = 0;
    int nextTick = 0;
    static float lastPandaX = 0.0f;
    static float lastPandaY = 0.0f;
    static float currentPandaX = 0.0f;
    static float currentPandaY = 0.0f;
    boolean isFlyAnimationPlaying = true;
    boolean isLandAnimationPlaying = false;
    boolean range = false;
    boolean hit = false;
    public static final int MAX_DENSITY = 40;

    public void OnCollision(PhysicalGameObject obj, float force) {
    }

    public void draw(Graphics g) {
        if (this.isInvisible()) {
            return;
        }
        this.angle = Box2d.getAngle(this.box2dId);
        this.frames[this.cFrame].drawRotatedCenterSquareImage(Box2d.getCenterX(this.box2dId) - Camera.position, Box2d.getCenterY(this.box2dId), this.angle, g);
    }

    public void ability() {
    }

    protected boolean isInvisible() {
        int x = this.box2dId.positionFX().xAsInt();
        return x + this.radius <= Camera.position || x - this.radius >= Camera.position + Application.screenWidth;
    }

    public void scrollAfterCollision() {
        int centerX = Box2d.getCenterX(this.box2dId);
        if (centerX > Application.screenWidth && centerX < MyWorld.center) {
            Camera.earlyF = true;
        }
    }

    public void setLandAnimationSequence() {
        this.animationSequence.clear();
        this.animationSequence.add(new Integer(this.nFrames - 1));
        this.repeatAnimation = true;
        this.isAnimationPlaying = true;
        this.animationStartTime = System.currentTimeMillis();
    }

    public void setFlyAnimationSequence() {
        this.animationSequence.clear();
        for (int i = 4; i < this.nFrames - 1; ++i) {
            this.animationSequence.add(new Integer(i));
        }
        this.repeatAnimation = true;
        this.isAnimationPlaying = true;
        this.animationStartTime = System.currentTimeMillis();
    }

    public static void launchPanda(float x, float y) {
        GameScreen.world.setDampingRotationalFX(0);
        TraceEffect.reset();
        forceX = (int)(x * 7.5f);
        forceY = (int)(y * 7.5f);
        if (MyWorld.currentPanda == PandaTypes.PANDANORMAL) {
            PandaNormal.launchPanda(Launcher.shot_position.x, Launcher.shot_position.y);
        }
        if (MyWorld.currentPanda == PandaTypes.PANDAACCELERATE) {
            PandaAccelerate.launchPanda(Launcher.shot_position.x, Launcher.shot_position.y);
        }
        if (MyWorld.currentPanda == PandaTypes.PANDATRIPLE) {
            PandaTriple.launchPanda(Launcher.shot_position.x, Launcher.shot_position.y);
        }
        if (MyWorld.currentPanda == PandaTypes.PANDAEXPLODE) {
            PandaExplode.launchPanda(Launcher.shot_position.x, Launcher.shot_position.y);
        }
        --MyWorld.lives;
        ++((LevelCompleteStat)GameParameters.currentScenario.level.get((int)MyWorld.currentLevelInt)).pandaUsed;
        for (int i = 0; i < MyWorld.gameObjects.size(); ++i) {
            GameObject go = (GameObject)MyWorld.gameObjects.get(i);
            if (go == null || !((GameObject)MyWorld.gameObjects.get((int)i)).panda) continue;
            PandaSetup.createPandaSetup(go, MyWorld.playerCoord.x, MyWorld.playerCoord.y);
            MyWorld.gameObjects.remove(i);
            MyWorld.currentPanda = -1;
            break;
        }
        Camera.isFollowing = true;
        MyWorld.onFly = true;
        MyWorld.OnStartCheckCollision = true;
        if (!Camera.canScrollStart) {
            Camera.canScrollStart = true;
        }
    }

    public void checkDeadPanda(float dt) {
        if (this.isDying) {
            this.timeToDie = (int)((float)this.timeToDie + dt);
            if (this.timeToDie > 4000) {
                SpecialEffect.createSmoke(this);
                Box2d.moveBodyOutside(this.box2dId);
                Box2d.destroyGameObject(this.box2dId);
                --MyWorld.livesDisapearedPanda;
                MyWorld.physicalGameObjects.remove(this);
                if (Camera.isFollowing && Camera.pObj.equals(this)) {
                    Camera.isFollowing = false;
                    Camera.isScrollingStart = true;
                }
                MyWorld.checkEndLevel();
            }
        }
    }

    public void checkDistance() {
        int centerX;
        if (!(this.isDying || (centerX = Box2d.getCenterX(this.box2dId)) <= Camera.level_size && centerX >= -20)) {
            if (MyWorld.playerPanda != null) {
                MyWorld.onFly = false;
            }
            MyWorld.playerPanda = null;
            try {
                if (Camera.isFollowing && Camera.pObj.equals(this)) {
                    Camera.isFollowing = false;
                    Camera.isScrollingStart = true;
                }
                MyWorld.physicalGameObjects.remove(this);
                --MyWorld.livesDisapearedPanda;
                Box2d.destroyGameObject(this.box2dId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MyWorld.checkEndLevel();
        }
    }

    public void update(long dt) {
        if (!MyWorld.onFly && this.isDying && !this.isFlyAnimationPlaying) {
            this.setLandAnimationSequence();
            this.isFlyAnimationPlaying = true;
        }
        if (MyWorld.onFly && !this.isDying && this.isFlyAnimationPlaying) {
            this.setFlyAnimationSequence();
            this.isFlyAnimationPlaying = false;
        }
        this.cFrame = this.getCurrentFrame();
    }
}

