/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game.pandas;

import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.game.TraceEffect;
import com.ximad.pvn.game.pandas.Panda;
import com.ximad.pvn.utils.ArrayList;

public class PandaNormal
extends Panda {
    public void OnCollision(PhysicalGameObject obj, float force) {
        if (MyWorld.playerPanda != null && !this.isDying && this == MyWorld.playerPanda) {
            MyWorld.onFly = false;
            this.isDying = true;
            MyWorld.playerPanda = null;
        }
        if (obj.typeDinamicalObjects == 101) {
            Box2d.stopAngularVelocity(this.box2dId);
        }
    }

    public static void createPanda(int x, int y) {
        PandaNormal panda = new PandaNormal();
        panda.typeDinamicalObjects = 102;
        panda.isCircle = true;
        panda.restitution = 43;
        panda.friction = 99;
        panda.radius = 15;
        panda.density = 40;
        ArrayList shape = new ArrayList();
        shape.add(new Point(x, y));
        panda.setShape(shape, false, false);
        panda.frames = Textures.pandaNormal;
        panda.nFrames = 8;
        MyWorld.physicalGameObjects.add(panda);
        panda.mass = Box2d.getMass(panda.box2dId);
        MyWorld.playerPanda = panda;
        Camera.setTarget(panda);
        panda.box2dId.setParent(panda);
        TraceEffect.createSpecialTrace(panda);
    }

    public static void launchPanda(int RawX, int RawY) {
        PandaNormal.createPanda(RawX, RawY);
        Box2d.applyForceToCenter(MyWorld.playerPanda.box2dId, Box2d.getMass(MyWorld.playerPanda.box2dId) * forceX, Box2d.getMass(MyWorld.playerPanda.box2dId) * forceY);
    }

    public void ability() {
    }

    public void update(long dt) {
        this.checkDeadPanda(dt);
        this.checkDistance();
        super.update(dt);
    }
}

