/*
 * Decompiled with CFR 0.152.
 */
package Game.Items;

import Game.Control.Location;
import Game.Control.SceneManage;
import Game.Graphics.MapItems;
import Game.Items.MapTransmission;
import Game.Items.NPC;
import Game.Sprite.Sprite;
import Game.System.FontNumber;
import Game.System.Resource_Image;
import Game.System.Resource_UI_Image;
import Game.System.SystemValue;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class Map {
    public MapTransmission[] mMapTransmission;
    public Location mLocation = new Location(0.0, 0.0);
    public Vector[][] _map_Sprite = null;
    private int[] xy;
    private int Xbegin;
    private int Xcount;
    private int Ybegin;
    private int Ycount;
    private int xx;
    private int yy;
    private int y;
    private int x;
    private int i;
    private String Value;
    private NPC mNPC;
    private MapItems mMapItems;
    private Sprite mSprite;
    public Image MapImage;
    private Image SpritePetRed = Resource_UI_Image.SpritePetLv_Red();
    private Image SpritePetGold = Resource_UI_Image.SpritePetLv_Gold();
    private Image SpritePetGreed = Resource_UI_Image.SpritePetLv_Greed();
    private Image SpritePetBlue = Resource_UI_Image.SpritePetLv_Blue();
    private Image SpritePetLv = Resource_UI_Image.SpritePetLv();
    public int[][] _map_Color;
    public int[][] _map_Items;
    public byte[][] _map_Collision;
    public int[][] _map_NPC;

    public Map(int[][] Map_Color2, int[][] Map_Items2, int[][] Map_NPC, byte[][] Map_Collision2, MapTransmission[] mapTransmission) {
        this._map_Color = Map_Color2;
        this._map_Items = Map_Items2;
        this._map_Collision = Map_Collision2;
        this._map_NPC = Map_NPC;
        this._map_Sprite = new Vector[this._map_Color.length][this._map_Color[0].length];
        this.mMapTransmission = mapTransmission;
    }

    public void SetLocation(Location location) {
        this.mLocation.X = location.X - (double)(SystemValue.Screen_X / 2);
        this.mLocation.Y = location.Y - (double)(SystemValue.Screen_Y / 2);
    }

    public void MapDraw_Color() {
        this.mLocation.X = SceneManage.mTailAfter.X - (double)(SystemValue.Screen_X / 2);
        this.mLocation.Y = SceneManage.mTailAfter.Y - (double)(SystemValue.Screen_Y / 2);
        this.xy = this.Compute(this.mLocation.X, this.mLocation.Y);
        this.Xbegin = this.xy[0] - 2;
        this.Xcount = SystemValue.Screen_X / SystemValue.CellSize_X + 3;
        this.Ybegin = this.xy[1];
        this.Ycount = SystemValue.Screen_Y / (SystemValue.CellSize_Y / 2) + 3;
        this.y = 0;
        while (this.y <= this.Ycount) {
            if (this.y % 2 != 0) {
                ++this.Xbegin;
            }
            this.yy = ++this.Ybegin;
            this.x = 1;
            while (this.x <= this.Xcount) {
                --this.yy;
                this.xx = this.Xbegin + this.x;
                if (this.xx >= 0 && this.yy >= 0 && this.xx < this._map_Color[0].length && this.yy < this._map_Color.length && this._map_Color[this.yy][this.xx] > 0) {
                    SystemValue.G.drawImage((Image)Resource_Image.Map_Color.get(String.valueOf(this._map_Color[this.yy][this.xx])), (int)((double)((this._map_Color[0].length - 1) * (SystemValue.CellSize_X / 2) + (this.xx - this.yy) * (SystemValue.CellSize_X / 2)) - this.mLocation.X), (int)((double)((this.xx + this.yy) * (SystemValue.CellSize_Y / 2)) - this.mLocation.Y), 0);
                }
                ++this.x;
            }
            ++this.y;
        }
    }

    public void MapDraw_Item() {
        this.xy = this.Compute(this.mLocation.X - 450.0, this.mLocation.Y - 200.0);
        this.Xbegin = this.xy[0];
        this.Xcount = SystemValue.Screen_X / SystemValue.CellSize_X + 600 / SystemValue.CellSize_X;
        this.Ybegin = this.xy[1];
        this.Ycount = SystemValue.Screen_Y / (SystemValue.CellSize_Y / 2) + 650 / (SystemValue.CellSize_Y / 2);
        this.y = 0;
        while (this.y <= this.Ycount) {
            if (this.y % 2 != 0) {
                ++this.Xbegin;
            }
            this.yy = ++this.Ybegin;
            this.x = 1;
            while (this.x <= this.Xcount) {
                --this.yy;
                this.xx = this.Xbegin + this.x;
                if (this.xx >= 0 && this.yy >= 0 && this.xx < this._map_Color[0].length && this.yy < this._map_Color.length) {
                    if (this._map_NPC[this.yy][this.xx] > 0) {
                        this.Value = String.valueOf(this._map_NPC[this.yy][this.xx]);
                        this.mNPC = (NPC)Resource_Image.Map_NPC.get(this.Value);
                        SystemValue.G.drawImage(this.mNPC.mImage, (int)((double)((this._map_Color[0].length - 1) * (SystemValue.CellSize_X / 2) + (this.xx - this.yy) * (SystemValue.CellSize_X / 2)) - this.mLocation.X - (double)this.mNPC.ImageX), (int)((double)((this.xx + this.yy) * (SystemValue.CellSize_Y / 2)) - this.mLocation.Y - (double)this.mNPC.ImageY), 0);
                    }
                    if (this._map_Sprite[this.yy][this.xx] != null) {
                        this.i = 0;
                        while (this.i < this._map_Sprite[this.yy][this.xx].size()) {
                            this.mSprite = (Sprite)this._map_Sprite[this.yy][this.xx].elementAt(this.i);
                            SystemValue.G.drawImage(this.mSprite.mImage, (int)(this.mSprite.mLocation.X - this.mLocation.X - (double)this.mSprite.Bitmap_X), (int)(this.mSprite.mLocation.Y - this.mLocation.Y - (double)this.mSprite.Bitmap_Y - (double)(SystemValue.CellSize_Y / 2)), 0);
                            if (SceneManage.SpriteControl != this.mSprite) {
                                SystemValue.G.drawImage(this.SpritePetLv, (int)(this.mSprite.mLocation.X - this.mLocation.X - 35.0), (int)(this.mSprite.mLocation.Y - this.mLocation.Y + 20.0), 0);
                                FontNumber.FontWhite10(String.valueOf(this.mSprite.Level), (int)(this.mSprite.mLocation.X - this.mLocation.X - 35.0 + 38.0), (int)(this.mSprite.mLocation.Y - this.mLocation.Y + 20.0 + 3.0), true);
                                if (this.mSprite.Level - SceneManage.SpriteControl.Level > 0) {
                                    if (this.mSprite.Level - SceneManage.SpriteControl.Level > 3) {
                                        SystemValue.G.drawImage(this.SpritePetRed, (int)(this.mSprite.mLocation.X - this.mLocation.X - 35.0 + 6.0), (int)(this.mSprite.mLocation.Y - this.mLocation.Y + 20.0 + 4.0), 0);
                                    } else {
                                        SystemValue.G.drawImage(this.SpritePetGold, (int)(this.mSprite.mLocation.X - this.mLocation.X - 35.0 + 6.0), (int)(this.mSprite.mLocation.Y - this.mLocation.Y + 20.0 + 4.0), 0);
                                    }
                                } else if (this.mSprite.Level - SceneManage.SpriteControl.Level < -3) {
                                    SystemValue.G.drawImage(this.SpritePetBlue, (int)(this.mSprite.mLocation.X - this.mLocation.X - 35.0 + 6.0), (int)(this.mSprite.mLocation.Y - this.mLocation.Y + 20.0 + 4.0), 0);
                                } else {
                                    SystemValue.G.drawImage(this.SpritePetGreed, (int)(this.mSprite.mLocation.X - this.mLocation.X - 35.0 + 6.0), (int)(this.mSprite.mLocation.Y - this.mLocation.Y + 20.0 + 4.0), 0);
                                }
                            }
                            ++this.i;
                        }
                    }
                    if (this._map_Items[this.yy][this.xx] > 0) {
                        this.Value = String.valueOf(this._map_Items[this.yy][this.xx]);
                        this.mMapItems = (MapItems)Resource_Image.Map_Items.get(this.Value);
                        SystemValue.G.drawImage(this.mMapItems.mImage, (int)((double)((this._map_Color[0].length - 1) * (SystemValue.CellSize_X / 2) + (this.xx - this.yy) * (SystemValue.CellSize_X / 2)) - this.mLocation.X - (double)this.mMapItems.ImageX), (int)((double)((this.xx + this.yy) * (SystemValue.CellSize_Y / 2)) - this.mLocation.Y - (double)this.mMapItems.ImageY), 0);
                    }
                }
                ++this.x;
            }
            ++this.y;
        }
    }

    public int Map_Width() {
        return this._map_Color[0].length * (SystemValue.CellSize_X / 2);
    }

    public int Map_Hight() {
        return this._map_Color.length * (SystemValue.CellSize_Y / 2);
    }

    public int Rows() {
        return this._map_Color[0].length;
    }

    public int Cols() {
        return this._map_Color.length;
    }

    public int[] Compute(double X, double Y) {
        if (SystemValue.CellSize_X % 2 != 0) {
            --SystemValue.CellSize_X;
        }
        if (SystemValue.CellSize_Y % 2 != 0) {
            --SystemValue.CellSize_Y;
        }
        double a = this._map_Color[0].length * SystemValue.CellSize_X / 2;
        double b = 0.0 - a * (double)SystemValue.CellSize_Y / (double)SystemValue.CellSize_X;
        double c = Y - X * (double)SystemValue.CellSize_Y / (double)SystemValue.CellSize_X;
        double d = c - b;
        double e = X + Y * (double)SystemValue.CellSize_X / (double)SystemValue.CellSize_Y;
        double f = e - a;
        int y = d < 0.0 ? (int)(d / (double)SystemValue.CellSize_Y - 1.0) : (int)(d / (double)SystemValue.CellSize_Y);
        int x = f < 0.0 ? (int)(f / (double)SystemValue.CellSize_X - 1.0) : (int)(f / (double)SystemValue.CellSize_X);
        return new int[]{x, y};
    }

    public static double[] Map8Speed_35(double x, double y, int speed, int direction) {
        switch (direction) {
            case 0: {
                y -= (double)speed;
                break;
            }
            case 1: {
                x += (double)speed * 0.8;
                y -= (double)speed * 0.6;
                break;
            }
            case 2: {
                x += (double)speed;
                break;
            }
            case 3: {
                x += (double)speed * 0.8;
                y += (double)speed * 0.6;
                break;
            }
            case 4: {
                y += (double)speed;
                break;
            }
            case 5: {
                x -= (double)speed * 0.8;
                y += (double)speed * 0.6;
                break;
            }
            case 6: {
                x -= (double)speed;
                break;
            }
            case 7: {
                x -= (double)speed * 0.8;
                y -= (double)speed * 0.6;
            }
        }
        return new double[]{x, y};
    }

    public static void Map8Speed_35(Location location, int speed, int direction) {
        switch (direction) {
            case 0: {
                location.Y -= (double)speed;
                break;
            }
            case 1: {
                location.X += (double)speed * 0.8;
                location.Y -= (double)speed * 0.6;
                break;
            }
            case 2: {
                location.X += (double)speed;
                break;
            }
            case 3: {
                location.X += (double)speed * 0.8;
                location.Y += (double)speed * 0.6;
                break;
            }
            case 4: {
                location.Y += (double)speed;
                break;
            }
            case 5: {
                location.X -= (double)speed * 0.8;
                location.Y += (double)speed * 0.6;
                break;
            }
            case 6: {
                location.X -= (double)speed;
                break;
            }
            case 7: {
                location.X -= (double)speed * 0.8;
                location.Y -= (double)speed * 0.6;
            }
        }
    }

    public void MapSprite_Remove(Sprite sprite) {
        int[] i = this.Compute(sprite.mLocation.X, sprite.mLocation.Y);
        this._map_Sprite[i[1]][i[0]].removeElement(sprite);
    }

    public void MapSprite_Add(Sprite sprite) {
        int[] i = this.Compute(sprite.mLocation.X, sprite.mLocation.Y);
        if (this._map_Sprite[i[1]][i[0]] == null) {
            this._map_Sprite[i[1]][i[0]] = new Vector();
        }
        this._map_Sprite[i[1]][i[0]].addElement(sprite);
    }
}

