/*
 * Decompiled with CFR 0.152.
 */
package frostbit.theme.controls;

import frostbit.theme.XML;
import frostbit.theme.controls.ColorSelect;
import frostbit.theme.controls.ImageControl;
import frostbit.theme.controls.Manager;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import other.Config;

public class ColorControl
implements ItemCommandListener {
    public static Form dForm;
    public Image image;
    private Graphics a;
    public ImageItem ii;
    public Form parent = dForm;
    public int color;
    public boolean isAC;
    public String key;
    public String caption;

    public void destroy() {
        this.image = null;
        this.a = null;
        this.ii = null;
        this.parent = null;
        this.key = null;
        this.caption = null;
    }

    public ColorControl(String string, String charSequence) {
        this.key = charSequence;
        charSequence = XML.get(this.key, 1);
        if (((String)charSequence).equals("")) {
            this.color = -1;
        } else if (((String)charSequence).charAt(1) == 'x') {
            charSequence = ((String)charSequence).substring(2);
        }
        this.isAC = ((String)charSequence).length() == 8;
        try {
            this.color = Integer.parseInt((String)charSequence, 16);
        }
        catch (Exception exception) {
            this.color = -1;
        }
        this.caption = Config.lng_en ? this.key.replace('_', ' ') : string;
        charSequence = new StringBuffer(this.caption);
        if (this.color == -1) {
            ((StringBuffer)charSequence).append(" (\u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d)");
        } else {
            ((StringBuffer)charSequence).append(" (0x").append(ColorSelect.toHex(this.color, this.isAC)).append(")");
        }
        this.ii = new ImageItem(((StringBuffer)charSequence).toString(), null, 3, null);
        this.image = Image.createImage((int)48, (int)12);
        this.a = this.image.getGraphics();
        this.refresh();
        this.ii.setItemCommandListener((ItemCommandListener)this);
        this.ii.addCommand(Manager.cChange);
        this.ii.addCommand(ImageControl.remove);
        this.parent.append((Item)this.ii);
    }

    public void refresh() {
        this.a.setColor(this.color == -1 ? 0 : this.color);
        if (this.isAC) {
            this.a.fillRect(1, 1, 46, 10);
            this.a.setColor(this.color >>> 24, this.color >>> 24, this.color >>> 24);
            this.a.fillRect(1, 1, 23, 10);
        } else {
            this.a.fillRect(1, 1, 46, 10);
        }
        this.a.setColor(0xFFFFFF);
        this.a.drawRect(0, 0, 47, 47);
        this.ii.setImage(this.image);
        StringBuffer stringBuffer = new StringBuffer(this.caption);
        if (this.color == -1) {
            stringBuffer.append(" (\u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d)");
        } else {
            stringBuffer.append(" (0x").append(ColorSelect.toHex(this.color, this.isAC)).append(")");
        }
        this.ii.setLabel(stringBuffer.toString());
    }

    public void save() {
        XML.set(this.key, this.color == -1 ? "" : "0x" + ColorSelect.toHex(this.color, this.isAC), 1);
    }

    public void commandAction(Command command, Item item) {
        if (command == Manager.cChange) {
            ColorSelect.show(this, (Displayable)this.parent);
            return;
        }
        if (this.color != -1) {
            this.color = -1;
            this.refresh();
            this.save();
        }
    }
}

