/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.bsp2D;

import java.util.Enumeration;
import java.util.Vector;
import org.thenesis.planetino2.bsp2D.BSPPolygon;
import org.thenesis.planetino2.graphics3D.texture.Texture;
import org.thenesis.planetino2.math3D.Rectangle3D;
import org.thenesis.planetino2.math3D.Vector3D;

public class RoomDef {
    private static final Vector3D FLOOR_NORMAL = new Vector3D(0.0f, 1.0f, 0.0f);
    private static final Vector3D CEIL_NORMAL = new Vector3D(0.0f, -1.0f, 0.0f);
    private HorizontalAreaDef floor;
    private HorizontalAreaDef ceil;
    private Vector vertices;
    private float ambientLightIntensity;

    public RoomDef() {
        this(0.5f);
    }

    public RoomDef(float ambientLightIntensity) {
        this.ambientLightIntensity = ambientLightIntensity;
        this.vertices = new Vector();
    }

    public void addVertex(float x, float z, Texture texture) {
        this.addVertex(x, z, Math.min(this.floor.height, this.ceil.height), Math.max(this.floor.height, this.ceil.height), texture);
    }

    public void addVertex(float x, float z, float bottom, float top, Texture texture) {
        this.vertices.addElement(new Vertex(x, z, bottom, top, texture, null));
    }

    public void addVertex(float x, float z, float bottom, float top, Texture texture, Rectangle3D texBounds) {
        this.vertices.addElement(new Vertex(x, z, bottom, top, texture, texBounds));
    }

    public void setFloor(float height, Texture texture) {
        this.setFloor(height, texture, null);
    }

    public void setFloor(float height, Texture texture, Rectangle3D texBounds) {
        if (texture != null && texBounds == null) {
            texBounds = new Rectangle3D(new Vector3D(0.0f, height, 0.0f), new Vector3D(1.0f, 0.0f, 0.0f), new Vector3D(0.0f, 0.0f, -1.0f), texture.getWidth(), texture.getHeight());
        }
        this.floor = new HorizontalAreaDef(height, texture, texBounds);
    }

    public void setCeil(float height, Texture texture) {
        this.setCeil(height, texture, null);
    }

    public void setCeil(float height, Texture texture, Rectangle3D texBounds) {
        if (texture != null && texBounds == null) {
            texBounds = new Rectangle3D(new Vector3D(0.0f, height, 0.0f), new Vector3D(1.0f, 0.0f, 0.0f), new Vector3D(0.0f, 0.0f, 1.0f), texture.getWidth(), texture.getHeight());
        }
        this.ceil = new HorizontalAreaDef(height, texture, texBounds);
    }

    public Vector createPolygons() {
        Vector walls = this.createVerticalPolygons();
        Vector floors = this.createHorizontalPolygons();
        Vector list = new Vector(walls.size() + floors.size());
        Enumeration e = walls.elements();
        while (e.hasMoreElements()) {
            list.addElement(e.nextElement());
        }
        e = floors.elements();
        while (e.hasMoreElements()) {
            list.addElement(e.nextElement());
        }
        return list;
    }

    public Vector createVerticalPolygons() {
        int size = this.vertices.size();
        Vector<BSPPolygon> list = new Vector<BSPPolygon>(size);
        if (size == 0) {
            return list;
        }
        Vertex origin = (Vertex)this.vertices.elementAt(0);
        Vector3D textureOrigin = new Vector3D(origin.x, this.ceil.height, origin.z);
        Vector3D textureDy = new Vector3D(0.0f, -1.0f, 0.0f);
        for (int i = 0; i < size; ++i) {
            Vertex next;
            Vertex prev;
            Vertex curr = (Vertex)this.vertices.elementAt(i);
            if (!curr.isWall()) continue;
            int type = 1;
            if (this.floor.height > this.ceil.height) {
                if (this.floor.height - this.ceil.height <= 32.0f) {
                    type = 2;
                }
            } else if (curr.top - curr.bottom <= 32.0f) {
                type = 2;
            } else if (curr.bottom - this.floor.height >= 128.0f) {
                type = 2;
            }
            Vector<Vector3D> wallVertices = new Vector<Vector3D>();
            if (this.floor.height < this.ceil.height) {
                prev = (Vertex)this.vertices.elementAt((i + size - 1) % size);
                next = (Vertex)this.vertices.elementAt((i + 1) % size);
            } else {
                prev = (Vertex)this.vertices.elementAt((i + 1) % size);
                next = (Vertex)this.vertices.elementAt((i + size - 1) % size);
            }
            wallVertices.addElement(new Vector3D(next.x, curr.bottom, next.z));
            wallVertices.addElement(new Vector3D(curr.x, curr.bottom, curr.z));
            if (prev.isWall()) {
                if (prev.bottom > curr.bottom && prev.bottom < curr.top) {
                    wallVertices.addElement(new Vector3D(curr.x, prev.bottom, curr.z));
                }
                if (prev.top > curr.bottom && prev.top < curr.top) {
                    wallVertices.addElement(new Vector3D(curr.x, prev.top, curr.z));
                }
            }
            wallVertices.addElement(new Vector3D(curr.x, curr.top, curr.z));
            wallVertices.addElement(new Vector3D(next.x, curr.top, next.z));
            if (next.isWall()) {
                if (next.top > curr.bottom && next.top < curr.top) {
                    wallVertices.addElement(new Vector3D(next.x, next.top, next.z));
                }
                if (next.bottom > curr.bottom && next.bottom < curr.top) {
                    wallVertices.addElement(new Vector3D(next.x, next.bottom, next.z));
                }
            }
            Object[] array = new Vector3D[wallVertices.size()];
            wallVertices.copyInto(array);
            BSPPolygon poly = new BSPPolygon((Vector3D[])array, type);
            poly.setAmbientLightIntensity(this.ambientLightIntensity);
            if (curr.textureBounds == null) {
                Vector3D textureDx = new Vector3D(next.x, 0.0f, next.z);
                textureDx.subtract(new Vector3D(curr.x, 0.0f, curr.z));
                textureDx.normalize();
                curr.textureBounds = new Rectangle3D(textureOrigin, textureDx, textureDy, curr.texture.getWidth(), curr.texture.getHeight());
            }
            poly.setTexture(curr.texture, curr.textureBounds);
            list.addElement(poly);
        }
        return list;
    }

    public Vector createHorizontalPolygons() {
        Vector<BSPPolygon> list = new Vector<BSPPolygon>(2);
        int size = this.vertices.size();
        Vector3D[] floorVertices = new Vector3D[size];
        Vector3D[] ceilVertices = new Vector3D[size];
        for (int i = 0; i < size; ++i) {
            Vertex v = (Vertex)this.vertices.elementAt(i);
            floorVertices[i] = new Vector3D(v.x, this.floor.height, v.z);
            ceilVertices[size - (i + 1)] = new Vector3D(v.x, this.ceil.height, v.z);
        }
        if (this.floor.texture != null) {
            BSPPolygon poly = new BSPPolygon(floorVertices, 0);
            poly.setTexture(this.floor.texture, this.floor.textureBounds);
            poly.setNormal(FLOOR_NORMAL);
            poly.setAmbientLightIntensity(this.ambientLightIntensity);
            list.addElement(poly);
        }
        if (this.ceil.texture != null) {
            BSPPolygon poly = new BSPPolygon(ceilVertices, 0);
            poly.setTexture(this.ceil.texture, this.ceil.textureBounds);
            poly.setNormal(CEIL_NORMAL);
            poly.setAmbientLightIntensity(this.ambientLightIntensity);
            list.addElement(poly);
        }
        return list;
    }

    private static class Vertex {
        float x;
        float z;
        float bottom;
        float top;
        Texture texture;
        Rectangle3D textureBounds;

        public Vertex(float x, float z, float bottom, float top, Texture texture, Rectangle3D textureBounds) {
            this.x = x;
            this.z = z;
            this.bottom = bottom;
            this.top = top;
            this.texture = texture;
            this.textureBounds = textureBounds;
        }

        public boolean isWall() {
            return this.bottom != this.top && this.texture != null;
        }
    }

    private static class HorizontalAreaDef {
        float height;
        Texture texture;
        Rectangle3D textureBounds;

        public HorizontalAreaDef(float height, Texture texture, Rectangle3D textureBounds) {
            this.height = height;
            this.texture = texture;
            this.textureBounds = textureBounds;
        }
    }
}

