/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.bsp2D;

import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import org.thenesis.planetino2.bsp2D.BSPPolygon;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.bsp2D.BSPTreeTraverseListener;
import org.thenesis.planetino2.bsp2D.BSPTreeTraverser;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.graphics3D.FastTexturedPolygonRenderer;
import org.thenesis.planetino2.graphics3D.ScanConverter;
import org.thenesis.planetino2.graphics3D.ShadedSurfacePolygonRenderer;
import org.thenesis.planetino2.graphics3D.SortedScanConverter;
import org.thenesis.planetino2.graphics3D.texture.Texture;
import org.thenesis.planetino2.math3D.Rectangle3D;
import org.thenesis.planetino2.math3D.TexturedPolygon3D;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.ViewWindow;

public class SimpleBSPRenderer
extends ShadedSurfacePolygonRenderer
implements BSPTreeTraverseListener {
    protected Graphics currentGraphics2D;
    protected BSPTreeTraverser traverser;
    protected boolean viewNotFilledFirstTime = true;
    static /* synthetic */ Class class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture;
    static /* synthetic */ Class class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture;
    static /* synthetic */ Class class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface;

    public SimpleBSPRenderer(Transform3D camera, ViewWindow viewWindow) {
        super(camera, viewWindow, false);
    }

    protected void init() {
        this.traverser = new BSPTreeTraverser(this);
        this.destPolygon = new TexturedPolygon3D();
        this.scanConverter = new SortedScanConverter(this.viewWindow);
        ((SortedScanConverter)this.scanConverter).setSortedMode(true);
        this.scanRenderers = new Hashtable();
        this.scanRenderers.put(class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture == null ? (class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture = SimpleBSPRenderer.class$("org.thenesis.planetino2.graphics3D.texture.PowerOf2Texture")) : class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture, new FastTexturedPolygonRenderer.PowerOf2TextureRenderer(this));
        this.scanRenderers.put(class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture == null ? (class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture = SimpleBSPRenderer.class$("org.thenesis.planetino2.graphics3D.texture.ShadedTexture")) : class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture, new FastTexturedPolygonRenderer.ShadedTextureRenderer(this));
        this.scanRenderers.put(class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface == null ? (class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface = SimpleBSPRenderer.class$("org.thenesis.planetino2.graphics3D.texture.ShadedSurface")) : class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface, new FastTexturedPolygonRenderer.ShadedSurfaceRenderer(this));
    }

    public void startFrame(Screen screen) {
        super.startFrame(screen);
        ((SortedScanConverter)this.scanConverter).clear();
    }

    public void endFrame(Screen screen) {
        super.endFrame(screen);
        if (!((SortedScanConverter)this.scanConverter).isFilled()) {
            if (this.viewNotFilledFirstTime) {
                this.viewNotFilledFirstTime = false;
                System.out.println("View not completely filled.");
            }
            this.clearViewEveryFrame = true;
        } else {
            this.clearViewEveryFrame = false;
        }
    }

    public void draw(Graphics g, BSPTree tree) {
        this.currentGraphics2D = g;
        this.traverser.traverse(tree, this.camera.getLocation());
    }

    public boolean visitPolygon(BSPPolygon poly, boolean isBack) {
        this.draw(this.currentGraphics2D, poly);
        return !((SortedScanConverter)this.scanConverter).isFilled();
    }

    protected void drawCurrentPolygon(Graphics g) {
        if (!(this.sourcePolygon instanceof TexturedPolygon3D)) {
            return;
        }
        this.buildSurface();
        SortedScanConverter scanConverter = (SortedScanConverter)this.scanConverter;
        TexturedPolygon3D poly = (TexturedPolygon3D)this.destPolygon;
        Texture texture = poly.getTexture();
        FastTexturedPolygonRenderer.ScanRenderer scanRenderer = (FastTexturedPolygonRenderer.ScanRenderer)this.scanRenderers.get(texture.getClass());
        scanRenderer.setTexture(texture);
        Rectangle3D textureBounds = poly.getTextureBounds();
        this.a.setToCrossProduct(textureBounds.getDirectionV(), textureBounds.getOrigin());
        this.b.setToCrossProduct(textureBounds.getOrigin(), textureBounds.getDirectionU());
        this.c.setToCrossProduct(textureBounds.getDirectionU(), textureBounds.getDirectionV());
        int y = scanConverter.getTopBoundary();
        this.viewPos.y = this.viewWindow.convertFromScreenYToViewY(y);
        this.viewPos.z = -this.viewWindow.getDistance();
        while (y <= scanConverter.getBottomBoundary()) {
            for (int i = 0; i < scanConverter.getNumScans(y); ++i) {
                ScanConverter.Scan scan = scanConverter.getScan(y, i);
                if (!scan.isValid()) continue;
                this.viewPos.x = this.viewWindow.convertFromScreenXToViewX(scan.left);
                int offset = (y - this.viewWindow.getTopOffset()) * this.viewWindow.getWidth() + (scan.left - this.viewWindow.getLeftOffset());
                scanRenderer.render(offset, scan.left, scan.right);
            }
            ++y;
            this.viewPos.y -= 1.0f;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

