/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.game;

import java.util.Vector;
import org.thenesis.planetino2.bsp2D.BSPLine;
import org.thenesis.planetino2.bsp2D.BSPPolygon;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.bsp2D.Point2D;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.math3D.PolygonGroupBounds;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.util.MoreMath;

public class CollisionDetection {
    private static final Point2D.Float[] CORNERS = new Point2D.Float[]{new Point2D.Float(-1.0f, -1.0f), new Point2D.Float(-1.0f, 1.0f), new Point2D.Float(1.0f, 1.0f), new Point2D.Float(1.0f, -1.0f)};
    private BSPTree bspTree;
    private BSPLine path;
    private Point2D.Float intersection;

    public CollisionDetection(BSPTree bspTree) {
        this.bspTree = bspTree;
        this.path = new BSPLine();
        this.intersection = new Point2D.Float();
    }

    public boolean checkBSP(GameObject object, Vector3D oldLocation, long elapsedTime) {
        boolean wallCollision = false;
        if (object.getX() != oldLocation.x || object.getZ() != oldLocation.z) {
            wallCollision = this.checkWalls(object, oldLocation, elapsedTime) != null;
        }
        this.getFloorAndCeiling(object);
        this.checkFloorAndCeiling(object, elapsedTime);
        return wallCollision;
    }

    public void getFloorAndCeiling(GameObject object) {
        float x = object.getX();
        float z = object.getZ();
        float r = object.getBounds().getRadius() - 1.0f;
        float floorHeight = Float.MIN_VALUE;
        float ceilHeight = Float.MAX_VALUE;
        BSPTree.Leaf leaf = this.bspTree.getLeaf(x, z);
        if (leaf != null) {
            floorHeight = leaf.floorHeight;
            ceilHeight = leaf.ceilHeight;
        }
        for (int i = 0; i < CORNERS.length; ++i) {
            float xOffset = r * CollisionDetection.CORNERS[i].x;
            float zOffset = r * CollisionDetection.CORNERS[i].y;
            leaf = this.bspTree.getLeaf(x + xOffset, z + zOffset);
            if (leaf == null) continue;
            floorHeight = Math.max(floorHeight, leaf.floorHeight);
            ceilHeight = Math.min(ceilHeight, leaf.ceilHeight);
        }
        object.setFloorHeight(floorHeight);
        object.setCeilHeight(ceilHeight);
    }

    protected void checkFloorAndCeiling(GameObject object, long elapsedTime) {
        boolean collision = false;
        float floorHeight = object.getFloorHeight();
        float ceilHeight = object.getCeilHeight();
        float bottomHeight = object.getBounds().getBottomHeight();
        float topHeight = object.getBounds().getTopHeight();
        if (!object.isFlying()) {
            object.getLocation().y = floorHeight - bottomHeight;
        }
        if (object.getY() + bottomHeight < floorHeight) {
            object.notifyFloorCollision();
            object.getTransform().getVelocity().y = 0.0f;
            object.getLocation().y = floorHeight - bottomHeight;
        } else if (object.getY() + topHeight > ceilHeight) {
            object.notifyCeilingCollision();
            object.getTransform().getVelocity().y = 0.0f;
            object.getLocation().y = ceilHeight - topHeight;
        }
    }

    public BSPPolygon checkWalls(GameObject object, Vector3D oldLocation, long elapsedTime) {
        int i;
        Vector3D v = object.getTransform().getVelocity();
        PolygonGroupBounds bounds = object.getBounds();
        float x = object.getX();
        float y = object.getY();
        float z = object.getZ();
        float r = bounds.getRadius();
        float stepSize = 0.0f;
        if (!object.isFlying()) {
            stepSize = 32.0f;
        }
        float bottom = object.getY() + bounds.getBottomHeight() + stepSize;
        float top = object.getY() + bounds.getTopHeight();
        BSPPolygon closestWall = null;
        float closestDistSq = Float.MAX_VALUE;
        for (i = 0; i < CORNERS.length; ++i) {
            float z2;
            float dz;
            float x2;
            float dx;
            float distSq;
            float xOffset = r * CollisionDetection.CORNERS[i].x;
            float zOffset = r * CollisionDetection.CORNERS[i].y;
            BSPPolygon wall = this.getFirstWallIntersection(oldLocation.x + xOffset, oldLocation.z + zOffset, x + xOffset, z + zOffset, bottom, top);
            if (wall == null || !((distSq = (dx = (x2 = this.intersection.x - xOffset) - oldLocation.x) * dx + (dz = (z2 = this.intersection.y - zOffset) - oldLocation.z) * dz) < closestDistSq) && (distSq != closestDistSq || MoreMath.sign(xOffset) != MoreMath.sign(v.x) || MoreMath.sign(zOffset) != MoreMath.sign(v.z))) continue;
            closestWall = wall;
            closestDistSq = distSq;
            object.getLocation().setTo(x2, y, z2);
        }
        if (closestWall != null) {
            object.notifyWallCollision();
        }
        x = object.getX();
        z = object.getZ();
        r -= 1.0f;
        for (i = 0; i < CORNERS.length; ++i) {
            float zOffset2;
            float xOffset2;
            float zOffset1;
            float xOffset1;
            BSPPolygon wall;
            int next = i + 1;
            if (next == CORNERS.length) {
                next = 0;
            }
            if ((wall = this.getFirstWallIntersection(x + (xOffset1 = r * CollisionDetection.CORNERS[i].x), z + (zOffset1 = r * CollisionDetection.CORNERS[i].y), x + (xOffset2 = r * CollisionDetection.CORNERS[next].x), z + (zOffset2 = r * CollisionDetection.CORNERS[next].y), bottom, top)) == null) continue;
            object.notifyWallCollision();
            object.getLocation().setTo(oldLocation.x, object.getY(), oldLocation.z);
            return wall;
        }
        return closestWall;
    }

    public BSPPolygon getFirstWallIntersection(float x1, float z1, float x2, float z2, float yBottom, float yTop) {
        return this.getFirstWallIntersection(this.bspTree.getRoot(), x1, z1, x2, z2, yBottom, yTop);
    }

    protected BSPPolygon getFirstWallIntersection(BSPTree.Node node, float x1, float z1, float x2, float z2, float yBottom, float yTop) {
        BSPPolygon wall;
        float intersectionZ;
        float intersectionX;
        if (node == null || node instanceof BSPTree.Leaf) {
            return null;
        }
        int start = node.partition.getSideThick(x1, z1);
        int end = node.partition.getSideThick(x2, z2);
        if (end == 0) {
            end = start;
        }
        if (start == 0) {
            intersectionX = x1;
            intersectionZ = z1;
        } else if (start != end) {
            this.path.setLine(x1, z1, x2, z2);
            node.partition.getIntersectionPoint(this.path, this.intersection);
            intersectionX = this.intersection.x;
            intersectionZ = this.intersection.y;
        } else {
            intersectionX = x2;
            intersectionZ = z2;
        }
        if (start == 0 && start == end) {
            return null;
        }
        if (start != 0 && (wall = this.getFirstWallIntersection(start == 1 ? node.front : node.back, x1, z1, intersectionX, intersectionZ, yBottom, yTop)) != null) {
            return wall;
        }
        if ((start != end || start == 0) && (wall = this.getWallCollision(node.polygons, x1, z1, x2, z2, yBottom, yTop)) != null) {
            this.intersection.setLocation(intersectionX, intersectionZ);
            return wall;
        }
        if (start != end && (wall = this.getFirstWallIntersection(end == 1 ? node.front : node.back, intersectionX, intersectionZ, x2, z2, yBottom, yTop)) != null) {
            return wall;
        }
        return null;
    }

    protected BSPPolygon getWallCollision(Vector polygons, float x1, float z1, float x2, float z2, float yBottom, float yTop) {
        this.path.setLine(x1, z1, x2, z2);
        for (int i = 0; i < polygons.size(); ++i) {
            int side2;
            int side1;
            BSPPolygon poly = (BSPPolygon)polygons.elementAt(i);
            BSPLine wall = poly.getLine();
            if (wall == null || wall.top <= yBottom || wall.bottom > yTop || wall.getSideThin(x2, z2) != -1 || (side1 = this.path.getSideThin(wall.x1, wall.y1)) == (side2 = this.path.getSideThin(wall.x2, wall.y2))) continue;
            return poly;
        }
        return null;
    }

    public boolean checkObject(GameObject objectA, Vector objects, Vector3D oldLocation) {
        boolean collision = false;
        for (int i = 0; i < objects.size(); ++i) {
            GameObject objectB = (GameObject)objects.elementAt(i);
            collision |= this.checkObject(objectA, objectB, oldLocation);
        }
        return collision;
    }

    public boolean checkObject(GameObject objectA, GameObject objectB, Vector3D oldLocation) {
        float minDist;
        float minDistSq;
        float dz;
        if (objectA == objectB) {
            return false;
        }
        PolygonGroupBounds boundsA = objectA.getBounds();
        PolygonGroupBounds boundsB = objectB.getBounds();
        float Ay1 = objectA.getY() + boundsA.getBottomHeight();
        float Ay2 = objectA.getY() + boundsA.getTopHeight();
        float By1 = objectB.getY() + boundsB.getBottomHeight();
        float By2 = objectB.getY() + boundsB.getTopHeight();
        if (By2 < Ay1 || By1 > Ay2) {
            return false;
        }
        float dx = objectA.getX() - objectB.getX();
        float distSq = dx * dx + (dz = objectA.getZ() - objectB.getZ()) * dz;
        if (distSq < (minDistSq = (minDist = boundsA.getRadius() + boundsB.getRadius()) * minDist)) {
            return this.handleObjectCollision(objectA, objectB, distSq, minDistSq, oldLocation);
        }
        return false;
    }

    protected boolean handleObjectCollision(GameObject objectA, GameObject objectB, float distSq, float minDistSq, Vector3D oldLocation) {
        objectA.notifyObjectCollision(objectB);
        return true;
    }
}

