/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.graphics;

import java.util.Vector;
import javax.microedition.lcdui.Image;

public class Animation {
    private Vector frames;
    private int currFrameIndex;
    private long animTime;
    private long totalDuration;

    public Animation() {
        this(new Vector(), 0L);
    }

    private Animation(Vector frames, long totalDuration) {
        this.frames = frames;
        this.totalDuration = totalDuration;
        this.start();
    }

    public Object clone() {
        return new Animation(this.frames, this.totalDuration);
    }

    public synchronized void addFrame(Image image, long duration) {
        this.totalDuration += duration;
        this.frames.addElement(new AnimFrame(image, this.totalDuration));
    }

    public synchronized void start() {
        this.animTime = 0L;
        this.currFrameIndex = 0;
    }

    public synchronized void update(long elapsedTime) {
        if (this.frames.size() > 1) {
            this.animTime += elapsedTime;
            if (this.animTime >= this.totalDuration) {
                this.animTime %= this.totalDuration;
                this.currFrameIndex = 0;
            }
            while (this.animTime > this.getFrame((int)this.currFrameIndex).endTime) {
                ++this.currFrameIndex;
            }
        }
    }

    public synchronized Image getImage() {
        if (this.frames.size() == 0) {
            return null;
        }
        return this.getFrame((int)this.currFrameIndex).image;
    }

    private AnimFrame getFrame(int i) {
        return (AnimFrame)this.frames.elementAt(i);
    }

    private class AnimFrame {
        Image image;
        long endTime;

        public AnimFrame(Image image, long endTime) {
            this.image = image;
            this.endTime = endTime;
        }
    }
}

