/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.graphics3D;

import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.graphics3D.PolygonRenderer;
import org.thenesis.planetino2.graphics3D.ScanConverter;
import org.thenesis.planetino2.graphics3D.texture.PowerOf2Texture;
import org.thenesis.planetino2.graphics3D.texture.ShadedSurface;
import org.thenesis.planetino2.graphics3D.texture.ShadedTexture;
import org.thenesis.planetino2.graphics3D.texture.Texture;
import org.thenesis.planetino2.math3D.Rectangle3D;
import org.thenesis.planetino2.math3D.TexturedPolygon3D;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.math3D.ViewWindow;

public class FastTexturedPolygonRenderer
extends PolygonRenderer {
    public static final int SCALE_BITS = 12;
    public static final int SCALE = 4096;
    public static final int INTERP_SIZE_BITS = 4;
    public static final int INTERP_SIZE = 16;
    protected Vector3D a = new Vector3D();
    protected Vector3D b = new Vector3D();
    protected Vector3D c = new Vector3D();
    protected Vector3D viewPos = new Vector3D();
    protected Image offscreenImage;
    protected int[] doubleBufferData;
    protected Hashtable scanRenderers;
    static /* synthetic */ Class class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture;
    static /* synthetic */ Class class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture;
    static /* synthetic */ Class class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface;

    public FastTexturedPolygonRenderer(Transform3D camera, ViewWindow viewWindow) {
        this(camera, viewWindow, true);
    }

    public FastTexturedPolygonRenderer(Transform3D camera, ViewWindow viewWindow, boolean clearViewEveryFrame) {
        super(camera, viewWindow, clearViewEveryFrame);
    }

    protected void init() {
        this.destPolygon = new TexturedPolygon3D();
        this.scanConverter = new ScanConverter(this.viewWindow);
        this.scanRenderers = new Hashtable();
        this.scanRenderers.put(class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture == null ? (class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture = FastTexturedPolygonRenderer.class$("org.thenesis.planetino2.graphics3D.texture.PowerOf2Texture")) : class$org$thenesis$planetino2$graphics3D$texture$PowerOf2Texture, new PowerOf2TextureRenderer());
        this.scanRenderers.put(class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture == null ? (class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture = FastTexturedPolygonRenderer.class$("org.thenesis.planetino2.graphics3D.texture.ShadedTexture")) : class$org$thenesis$planetino2$graphics3D$texture$ShadedTexture, new ShadedTextureRenderer());
        this.scanRenderers.put(class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface == null ? (class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface = FastTexturedPolygonRenderer.class$("org.thenesis.planetino2.graphics3D.texture.ShadedSurface")) : class$org$thenesis$planetino2$graphics3D$texture$ShadedSurface, new ShadedSurfaceRenderer());
    }

    public void startFrame(Screen screen) {
        if (this.offscreenImage == null) {
            this.doubleBufferData = new int[this.viewWindow.getWidth() * this.viewWindow.getHeight()];
        }
        if (this.clearViewEveryFrame) {
            for (int i = 0; i < this.doubleBufferData.length; ++i) {
                this.doubleBufferData[i] = 0;
            }
        }
    }

    public void endFrame(Screen screen) {
        Graphics g = screen.getGraphics();
        int w = screen.getWidth();
        int h = screen.getHeight();
        g.drawRGB(this.doubleBufferData, 0, w, this.viewWindow.getLeftOffset(), this.viewWindow.getTopOffset(), w, h, false);
    }

    protected void drawCurrentPolygon(Graphics g) {
        if (!(this.sourcePolygon instanceof TexturedPolygon3D)) {
            return;
        }
        TexturedPolygon3D poly = (TexturedPolygon3D)this.destPolygon;
        Texture texture = poly.getTexture();
        ScanRenderer scanRenderer = (ScanRenderer)this.scanRenderers.get(texture.getClass());
        scanRenderer.setTexture(texture);
        Rectangle3D textureBounds = poly.getTextureBounds();
        this.a.setToCrossProduct(textureBounds.getDirectionV(), textureBounds.getOrigin());
        this.b.setToCrossProduct(textureBounds.getOrigin(), textureBounds.getDirectionU());
        this.c.setToCrossProduct(textureBounds.getDirectionU(), textureBounds.getDirectionV());
        int y = this.scanConverter.getTopBoundary();
        this.viewPos.y = this.viewWindow.convertFromScreenYToViewY(y);
        this.viewPos.z = -this.viewWindow.getDistance();
        while (y <= this.scanConverter.getBottomBoundary()) {
            ScanConverter.Scan scan = this.scanConverter.getScan(y);
            if (scan.isValid()) {
                this.viewPos.x = this.viewWindow.convertFromScreenXToViewX(scan.left);
                int offset = (y - this.viewWindow.getTopOffset()) * this.viewWindow.getWidth() + (scan.left - this.viewWindow.getLeftOffset());
                scanRenderer.render(offset, scan.left, scan.right);
            }
            ++y;
            this.viewPos.y -= 1.0f;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ShadedSurfaceRenderer
    extends ScanRenderer {
        public int checkBounds(int vScaled, int bounds) {
            int v = vScaled >> 12;
            if (v < 0) {
                vScaled = 0;
            } else if (v >= bounds) {
                vScaled = bounds - 1 << 12;
            }
            return vScaled;
        }

        public void render(int offset, int left, int right) {
            ShadedSurface texture = (ShadedSurface)this.currentTexture;
            ShadedTexture srcTexture = texture.getSourceTexture();
            int[] buffer = srcTexture.getRawData();
            int widthBits = srcTexture.getWidthBits();
            int widthMask = srcTexture.getWidthMask();
            int heightBits = srcTexture.getHeightBits();
            int heightMask = srcTexture.getHeightMask();
            float u = 4096.0f * FastTexturedPolygonRenderer.this.a.getDotProduct(FastTexturedPolygonRenderer.this.viewPos);
            float v = 4096.0f * FastTexturedPolygonRenderer.this.b.getDotProduct(FastTexturedPolygonRenderer.this.viewPos);
            float z = FastTexturedPolygonRenderer.this.c.getDotProduct(FastTexturedPolygonRenderer.this.viewPos);
            float du = 65536.0f * FastTexturedPolygonRenderer.this.a.x;
            float dv = 65536.0f * FastTexturedPolygonRenderer.this.b.x;
            float dz = 16.0f * FastTexturedPolygonRenderer.this.c.x;
            int nextTx = (int)(u / z);
            int nextTy = (int)(v / z);
            int x = left;
            while (x <= right) {
                int tx = nextTx;
                int ty = nextTy;
                int maxLength = right - x + 1;
                if (maxLength > 16) {
                    nextTx = (int)((u += du) / (z += dz));
                    nextTy = (int)((v += dv) / z);
                    int dtx = nextTx - tx >> 4;
                    int dty = nextTy - ty >> 4;
                    int endOffset = offset + 16;
                    while (offset < endOffset) {
                        FastTexturedPolygonRenderer.this.doubleBufferData[offset++] = buffer[(tx >> 12 & widthMask) + ((ty >> 12 & heightMask) << widthBits)];
                        tx += dtx;
                        ty += dty;
                    }
                    x += 16;
                    continue;
                }
                int interpSize = maxLength;
                nextTx = (int)((u += (float)(interpSize * 4096) * FastTexturedPolygonRenderer.this.a.x) / (z += (float)interpSize * FastTexturedPolygonRenderer.this.c.x));
                nextTy = (int)((v += (float)(interpSize * 4096) * FastTexturedPolygonRenderer.this.b.x) / z);
                tx = this.checkBounds(tx, texture.getWidth());
                ty = this.checkBounds(ty, texture.getHeight());
                nextTx = this.checkBounds(nextTx, texture.getWidth());
                nextTy = this.checkBounds(nextTy, texture.getHeight());
                int dtx = (nextTx - tx) / interpSize;
                int dty = (nextTy - ty) / interpSize;
                int endOffset = offset + interpSize;
                while (offset < endOffset) {
                    FastTexturedPolygonRenderer.this.doubleBufferData[offset++] = buffer[(tx >> 12 & widthMask) + ((ty >> 12 & heightMask) << widthBits)];
                    tx += dtx;
                    ty += dty;
                }
                x += interpSize;
            }
        }
    }

    public class ShadedTextureRenderer
    extends ScanRenderer {
        public void render(int offset, int left, int right) {
            System.out.println("[DEBUG] FastTexturedPolygonRenderer.ShadedTextureZRenderer.render()");
            ShadedTexture texture = (ShadedTexture)this.currentTexture;
            int[] buffer = texture.getRawData();
            int widthBits = texture.getWidthBits();
            int widthMask = texture.getWidthMask();
            int heightBits = texture.getHeightBits();
            int heightMask = texture.getHeightMask();
            float u = 4096.0f * FastTexturedPolygonRenderer.this.a.getDotProduct(FastTexturedPolygonRenderer.this.viewPos);
            float v = 4096.0f * FastTexturedPolygonRenderer.this.b.getDotProduct(FastTexturedPolygonRenderer.this.viewPos);
            float z = FastTexturedPolygonRenderer.this.c.getDotProduct(FastTexturedPolygonRenderer.this.viewPos);
            float du = 65536.0f * FastTexturedPolygonRenderer.this.a.x;
            float dv = 65536.0f * FastTexturedPolygonRenderer.this.b.x;
            float dz = 16.0f * FastTexturedPolygonRenderer.this.c.x;
            int nextTx = (int)(u / z);
            int nextTy = (int)(v / z);
            int x = left;
            while (x <= right) {
                int tx = nextTx;
                int ty = nextTy;
                int maxLength = right - x + 1;
                if (maxLength > 16) {
                    nextTx = (int)((u += du) / (z += dz));
                    nextTy = (int)((v += dv) / z);
                    int dtx = nextTx - tx >> 4;
                    int dty = nextTy - ty >> 4;
                    int endOffset = offset + 16;
                    while (offset < endOffset) {
                        FastTexturedPolygonRenderer.this.doubleBufferData[offset++] = buffer[(tx >> 12 & widthMask) + ((ty >> 12 & heightMask) << widthBits)];
                        tx += dtx;
                        ty += dty;
                    }
                    x += 16;
                    continue;
                }
                int interpSize = maxLength;
                nextTx = (int)((u += (float)(interpSize * 4096) * FastTexturedPolygonRenderer.this.a.x) / (z += (float)interpSize * FastTexturedPolygonRenderer.this.c.x));
                nextTy = (int)((v += (float)(interpSize * 4096) * FastTexturedPolygonRenderer.this.b.x) / z);
                int dtx = (nextTx - tx) / interpSize;
                int dty = (nextTy - ty) / interpSize;
                int endOffset = offset + interpSize;
                while (offset < endOffset) {
                    FastTexturedPolygonRenderer.this.doubleBufferData[offset++] = buffer[(tx >> 12 & widthMask) + ((ty >> 12 & heightMask) << widthBits)];
                    tx += dtx;
                    ty += dty;
                }
                x += interpSize;
            }
        }
    }

    public class PowerOf2TextureRenderer
    extends ScanRenderer {
        public void render(int offset, int left, int right) {
            System.out.println("[DEBUG] FastTexturedPolygonRenderer.PowerOf2TextureRenderer.render()");
            PowerOf2Texture texture = (PowerOf2Texture)this.currentTexture;
            int[] buffer = texture.getRawData();
            int widthBits = texture.getWidthBits();
            int widthMask = texture.getWidthMask();
            int heightBits = texture.getHeightBits();
            int heightMask = texture.getHeightMask();
            float u = 4096.0f * FastTexturedPolygonRenderer.this.a.getDotProduct(FastTexturedPolygonRenderer.this.viewPos);
            float v = 4096.0f * FastTexturedPolygonRenderer.this.b.getDotProduct(FastTexturedPolygonRenderer.this.viewPos);
            float z = FastTexturedPolygonRenderer.this.c.getDotProduct(FastTexturedPolygonRenderer.this.viewPos);
            float du = 65536.0f * FastTexturedPolygonRenderer.this.a.x;
            float dv = 65536.0f * FastTexturedPolygonRenderer.this.b.x;
            float dz = 16.0f * FastTexturedPolygonRenderer.this.c.x;
            int nextTx = (int)(u / z);
            int nextTy = (int)(v / z);
            int x = left;
            while (x <= right) {
                int tx = nextTx;
                int ty = nextTy;
                int maxLength = right - x + 1;
                if (maxLength > 16) {
                    nextTx = (int)((u += du) / (z += dz));
                    nextTy = (int)((v += dv) / z);
                    int dtx = nextTx - tx >> 4;
                    int dty = nextTy - ty >> 4;
                    int endOffset = offset + 16;
                    while (offset < endOffset) {
                        FastTexturedPolygonRenderer.this.doubleBufferData[offset++] = buffer[(tx >> 12 & widthMask) + ((ty >> 12 & heightMask) << widthBits)];
                        tx += dtx;
                        ty += dty;
                    }
                    x += 16;
                    continue;
                }
                int interpSize = maxLength;
                nextTx = (int)((u += (float)(interpSize * 4096) * FastTexturedPolygonRenderer.this.a.x) / (z += (float)interpSize * FastTexturedPolygonRenderer.this.c.x));
                nextTy = (int)((v += (float)(interpSize * 4096) * FastTexturedPolygonRenderer.this.b.x) / z);
                int dtx = (nextTx - tx) / interpSize;
                int dty = (nextTy - ty) / interpSize;
                int endOffset = offset + interpSize;
                while (offset < endOffset) {
                    FastTexturedPolygonRenderer.this.doubleBufferData[offset++] = buffer[(tx >> 12 & widthMask) + ((ty >> 12 & heightMask) << widthBits)];
                    tx += dtx;
                    ty += dty;
                }
                x += interpSize;
            }
        }
    }

    public class Method3
    extends ScanRenderer {
        public void render(int offset, int left, int right) {
            int u = (int)(4096.0f * FastTexturedPolygonRenderer.this.a.getDotProduct(FastTexturedPolygonRenderer.this.viewPos));
            int v = (int)(4096.0f * FastTexturedPolygonRenderer.this.b.getDotProduct(FastTexturedPolygonRenderer.this.viewPos));
            int z = (int)(4096.0f * FastTexturedPolygonRenderer.this.c.getDotProduct(FastTexturedPolygonRenderer.this.viewPos));
            int du = (int)(4096.0f * FastTexturedPolygonRenderer.this.a.x);
            int dv = (int)(4096.0f * FastTexturedPolygonRenderer.this.b.x);
            int dz = (int)(4096.0f * FastTexturedPolygonRenderer.this.c.x);
            for (int x = left; x <= right; ++x) {
                FastTexturedPolygonRenderer.this.doubleBufferData[offset++] = this.currentTexture.getColor(u / z, v / z);
                u += du;
                v += dv;
                z += dz;
            }
        }
    }

    public class Method2
    extends ScanRenderer {
        public void render(int offset, int left, int right) {
            float u = FastTexturedPolygonRenderer.this.a.getDotProduct(FastTexturedPolygonRenderer.this.viewPos);
            float v = FastTexturedPolygonRenderer.this.b.getDotProduct(FastTexturedPolygonRenderer.this.viewPos);
            float z = FastTexturedPolygonRenderer.this.c.getDotProduct(FastTexturedPolygonRenderer.this.viewPos);
            float du = FastTexturedPolygonRenderer.this.a.x;
            float dv = FastTexturedPolygonRenderer.this.b.x;
            float dz = FastTexturedPolygonRenderer.this.c.x;
            for (int x = left; x <= right; ++x) {
                FastTexturedPolygonRenderer.this.doubleBufferData[offset++] = this.currentTexture.getColor((int)(u / z), (int)(v / z));
                u += du;
                v += dv;
                z += dz;
            }
        }
    }

    public class Method1
    extends ScanRenderer {
        public void render(int offset, int left, int right) {
            for (int x = left; x <= right; ++x) {
                int tx = (int)(FastTexturedPolygonRenderer.this.a.getDotProduct(FastTexturedPolygonRenderer.this.viewPos) / FastTexturedPolygonRenderer.this.c.getDotProduct(FastTexturedPolygonRenderer.this.viewPos));
                int ty = (int)(FastTexturedPolygonRenderer.this.b.getDotProduct(FastTexturedPolygonRenderer.this.viewPos) / FastTexturedPolygonRenderer.this.c.getDotProduct(FastTexturedPolygonRenderer.this.viewPos));
                FastTexturedPolygonRenderer.this.doubleBufferData[offset++] = this.currentTexture.getColor(tx, ty);
                FastTexturedPolygonRenderer.this.viewPos.x += 1.0f;
            }
        }
    }

    public class Method0
    extends ScanRenderer {
        public void render(int offset, int left, int right) {
            for (int x = left; x <= right; ++x) {
                FastTexturedPolygonRenderer.this.doubleBufferData[offset++] = 7;
            }
        }
    }

    public abstract class ScanRenderer {
        protected Texture currentTexture;

        public void setTexture(Texture texture) {
            this.currentTexture = texture;
        }

        public abstract void render(int var1, int var2, int var3);
    }
}

