/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.graphics3D;

import org.thenesis.planetino2.graphics3D.ScanConverter;
import org.thenesis.planetino2.math3D.Polygon3D;
import org.thenesis.planetino2.math3D.ViewWindow;

public class SortedScanConverter
extends ScanConverter {
    protected static final int DEFAULT_SCANLIST_CAPACITY = 8;
    private SortedScanList[] viewScans;
    private SortedScanList[] polygonScans;
    private boolean sortedMode = false;

    public SortedScanConverter(ViewWindow view) {
        super(view);
    }

    public void clear() {
        if (this.viewScans != null) {
            for (int y = 0; y < this.viewScans.length; ++y) {
                this.viewScans[y].clear();
            }
        }
    }

    public void setSortedMode(boolean b) {
        this.sortedMode = b;
    }

    public ScanConverter.Scan getScan(int y, int index) {
        return this.polygonScans[y].getScan(index);
    }

    public int getNumScans(int y) {
        return this.polygonScans[y].getNumScans();
    }

    public boolean isFilled() {
        if (this.viewScans == null) {
            return false;
        }
        int left = this.view.getLeftOffset();
        int right = left + this.view.getWidth() - 1;
        for (int y = this.view.getTopOffset(); y < this.viewScans.length; ++y) {
            if (this.viewScans[y].equals(left, right)) continue;
            return false;
        }
        return true;
    }

    protected void ensureCapacity() {
        int oldHeight;
        super.ensureCapacity();
        int height = this.view.getTopOffset() + this.view.getHeight();
        int n = oldHeight = this.viewScans == null ? 0 : this.viewScans.length;
        if (height != oldHeight) {
            SortedScanList[] newViewScans = new SortedScanList[height];
            SortedScanList[] newPolygonScans = new SortedScanList[height];
            if (oldHeight != 0) {
                System.arraycopy(this.viewScans, 0, newViewScans, 0, Math.min(height, oldHeight));
                System.arraycopy(this.polygonScans, 0, newPolygonScans, 0, Math.min(height, oldHeight));
            }
            this.viewScans = newViewScans;
            this.polygonScans = newPolygonScans;
            for (int i = oldHeight; i < height; ++i) {
                this.viewScans[i] = new SortedScanList();
                this.polygonScans[i] = new SortedScanList();
            }
        }
    }

    public boolean convert(Polygon3D polygon) {
        boolean visible = super.convert(polygon);
        if (!this.sortedMode || !visible) {
            return visible;
        }
        visible = false;
        for (int y = this.getTopBoundary(); y <= this.getBottomBoundary(); ++y) {
            ScanConverter.Scan scan = this.getScan(y);
            SortedScanList diff = this.polygonScans[y];
            diff.clear();
            if (!scan.isValid()) continue;
            this.viewScans[y].add(scan.left, scan.right, diff);
            visible |= this.polygonScans[y].getNumScans() > 0;
        }
        return visible;
    }

    private static class SortedScanList {
        private int length;
        private ScanConverter.Scan[] scans;

        public SortedScanList() {
            this(8);
        }

        public SortedScanList(int capacity) {
            this.scans = new ScanConverter.Scan[capacity];
            for (int i = 0; i < capacity; ++i) {
                this.scans[i] = new ScanConverter.Scan();
            }
            this.length = 0;
        }

        public void clear() {
            this.length = 0;
        }

        public int getNumScans() {
            return this.length;
        }

        public ScanConverter.Scan getScan(int index) {
            return this.scans[index];
        }

        public boolean equals(int left, int right) {
            return this.length == 1 && this.scans[0].equals(left, right);
        }

        public void add(int left, int right, SortedScanList diff) {
            for (int i = 0; i < this.length && left <= right; ++i) {
                ScanConverter.Scan scan = this.scans[i];
                int maxRight = scan.left - 1;
                if (left <= maxRight) {
                    if (right < maxRight) {
                        diff.add(left, right);
                        this.insert(left, right, i);
                        return;
                    }
                    diff.add(left, maxRight);
                    scan.left = left;
                    left = scan.right + 1;
                    if (!this.merge(i)) continue;
                    --i;
                    continue;
                }
                if (left > scan.right) continue;
                left = scan.right + 1;
            }
            if (left <= right) {
                this.insert(left, right, this.length);
                diff.add(left, right);
            }
        }

        private void growCapacity() {
            int capacity = this.scans.length;
            int newCapacity = capacity * 2;
            ScanConverter.Scan[] newScans = new ScanConverter.Scan[newCapacity];
            System.arraycopy(this.scans, 0, newScans, 0, capacity);
            for (int i = this.length; i < newCapacity; ++i) {
                newScans[i] = new ScanConverter.Scan();
            }
            this.scans = newScans;
        }

        private void add(int left, int right) {
            if (this.length == this.scans.length) {
                this.growCapacity();
            }
            this.scans[this.length].setTo(left, right);
            ++this.length;
        }

        private void insert(int left, int right, int index) {
            if (index > 0) {
                ScanConverter.Scan prevScan = this.scans[index - 1];
                if (prevScan.right == left - 1) {
                    prevScan.right = right;
                    return;
                }
            }
            if (this.length == this.scans.length) {
                this.growCapacity();
            }
            ScanConverter.Scan last = this.scans[this.length];
            last.setTo(left, right);
            for (int i = this.length; i > index; --i) {
                this.scans[i] = this.scans[i - 1];
            }
            this.scans[index] = last;
            ++this.length;
        }

        private void remove(int index) {
            ScanConverter.Scan removed = this.scans[index];
            for (int i = index; i < this.length - 1; ++i) {
                this.scans[i] = this.scans[i + 1];
            }
            this.scans[this.length - 1] = removed;
            --this.length;
        }

        private boolean merge(int index) {
            if (index > 0) {
                ScanConverter.Scan prevScan = this.scans[index - 1];
                ScanConverter.Scan thisScan = this.scans[index];
                if (prevScan.right == thisScan.left - 1) {
                    prevScan.right = thisScan.right;
                    this.remove(index);
                    return true;
                }
            }
            return false;
        }
    }
}

