/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.graphics3D.texture;

import java.io.IOException;
import javax.microedition.lcdui.Image;
import org.thenesis.planetino2.graphics.Color;
import org.thenesis.planetino2.graphics.DirectColorModel;
import org.thenesis.planetino2.graphics.IndexColorModel;
import org.thenesis.planetino2.graphics3D.texture.PowerOf2Texture;
import org.thenesis.planetino2.graphics3D.texture.ShadedTexture;

public abstract class Texture {
    protected int width;
    protected int height;

    public Texture(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public abstract int getColor(int var1, int var2);

    public static Texture createTexture(String path, String filename) {
        return Texture.createTexture(path, filename, false);
    }

    public static Texture createTexture(String path, String filename, boolean shaded) {
        try {
            Image image = Image.createImage((String)(path + filename));
            return Texture.createTexture(image, shaded);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Texture createTexture(Image image) {
        return Texture.createTexture(image, false);
    }

    public static Texture createTexture(Image image, boolean shaded) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (shaded) {
            int[] rgb888Data = new int[width * height];
            image.getRGB(rgb888Data, 0, width, 0, 0, width, height);
            return new ShadedTexture(rgb888Data, Texture.countbits(width - 1), Texture.countbits(height - 1), new DirectColorModel(32, 0xFF0000, 65280, 255));
        }
        int[] rgb888Data = new int[width * height];
        image.getRGB(rgb888Data, 0, width, 0, 0, width, height);
        return new PowerOf2Texture(rgb888Data, Texture.countbits(width - 1), Texture.countbits(height - 1));
    }

    private static void convertImageToShort(Image src, short[] dest) {
        int w = src.getWidth();
        int h = src.getHeight();
        int[] rgbData = new int[w];
        for (int j = 0; j < h; ++j) {
            src.getRGB(rgbData, 0, w, 0, j, w, 1);
            for (int i = 0; i < w; ++i) {
                dest[j * w + i] = (short)Color.convertRBG888To565(rgbData[i]);
            }
        }
    }

    private static void convertImageTo232(Image src, byte[] dest) {
        int w = src.getWidth();
        int h = src.getHeight();
        int[] rgbData = new int[w];
        for (int j = 0; j < h; ++j) {
            src.getRGB(rgbData, 0, w, 0, 0, w, 1);
            for (int i = 0; i < w; ++i) {
                dest[j * w + i] = (byte)Color.convertRBG888To232(rgbData[i]);
            }
        }
    }

    private static IndexColorModel createDefaultIndexedColorModel(boolean binary) {
        if (binary) {
            byte[] t = new byte[]{0, -1};
            return new IndexColorModel(1, 2, t, t, t);
        }
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        int index = 0;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                for (int k = 0; k < 6; ++k) {
                    r[index] = (byte)(i * 51);
                    g[index] = (byte)(j * 51);
                    b[index] = (byte)(k * 51);
                    ++index;
                }
            }
        }
        while (index < 256) {
            g[index] = b[index] = (byte)(18 + (index - 216) * 6);
            r[index] = b[index];
            ++index;
        }
        return new IndexColorModel(8, 256, r, g, b);
    }

    public static boolean isPowerOfTwo(int n) {
        return (n & n - 1) == 0;
    }

    public static int countbits(int n) {
        int count = 0;
        while (n > 0) {
            count += n & 1;
            n >>= 1;
        }
        return count;
    }

    public static void print(short[] array, int w, int h) {
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                System.out.print(array[j * w + i] + " ");
            }
            System.out.println();
        }
    }
}

