/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.math3D;

import org.thenesis.planetino2.math3D.Rectangle3D;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.Transformable;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.math3D.ViewWindow;

public class Polygon3D
implements Transformable {
    private static Vector3D temp1 = new Vector3D();
    private static Vector3D temp2 = new Vector3D();
    private Vector3D[] v;
    private int numVertices;
    private Vector3D normal;

    public Polygon3D() {
        this.numVertices = 0;
        this.v = new Vector3D[0];
        this.normal = new Vector3D();
    }

    public Polygon3D(Vector3D v0, Vector3D v1, Vector3D v2) {
        this(new Vector3D[]{v0, v1, v2});
    }

    public Polygon3D(Vector3D v0, Vector3D v1, Vector3D v2, Vector3D v3) {
        this(new Vector3D[]{v0, v1, v2, v3});
    }

    public Polygon3D(Vector3D[] vertices) {
        this.v = vertices;
        this.numVertices = vertices.length;
        this.calcNormal();
    }

    public void setTo(Polygon3D polygon) {
        this.numVertices = polygon.numVertices;
        this.normal.setTo(polygon.normal);
        this.ensureCapacity(this.numVertices);
        for (int i = 0; i < this.numVertices; ++i) {
            this.v[i].setTo(polygon.v[i]);
        }
    }

    protected void ensureCapacity(int length) {
        if (this.v.length < length) {
            Vector3D[] newV = new Vector3D[length];
            System.arraycopy(this.v, 0, newV, 0, this.v.length);
            for (int i = this.v.length; i < newV.length; ++i) {
                newV[i] = new Vector3D();
            }
            this.v = newV;
        }
    }

    public int getNumVertices() {
        return this.numVertices;
    }

    public Vector3D getVertex(int index) {
        return this.v[index];
    }

    public void project(ViewWindow view) {
        for (int i = 0; i < this.numVertices; ++i) {
            view.project(this.v[i]);
        }
    }

    public void add(Vector3D u) {
        for (int i = 0; i < this.numVertices; ++i) {
            this.v[i].add(u);
        }
    }

    public void subtract(Vector3D u) {
        for (int i = 0; i < this.numVertices; ++i) {
            this.v[i].subtract(u);
        }
    }

    public void add(Transform3D xform) {
        this.addRotation(xform);
        this.add(xform.getLocation());
    }

    public void subtract(Transform3D xform) {
        this.subtract(xform.getLocation());
        this.subtractRotation(xform);
    }

    public void addRotation(Transform3D xform) {
        for (int i = 0; i < this.numVertices; ++i) {
            this.v[i].addRotation(xform);
        }
        this.normal.addRotation(xform);
    }

    public void subtractRotation(Transform3D xform) {
        for (int i = 0; i < this.numVertices; ++i) {
            this.v[i].subtractRotation(xform);
        }
        this.normal.subtractRotation(xform);
    }

    public Vector3D calcNormal() {
        if (this.normal == null) {
            this.normal = new Vector3D();
        }
        temp1.setTo(this.v[2]);
        temp1.subtract(this.v[1]);
        temp2.setTo(this.v[0]);
        temp2.subtract(this.v[1]);
        this.normal.setToCrossProduct(temp1, temp2);
        this.normal.normalize();
        return this.normal;
    }

    public Vector3D getNormal() {
        return this.normal;
    }

    public void setNormal(Vector3D n) {
        if (this.normal == null) {
            this.normal = new Vector3D(n);
        } else {
            this.normal.setTo(n);
        }
    }

    public boolean isFacing(Vector3D u) {
        temp1.setTo(u);
        temp1.subtract(this.v[0]);
        return this.normal.getDotProduct(temp1) >= 0.0f;
    }

    public boolean clip(float clipZ) {
        int i;
        this.ensureCapacity(this.numVertices * 3);
        boolean isCompletelyHidden = true;
        for (i = 0; i < this.numVertices; ++i) {
            int next = (i + 1) % this.numVertices;
            Vector3D v1 = this.v[i];
            Vector3D v2 = this.v[next];
            if (v1.z < clipZ) {
                isCompletelyHidden = false;
            }
            if (v1.z > v2.z) {
                Vector3D temp = v1;
                v1 = v2;
                v2 = temp;
            }
            if (!(v1.z < clipZ) || !(v2.z > clipZ)) continue;
            float scale = (clipZ - v1.z) / (v2.z - v1.z);
            this.insertVertex(next, v1.x + scale * (v2.x - v1.x), v1.y + scale * (v2.y - v1.y), clipZ);
            ++i;
        }
        if (isCompletelyHidden) {
            return false;
        }
        for (i = this.numVertices - 1; i >= 0; --i) {
            if (!(this.v[i].z > clipZ)) continue;
            this.deleteVertex(i);
        }
        return this.numVertices >= 3;
    }

    protected void insertVertex(int index, float x, float y, float z) {
        Vector3D newVertex = this.v[this.v.length - 1];
        newVertex.x = x;
        newVertex.y = y;
        newVertex.z = z;
        for (int i = this.v.length - 1; i > index; --i) {
            this.v[i] = this.v[i - 1];
        }
        this.v[index] = newVertex;
        ++this.numVertices;
    }

    protected void deleteVertex(int index) {
        Vector3D deleted = this.v[index];
        for (int i = index; i < this.v.length - 1; ++i) {
            this.v[i] = this.v[i + 1];
        }
        this.v[this.v.length - 1] = deleted;
        --this.numVertices;
    }

    public void insertVertex(int index, Vector3D vertex) {
        Vector3D[] newV = new Vector3D[this.numVertices + 1];
        System.arraycopy(this.v, 0, newV, 0, index);
        newV[index] = vertex;
        System.arraycopy(this.v, index, newV, index + 1, this.numVertices - index);
        this.v = newV;
        ++this.numVertices;
    }

    public Rectangle3D calcBoundingRectangle() {
        Rectangle3D boundingRect = new Rectangle3D();
        float minimumArea = Float.MAX_VALUE;
        Vector3D u = new Vector3D();
        Vector3D v = new Vector3D();
        Vector3D d = new Vector3D();
        for (int i = 0; i < this.getNumVertices(); ++i) {
            u.setTo(this.getVertex((i + 1) % this.getNumVertices()));
            u.subtract(this.getVertex(i));
            u.normalize();
            v.setToCrossProduct(this.getNormal(), u);
            v.normalize();
            float uMin = 0.0f;
            float uMax = 0.0f;
            float vMin = 0.0f;
            float vMax = 0.0f;
            for (int j = 0; j < this.getNumVertices(); ++j) {
                if (j == i) continue;
                d.setTo(this.getVertex(j));
                d.subtract(this.getVertex(i));
                float uLength = d.getDotProduct(u);
                float vLength = d.getDotProduct(v);
                uMin = Math.min(uLength, uMin);
                uMax = Math.max(uLength, uMax);
                vMin = Math.min(vLength, vMin);
                vMax = Math.max(vLength, vMax);
            }
            float area = (uMax - uMin) * (vMax - vMin);
            if (!(area < minimumArea)) continue;
            minimumArea = area;
            Vector3D origin = boundingRect.getOrigin();
            origin.setTo(this.getVertex(i));
            d.setTo(u);
            d.multiply(uMin);
            origin.add(d);
            d.setTo(v);
            d.multiply(vMin);
            origin.add(d);
            boundingRect.getDirectionU().setTo(u);
            boundingRect.getDirectionV().setTo(v);
            boundingRect.setWidth(uMax - uMin);
            boundingRect.setHeight(vMax - vMin);
        }
        return boundingRect;
    }
}

