/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.test;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.thenesis.planetino2.bsp2D.BSPRenderer;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.bsp2D.BSPTreeBuilderWithPortals;
import org.thenesis.planetino2.bsp2D.MapLoader;
import org.thenesis.planetino2.engine.shooter3D.ShooterCore;
import org.thenesis.planetino2.game.CollisionDetection;
import org.thenesis.planetino2.game.CollisionDetectionWithSliding;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.game.GameObjectRenderer;
import org.thenesis.planetino2.game.GridGameObjectManager;
import org.thenesis.planetino2.game.Player;
import org.thenesis.planetino2.graphics.Color;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.input.InputManager;
import org.thenesis.planetino2.math3D.PointLight3D;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.path.AStarSearchWithBSP;
import org.thenesis.planetino2.path.PathBot;

public class PathFindingTest
extends ShooterCore {
    protected BSPTree bspTree;
    protected CollisionDetection collisionDetection;
    protected String defaultMap;

    public PathFindingTest(Screen screen, InputManager inputManager) {
        super(screen, inputManager);
        this.inputManager = inputManager;
    }

    public PathFindingTest(Screen screen, InputManager inputManager, String defaultMap) {
        this(screen, inputManager);
        this.defaultMap = defaultMap;
    }

    public void createPolygons() {
        Graphics g = this.screen.getGraphics();
        g.setColor(Color.BLACK.getRGB());
        g.fillRect(0, 0, this.screen.getWidth(), this.screen.getHeight());
        g.setColor(Color.WHITE.getRGB());
        int fontHeight = Font.getDefaultFont().getHeight();
        g.drawString("Loading...", 5, this.screen.getHeight() - fontHeight, 20);
        this.screen.update();
        float ambientLightIntensity = 0.2f;
        Vector<PointLight3D> lights = new Vector<PointLight3D>();
        lights.addElement(new PointLight3D(-100.0f, 100.0f, 100.0f, 0.3f, -1.0f));
        lights.addElement(new PointLight3D(100.0f, 100.0f, 0.0f, 0.3f, -1.0f));
        MapLoader loader = new MapLoader(new BSPTreeBuilderWithPortals());
        loader.setObjectLights(lights, ambientLightIntensity);
        try {
            if (this.defaultMap == null) {
                this.defaultMap = "sample2.map";
            }
            this.bspTree = loader.loadMap("/res/", this.defaultMap);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.collisionDetection = new CollisionDetectionWithSliding(this.bspTree);
        this.gameObjectManager = new GridGameObjectManager(this.bspTree.calcBounds(), this.collisionDetection);
        this.gameObjectManager.addPlayer(new Player());
        ((BSPRenderer)this.polygonRenderer).setGameObjectManager(this.gameObjectManager);
        this.createGameObjects(loader.getObjectsInMap());
        Transform3D start = loader.getPlayerStartLocation();
        this.gameObjectManager.getPlayer().getTransform().setTo(start);
    }

    protected void createGameObjects(Vector mapObjects) {
        AStarSearchWithBSP pathFinder = new AStarSearchWithBSP(this.bspTree);
        Enumeration i = mapObjects.elements();
        while (i.hasMoreElements()) {
            PolygonGroup group = (PolygonGroup)i.nextElement();
            String filename = group.getFilename();
            if ("aggressivebot.obj3d".equals(filename)) {
                PathBot bot = new PathBot(group);
                bot.setPathFinder(pathFinder);
                this.gameObjectManager.add(bot);
                continue;
            }
            this.gameObjectManager.add(new GameObject(group));
        }
    }

    public void drawPolygons(Graphics g) {
        this.polygonRenderer.startFrame(this.screen);
        ((BSPRenderer)this.polygonRenderer).draw(g, this.bspTree);
        this.gameObjectManager.draw(g, (GameObjectRenderer)((Object)this.polygonRenderer));
        this.polygonRenderer.endFrame(this.screen);
    }
}

