/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.ai;

import org.thenesis.planetino2.ai.Brain;
import org.thenesis.planetino2.ai.Projectile;
import org.thenesis.planetino2.ai.pattern.AimPattern;
import org.thenesis.planetino2.game.CollisionDetection;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.game.MessageQueue;
import org.thenesis.planetino2.game.Physics;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.path.PathBot;
import org.thenesis.planetino2.path.PathFinder;
import org.thenesis.planetino2.util.MoreMath;

public class AIBot
extends PathBot {
    public static final int NORMAL_STATE_IDLE = 0;
    public static final int NORMAL_STATE_PATROL = 1;
    public static final int NORMAL_STATE_CHASE = 2;
    public static final int BATTLE_STATE_ATTACK = 3;
    public static final int BATTLE_STATE_DODGE = 4;
    public static final int BATTLE_STATE_RUN_AWAY = 5;
    public static final int WOUNDED_STATE_HURT = 6;
    public static final int WOUNDED_STATE_DEAD = 7;
    public static final int DECESION_READY = 9;
    private static final float DEFAULT_MAX_HEALTH = 100.0f;
    private static final float CRITICAL_HEALTH_PERCENT = 5.0f;
    private float maxHealth;
    private float health;
    private int aiState;
    private long elapsedTimeInState;
    private long elapsedTimeSinceDecision;
    private long timeSincePlayerLastSeen;
    private Vector3D startLocation;
    private boolean isRegenerating;
    private PolygonGroup blastModel;
    private CollisionDetection collisionDetection;
    protected Brain brain;
    private boolean lastVisible;

    public AIBot(PolygonGroup polygonGroup, CollisionDetection collisionDetection, Brain brain, PolygonGroup blastModel) {
        super(polygonGroup);
        this.collisionDetection = collisionDetection;
        this.brain = brain;
        this.blastModel = blastModel;
        this.elapsedTimeSinceDecision = MoreMath.random((int)brain.decisionTime);
        this.maxHealth = 100.0f;
        this.setHealth(this.maxHealth);
        this.aiState = 0;
        this.timeSincePlayerLastSeen = 10000L;
    }

    public float getHealth() {
        return this.health;
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    protected void setHealth(float health) {
        this.health = health;
    }

    public void addHealth(float amount) {
        if (amount < 0.0f) {
            if (this.health <= 0.0f || this.aiState == 6) {
                return;
            }
            MessageQueue.getInstance().debug(this.getName() + " hit");
            this.setAiState(6, null);
            this.elapsedTimeSinceDecision = this.brain.decisionTime - 3000L;
        }
        this.setHealth(this.health + amount);
    }

    public boolean isCriticalHealth() {
        return this.health / this.maxHealth < 0.05f;
    }

    public int getAiState() {
        return this.aiState;
    }

    protected void setAiState(int aiState, GameObject player) {
        if (this.aiState == aiState) {
            return;
        }
        this.aiState = aiState;
        this.elapsedTimeInState = 0L;
        PathFinder lastPattern = this.pathFinder;
        Vector3D playerLocation = null;
        if (player != null) {
            playerLocation = player.getLocation();
        }
        switch (aiState) {
            case 0: 
            case 1: {
                this.setPathFinder(this.brain.idlePathFinder);
                this.setFacing(null);
                break;
            }
            case 2: {
                this.setPathFinder(this.brain.chasePathFinder);
                this.setFacing(null);
                break;
            }
            case 3: {
                this.setPathFinder(this.brain.attackPathFinder);
                this.setFacing(playerLocation);
                break;
            }
            case 4: {
                this.setPathFinder(this.brain.dodgePathFinder);
                this.setFacing(null);
                break;
            }
            case 5: {
                this.setPathFinder(this.brain.runAwayPathFinder);
                this.setFacing(null);
                break;
            }
            case 6: {
                this.setPathFinder(null);
                this.setFacing(null);
                this.getTransform().stop();
                this.getTransform().setAngleVelocityY(MoreMath.random(0.001f, 0.05f), MoreMath.random(100, 500));
                break;
            }
            case 7: {
                this.setPathFinder(null);
                this.setFacing(null);
                this.setJumping(true);
                this.getTransform().stop();
                Physics.getInstance().jumpToHeight(this, 16.0f);
                this.getTransform().setAngleVelocityY(MoreMath.random(0.001f, 0.05f), MoreMath.random(100, 500));
                break;
            }
            default: {
                this.setPathFinder(null);
                this.setFacing(null);
                this.getTransform().stop();
            }
        }
        if (lastPattern != this.pathFinder) {
            MessageQueue.getInstance().debug(this.getName() + " pattern: " + this.pathFinder);
        }
    }

    public boolean isRegenerating() {
        return this.isRegenerating;
    }

    public void setRegenerating(boolean isRegenerating) {
        this.isRegenerating = isRegenerating;
    }

    public void setPathFinder(PathFinder pathFinder) {
        if (this.pathFinder != pathFinder) {
            super.setPathFinder(pathFinder);
            this.timeUntilPathRecalc = 0L;
        }
    }

    protected void regenerate() {
        this.setHealth(this.maxHealth);
        this.setState(1);
        this.setAiState(9, null);
        this.getLocation().setTo(this.startLocation);
        this.getTransform().stop();
        this.setJumping(false);
        this.setPathFinder(null);
        this.setFacing(null);
        this.lastVisible = false;
        this.timeSincePlayerLastSeen = 10000L;
        this.addSpawn(this);
    }

    public void update(GameObject player, long elapsedTime) {
        this.updateHelper(player, elapsedTime);
        super.update(player, elapsedTime);
    }

    public void updateHelper(GameObject player, long elapsedTime) {
        this.elapsedTimeSinceDecision += elapsedTime;
        this.elapsedTimeInState += elapsedTime;
        this.timeSincePlayerLastSeen += elapsedTime;
        if (this.startLocation == null) {
            this.startLocation = new Vector3D(this.getLocation());
        }
        if (this.aiState == 7) {
            if (this.elapsedTimeInState >= 5000L) {
                if (this.isRegenerating()) {
                    this.regenerate();
                } else {
                    this.setState(2);
                }
            }
            return;
        }
        if (this.aiState == 6) {
            if (this.elapsedTimeInState >= 500L) {
                if (this.health <= 0.0f) {
                    this.setAiState(7, player);
                    return;
                }
                this.aiState = 9;
            } else {
                return;
            }
        }
        if (this.isCriticalHealth() && this.brain.runAwayPathFinder != null) {
            this.setAiState(5, player);
            return;
        }
        if ((this.aiState == 0 || this.aiState == 1) && this.elapsedTimeInState >= 500L) {
            this.aiState = 9;
        } else if (this.elapsedTimeSinceDecision >= this.brain.decisionTime) {
            this.aiState = 9;
        } else if (this.currentPath != null && !this.currentPath.hasMoreElements() && !this.getTransform().isMovingIgnoreY()) {
            this.aiState = 9;
        }
        if (this.aiState == 9) {
            this.elapsedTimeSinceDecision = 0L;
            if (this.canSee(player)) {
                this.setAiState(this.chooseBattleState(), player);
            } else if (this.timeSincePlayerLastSeen < 3000L || this.canHear(player)) {
                this.setAiState(2, player);
            } else {
                this.setAiState(0, player);
            }
        } else if (this.aiState == 3 && this.elapsedTimeInState >= this.brain.aimTime && this.brain.aimPathFinder != null) {
            this.elapsedTimeInState -= this.brain.aimTime;
            float p = Math.min(1.0f, (float)this.brain.aimTime / 2000.0f);
            ((AimPattern)this.brain.aimPathFinder).setAccuracy(p);
            Vector3D direction = (Vector3D)this.brain.aimPathFinder.find(this, player).nextElement();
            this.fireProjectile(direction);
        }
    }

    public void fireProjectile(Vector3D direction) {
        Projectile blast = new Projectile((PolygonGroup)this.blastModel.clone(), direction, this, 3, 6);
        float dist = 2.0f * (this.getBounds().getRadius() + blast.getBounds().getRadius());
        blast.getLocation().setTo(this.getX() + direction.x * dist, this.getY() + this.getBounds().getTopHeight() / 2.0f, this.getZ() + direction.z * dist);
        this.addSpawn(blast);
        this.makeNoise(500L);
    }

    public int chooseBattleState() {
        float p = MoreMath.random();
        if (p <= this.brain.attackProbability) {
            return 3;
        }
        if (p <= this.brain.attackProbability + this.brain.dodgeProbability) {
            return 4;
        }
        return 5;
    }

    public boolean canSee(GameObject object) {
        boolean visible;
        boolean bl = visible = this.collisionDetection.getFirstWallIntersection(this.getX(), this.getZ(), object.getX(), object.getZ(), this.getY(), this.getY() + 1.0f) == null;
        if (visible) {
            this.timeSincePlayerLastSeen = 0L;
        }
        if (visible != this.lastVisible) {
            String message = visible ? " sees " : " no longer sees ";
            MessageQueue.getInstance().debug(this.getName() + message + object.getName());
            this.lastVisible = visible;
        }
        return visible;
    }

    public boolean canHear(GameObject object) {
        float hearDistSq;
        boolean heard;
        if (!object.isMakingNoise() || this.brain.hearDistance == 0.0f) {
            return false;
        }
        float distSq = this.getLocation().getDistanceSq(object.getLocation());
        boolean bl = heard = distSq <= (hearDistSq = this.brain.hearDistance * this.brain.hearDistance);
        if (heard) {
            MessageQueue.getInstance().debug(this.getName() + " hears " + object.getName());
        }
        return heard;
    }

    public boolean isFlying() {
        return super.isFlying() && this.aiState != 7;
    }

    public void notifyEndOfPath() {
        if (this.aiState != 3) {
            this.setAiState(9, null);
        }
    }

    public void notifyHitPlayer(long damage) {
    }

    public void notifyWallCollision() {
        if (this.aiState == 5) {
            this.getTransform().setVelocity(new Vector3D(0.0f, 0.0f, 0.0f));
            this.setAiState(9, null);
        } else {
            super.notifyWallCollision();
        }
    }
}

