/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.ai;

import java.util.Vector;
import org.thenesis.planetino2.ai.Brain;
import org.thenesis.planetino2.ai.pattern.AimPattern;
import org.thenesis.planetino2.ai.pattern.AttackPatternRush;
import org.thenesis.planetino2.ai.pattern.AttackPatternStrafe;
import org.thenesis.planetino2.ai.pattern.DodgePatternRandom;
import org.thenesis.planetino2.ai.pattern.DodgePatternZigZag;
import org.thenesis.planetino2.ai.pattern.RunAwayPattern;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.path.AStarSearchWithBSP;
import org.thenesis.planetino2.path.PathFinder;
import org.thenesis.planetino2.util.Comparable;
import org.thenesis.planetino2.util.MoreMath;
import org.thenesis.planetino2.util.QSortAlgorithm;

public class EvolutionGenePool {
    private static final int NUM_TOP_BRAINS = 5;
    private static final int NUM_TOTAL_BRAINS = 10;
    private Vector brains;
    private Vector attackPathFinders = new Vector();
    private Vector aimPathFinders;
    private Vector dodgePathFinders;
    private Vector idlePathFinders;
    private Vector chasePathFinders;
    private Vector runAwayPathFinders;

    public EvolutionGenePool(BSPTree bspTree) {
        this.attackPathFinders.addElement(new AttackPatternRush(bspTree));
        this.attackPathFinders.addElement(new AttackPatternStrafe(bspTree));
        this.aimPathFinders = new Vector();
        this.aimPathFinders.addElement(new AimPattern(bspTree));
        this.dodgePathFinders = new Vector();
        this.dodgePathFinders.addElement(new DodgePatternZigZag(bspTree));
        this.dodgePathFinders.addElement(new DodgePatternRandom(bspTree));
        this.idlePathFinders = new Vector();
        this.chasePathFinders = new Vector();
        this.chasePathFinders.addElement(new AStarSearchWithBSP(bspTree));
        this.runAwayPathFinders = new Vector();
        this.runAwayPathFinders.addElement(new RunAwayPattern(bspTree));
        this.brains = new Vector();
        for (int i = 0; i < 10; ++i) {
            BrainStat brain = new BrainStat();
            brain.mutate(1.0f);
            this.brains.addElement(brain);
        }
    }

    public void setBSPTree(BSPTree bspTree) {
        ((AStarSearchWithBSP)this.chasePathFinders.elementAt(0)).setBSPTree(bspTree);
    }

    public void resetEvolution() {
        this.brains.removeAllElements();
    }

    public Brain getNewBrain() {
        if (MoreMath.chance(0.5f)) {
            BrainStat brain = (BrainStat)this.getRandomTopBrain().clone();
            float p = MoreMath.random(0.1f, 0.25f);
            brain.mutate(p);
            return brain;
        }
        return this.getRandomTopBrain();
    }

    public Brain getRandomTopBrain() {
        int index = MoreMath.random(4);
        return (Brain)this.brains.elementAt(index);
    }

    public void notifyDead(Brain brain, long damageCaused) {
        if (brain instanceof BrainStat) {
            BrainStat stat = (BrainStat)brain;
            stat.report(damageCaused);
            if (!this.brains.contains(stat)) {
                this.brains.addElement(stat);
            }
            QSortAlgorithm.sort(this.brains);
            while (this.brains.size() > 10) {
                this.brains.removeElementAt(10);
            }
        }
    }

    public String toString() {
        String retVal = "Top 5 Brains:\n";
        for (int i = 0; i < 5; ++i) {
            retVal = retVal + (i + 1) + ".\n";
            retVal = retVal + this.brains.elementAt(i) + "\n";
        }
        return retVal;
    }

    private class BrainStat
    extends Brain
    implements Comparable {
        long totalDamageCaused;
        int numBots;
        int generation;

        public BrainStat() {
        }

        public BrainStat(BrainStat brain) {
            super(brain);
            this.generation = brain.generation;
        }

        public float getAverageDamageCaused() {
            if (this.numBots == 0) {
                return 0.0f;
            }
            return (float)this.totalDamageCaused / (float)this.numBots;
        }

        public void report(long damageCaused) {
            this.totalDamageCaused += damageCaused;
            ++this.numBots;
        }

        public int compareTo(Object obj) {
            BrainStat other = (BrainStat)obj;
            float thisScore = this.getAverageDamageCaused();
            float otherScore = other.getAverageDamageCaused();
            if (thisScore == 0.0f && otherScore == 0.0f) {
                return this.numBots - other.numBots;
            }
            return MoreMath.sign(otherScore - thisScore);
        }

        public void mutate(float mutationProbability) {
            if (MoreMath.chance(mutationProbability)) {
                this.attackProbability = MoreMath.random();
            }
            if (MoreMath.chance(mutationProbability)) {
                this.dodgeProbability = MoreMath.random();
            }
            if (MoreMath.chance(mutationProbability)) {
                this.runAwayProbability = MoreMath.random();
            }
            if (MoreMath.chance(mutationProbability)) {
                this.decisionTime = MoreMath.random(3000, 6000);
            }
            if (MoreMath.chance(mutationProbability)) {
                this.aimTime = MoreMath.random(300, 2000);
            }
            if (MoreMath.chance(mutationProbability)) {
                this.hearDistance = MoreMath.random(50, 2000);
            }
            if (MoreMath.chance(mutationProbability)) {
                this.attackPathFinder = (PathFinder)MoreMath.random(EvolutionGenePool.this.attackPathFinders);
            }
            if (MoreMath.chance(mutationProbability)) {
                this.dodgePathFinder = (PathFinder)MoreMath.random(EvolutionGenePool.this.dodgePathFinders);
            }
            if (MoreMath.chance(mutationProbability)) {
                this.aimPathFinder = (PathFinder)MoreMath.random(EvolutionGenePool.this.aimPathFinders);
            }
            if (MoreMath.chance(mutationProbability)) {
                this.idlePathFinder = (PathFinder)MoreMath.random(EvolutionGenePool.this.idlePathFinders);
            }
            if (MoreMath.chance(mutationProbability)) {
                this.chasePathFinder = (PathFinder)MoreMath.random(EvolutionGenePool.this.chasePathFinders);
            }
            if (MoreMath.chance(mutationProbability)) {
                this.runAwayPathFinder = (PathFinder)MoreMath.random(EvolutionGenePool.this.runAwayPathFinders);
            }
            this.fixProbabilites();
        }

        public Object clone() {
            BrainStat brain = new BrainStat(this);
            ++brain.generation;
            return brain;
        }

        public String toString() {
            if (this.numBots == 0) {
                return "(Not Used)\n" + super.toString();
            }
            return "Average damage per bot: " + this.getAverageDamageCaused() + " " + "(" + this.numBots + " bots)\n" + "Generation: " + this.generation + "\n" + super.toString();
        }
    }
}

