/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.ai;

import org.thenesis.planetino2.ai.AIBot;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.game.Player;
import org.thenesis.planetino2.math3D.MovingTransform3D;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.util.MoreMath;

public class Projectile
extends GameObject {
    private static final long DIE_TIME = 5000L;
    private static final float SPEED = 1.5f;
    private static final float ROT_SPEED = 0.008f;
    private MovingTransform3D transform;
    private long aliveTime;
    private AIBot sourceBot;
    private int minDamage;
    private int maxDamage;

    public Projectile(PolygonGroup polygonGroup, Vector3D direction, AIBot sourceBot, int minDamage, int maxDamage) {
        super(polygonGroup);
        this.sourceBot = sourceBot;
        this.minDamage = minDamage;
        this.maxDamage = maxDamage;
        this.transform = this.getTransform();
        Vector3D velocity = this.transform.getVelocity();
        velocity.setTo(direction);
        velocity.multiply(1.5f);
        this.transform.setVelocity(velocity);
        this.transform.setAngleVelocityY(0.008f);
        this.transform.setAngleVelocityZ(0.008f);
        this.setState(1);
    }

    public void update(GameObject player, long elapsedTime) {
        this.aliveTime += elapsedTime;
        if (this.aliveTime >= 5000L) {
            this.setState(2);
        } else {
            super.update(player, elapsedTime);
        }
    }

    public boolean isFlying() {
        return true;
    }

    public void notifyObjectCollision(GameObject object) {
        if (object instanceof Player) {
            int healthLost = MoreMath.random(this.minDamage, this.maxDamage);
            ((Player)object).addHealth(-healthLost);
            if (this.sourceBot != null) {
                this.sourceBot.notifyHitPlayer(healthLost);
            }
        } else if (object instanceof AIBot) {
            int healthLost = MoreMath.random(this.minDamage, this.maxDamage);
            ((AIBot)object).addHealth(-healthLost);
        }
        this.setState(2);
    }

    public void notifyWallCollision() {
        this.getTransform().stop();
        this.setState(2);
    }

    public void notifyFloorCollision() {
        this.notifyWallCollision();
    }

    public void notifyCeilingCollision() {
        this.notifyWallCollision();
    }
}

