/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.ai.pattern;

import java.util.Enumeration;
import java.util.Vector;
import org.thenesis.planetino2.ai.pattern.AIPattern;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.util.MoreMath;

public class DodgePatternZigZag
extends AIPattern {
    private float dodgeDist;

    public DodgePatternZigZag(BSPTree tree) {
        this(tree, 200.0f);
    }

    public DodgePatternZigZag(BSPTree tree, float dodgeDist) {
        super(tree);
        this.dodgeDist = dodgeDist;
    }

    public Enumeration find(GameObject bot, GameObject player) {
        Vector3D zig = new Vector3D(bot.getLocation());
        zig.subtract(player.getLocation());
        zig.normalize();
        zig.multiply(this.dodgeDist);
        zig.rotateY(1.5707964f);
        if (MoreMath.chance(0.5f)) {
            zig.multiply(-1.0f);
        }
        zig.add(bot.getLocation());
        this.calcFloorHeight(zig, bot.getFloorHeight());
        Vector3D zag = new Vector3D(bot.getLocation());
        this.calcFloorHeight(zag, bot.getFloorHeight());
        Vector<Vector3D> path = new Vector<Vector3D>();
        path.addElement(zig);
        path.addElement(zag);
        return path.elements();
    }
}

