/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.bsp2D;

import java.util.Vector;
import org.thenesis.planetino2.bsp2D.BSPLine;
import org.thenesis.planetino2.bsp2D.BSPPolygon;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.bsp2D.BSPTreeBuilder;
import org.thenesis.planetino2.bsp2D.Portal;
import org.thenesis.planetino2.math3D.Polygon3D;
import org.thenesis.planetino2.math3D.Vector3D;

public class BSPTreeBuilderWithPortals
extends BSPTreeBuilder {
    public BSPTree build(Vector polygons) {
        super.build(polygons);
        this.findPortalsOfLeaves(this.currentTree.getRoot());
        return this.currentTree;
    }

    protected void findPortalsOfLeaves(BSPTree.Node node) {
        if (node instanceof BSPTree.Leaf) {
            this.findPortals((BSPTree.Leaf)node);
        } else {
            this.findPortalsOfLeaves(node.front);
            this.findPortalsOfLeaves(node.back);
        }
    }

    protected void findPortals(BSPTree.Leaf leaf) {
        Vector<BSPLine> lines = new Vector<BSPLine>();
        leaf.portals = new Vector();
        for (int i = 0; i < leaf.polygons.size(); ++i) {
            Polygon3D poly = (Polygon3D)leaf.polygons.elementAt(i);
            for (int j = 0; j < poly.getNumVertices(); ++j) {
                int next = (j + 1) % poly.getNumVertices();
                Vector3D v1 = poly.getVertex(j);
                Vector3D v2 = poly.getVertex(next);
                BSPLine line = new BSPLine(v1.x, v1.z, v2.x, v2.z);
                boolean checked = false;
                for (int k = 0; !checked && k < lines.size(); ++k) {
                    if (!line.equalsIgnoreOrder((BSPLine)lines.elementAt(k))) continue;
                    checked = true;
                }
                if (checked) continue;
                lines.addElement(line);
                Portal portal = this.createPortal(line);
                if (portal == null) continue;
                leaf.portals.addElement(portal);
            }
        }
        leaf.portals.trimToSize();
    }

    protected Portal createPortal(BSPLine line) {
        BSPTree.Node node = this.currentTree.getCollinearNode(line);
        if (node != null && node.polygons != null) {
            for (int i = 0; i < node.polygons.size(); ++i) {
                BSPPolygon poly = (BSPPolygon)node.polygons.elementAt(i);
                if (!poly.isSolidWall() || !line.equalsIgnoreOrder(poly.getLine())) continue;
                return null;
            }
        }
        BSPTree.Leaf frontLeaf = this.currentTree.getFrontLeaf(line);
        BSPTree.Leaf backLeaf = this.currentTree.getBackLeaf(line);
        if (frontLeaf != null && backLeaf != null && frontLeaf != backLeaf && frontLeaf.bounds != null && backLeaf.bounds != null) {
            return new Portal(line, frontLeaf, backLeaf);
        }
        return null;
    }
}

