/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.bsp2D;

import org.thenesis.planetino2.bsp2D.Line2D;
import org.thenesis.planetino2.bsp2D.Point2D;
import org.thenesis.planetino2.bsp2D.RectangularShape;

public abstract class Rectangle2D
extends RectangularShape {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;

    protected Rectangle2D() {
    }

    public abstract void setRect(double var1, double var3, double var5, double var7);

    public void setRect(Rectangle2D r) {
        this.setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        double x = this.getX();
        double y = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        if (x1 >= x && x1 <= x + w && y1 >= y && y1 <= y + h) {
            return true;
        }
        if (x2 >= x && x2 <= x + w && y2 >= y && y2 <= y + h) {
            return true;
        }
        double x3 = x + w;
        double y3 = y + h;
        return Line2D.linesIntersect(x1, y1, x2, y2, x, y, x, y3) || Line2D.linesIntersect(x1, y1, x2, y2, x, y3, x3, y3) || Line2D.linesIntersect(x1, y1, x2, y2, x3, y3, x3, y) || Line2D.linesIntersect(x1, y1, x2, y2, x3, y, x, y);
    }

    public boolean intersectsLine(Line2D l) {
        return this.intersectsLine(l.getX1(), l.getY1(), l.getX2(), l.getY2());
    }

    public abstract int outcode(double var1, double var3);

    public int outcode(Point2D p) {
        return this.outcode(p.getX(), p.getY());
    }

    public void setFrame(double x, double y, double w, double h) {
        this.setRect(x, y, w, h);
    }

    public boolean contains(double x, double y) {
        double mx = this.getX();
        double my = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        return w > 0.0 && h > 0.0 && x >= mx && x < mx + w && y >= my && y < my + h;
    }

    public boolean intersects(double x, double y, double w, double h) {
        double mx = this.getX();
        double my = this.getY();
        double mw = this.getWidth();
        double mh = this.getHeight();
        return w > 0.0 && h > 0.0 && mw > 0.0 && mh > 0.0 && x < mx + mw && x + w > mx && y < my + mh && y + h > my;
    }

    public boolean contains(double x, double y, double w, double h) {
        double mx = this.getX();
        double my = this.getY();
        double mw = this.getWidth();
        double mh = this.getHeight();
        return w > 0.0 && h > 0.0 && mw > 0.0 && mh > 0.0 && x >= mx && x + w <= mx + mw && y >= my && y + h <= my + mh;
    }

    public abstract Rectangle2D createIntersection(Rectangle2D var1);

    public static void intersect(Rectangle2D src1, Rectangle2D src2, Rectangle2D dest) {
        double x = Math.max(src1.getX(), src2.getX());
        double y = Math.max(src1.getY(), src2.getY());
        double maxx = Math.min(src1.getMaxX(), src2.getMaxX());
        double maxy = Math.min(src1.getMaxY(), src2.getMaxY());
        dest.setRect(x, y, maxx - x, maxy - y);
    }

    public abstract Rectangle2D createUnion(Rectangle2D var1);

    public static void union(Rectangle2D src1, Rectangle2D src2, Rectangle2D dest) {
        double x = Math.min(src1.getX(), src2.getX());
        double y = Math.min(src1.getY(), src2.getY());
        double maxx = Math.max(src1.getMaxX(), src2.getMaxX());
        double maxy = Math.max(src1.getMaxY(), src2.getMaxY());
        dest.setRect(x, y, maxx - x, maxy - y);
    }

    public void add(double newx, double newy) {
        double minx = Math.min(this.getX(), newx);
        double maxx = Math.max(this.getMaxX(), newx);
        double miny = Math.min(this.getY(), newy);
        double maxy = Math.max(this.getMaxY(), newy);
        this.setRect(minx, miny, maxx - minx, maxy - miny);
    }

    public void add(Point2D p) {
        this.add(p.getX(), p.getY());
    }

    public void add(Rectangle2D r) {
        Rectangle2D.union(this, r, this);
    }

    public int hashCode() {
        long l = java.lang.Double.doubleToLongBits(this.getX()) + 37L * java.lang.Double.doubleToLongBits(this.getY()) + 43L * java.lang.Double.doubleToLongBits(this.getWidth()) + 47L * java.lang.Double.doubleToLongBits(this.getHeight());
        return (int)(l >> 32 ^ l);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rectangle2D)) {
            return false;
        }
        Rectangle2D r = (Rectangle2D)obj;
        return r.getX() == this.getX() && r.getY() == this.getY() && r.getWidth() == this.getWidth() && r.getHeight() == this.getHeight();
    }

    public static class Float
    extends Rectangle2D {
        public float x;
        public float y;
        public float width;
        public float height;

        public Float() {
        }

        public Float(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }

        Float(double x, double y, double w, double h) {
            this.x = (float)x;
            this.y = (float)y;
            this.width = (float)w;
            this.height = (float)h;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRect(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }

        public void setRect(double x, double y, double w, double h) {
            this.x = (float)x;
            this.y = (float)y;
            this.width = (float)w;
            this.height = (float)h;
        }

        public void setRect(Rectangle2D r) {
            this.x = (float)r.getX();
            this.y = (float)r.getY();
            this.width = (float)r.getWidth();
            this.height = (float)r.getHeight();
        }

        public int outcode(double x, double y) {
            int result = 0;
            if (this.width <= 0.0f) {
                result |= 5;
            } else if (x < (double)this.x) {
                result |= 1;
            } else if (x > (double)(this.x + this.width)) {
                result |= 4;
            }
            if (this.height <= 0.0f) {
                result |= 0xA;
            } else if (y < (double)this.y) {
                result |= 2;
            } else if (y > (double)(this.y + this.height)) {
                result |= 8;
            }
            return result;
        }

        public Rectangle2D getBounds2D() {
            return new Float(this.x, this.y, this.width, this.height);
        }

        public Rectangle2D createIntersection(Rectangle2D r) {
            Float res = new Float();
            Float.intersect(this, r, res);
            return res;
        }

        public Rectangle2D createUnion(Rectangle2D r) {
            Float res = new Float();
            Float.union(this, r, res);
            return res;
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + ']';
        }
    }

    public static class Double
    extends Rectangle2D {
        public double x;
        public double y;
        public double width;
        public double height;

        public Double() {
        }

        public Double(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setRect(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }

        public void setRect(Rectangle2D r) {
            this.x = r.getX();
            this.y = r.getY();
            this.width = r.getWidth();
            this.height = r.getHeight();
        }

        public int outcode(double x, double y) {
            int result = 0;
            if (this.width <= 0.0) {
                result |= 5;
            } else if (x < this.x) {
                result |= 1;
            } else if (x > this.x + this.width) {
                result |= 4;
            }
            if (this.height <= 0.0) {
                result |= 0xA;
            } else if (y < this.y) {
                result |= 2;
            } else if (y > this.y + this.height) {
                result |= 8;
            }
            return result;
        }

        public Rectangle2D getBounds2D() {
            return new Double(this.x, this.y, this.width, this.height);
        }

        public Rectangle2D createIntersection(Rectangle2D r) {
            Double res = new Double();
            Double.intersect(this, r, res);
            return res;
        }

        public Rectangle2D createUnion(Rectangle2D r) {
            Double res = new Double();
            Double.union(this, r, res);
            return res;
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + ']';
        }
    }
}

