/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.demo;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.thenesis.planetino2.ai.AIBot;
import org.thenesis.planetino2.ai.Brain;
import org.thenesis.planetino2.ai.pattern.AimPattern;
import org.thenesis.planetino2.ai.pattern.AttackPatternRush;
import org.thenesis.planetino2.ai.pattern.AttackPatternStrafe;
import org.thenesis.planetino2.ai.pattern.DodgePatternRandom;
import org.thenesis.planetino2.ai.pattern.DodgePatternZigZag;
import org.thenesis.planetino2.ai.pattern.RunAwayPattern;
import org.thenesis.planetino2.bsp2D.BSPRenderer;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.bsp2D.BSPTreeBuilderWithPortals;
import org.thenesis.planetino2.bsp2D.MapLoader;
import org.thenesis.planetino2.engine.shooter3D.Bot;
import org.thenesis.planetino2.engine.shooter3D.HeadsUpDisplay;
import org.thenesis.planetino2.engine.shooter3D.ShooterCore;
import org.thenesis.planetino2.game.CollisionDetection;
import org.thenesis.planetino2.game.CollisionDetectionWithSliding;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.game.GameObjectRenderer;
import org.thenesis.planetino2.game.GridGameObjectManager;
import org.thenesis.planetino2.game.MessageQueue;
import org.thenesis.planetino2.game.Player;
import org.thenesis.planetino2.graphics.Color;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.input.InputManager;
import org.thenesis.planetino2.math3D.MovingTransform3D;
import org.thenesis.planetino2.math3D.PointLight3D;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.path.AStarSearchWithBSP;

public class DemoEngine
extends ShooterCore {
    private Brain averageBrain;
    private Brain aggressiveBrain;
    private Brain scaredBrain;
    protected BSPTree bspTree;
    protected String mapFile;
    protected CollisionDetection collisionDetection;

    public DemoEngine(Screen screen, InputManager inputManager) {
        super(screen, inputManager);
        this.inputManager = inputManager;
    }

    public void createPolygons() {
        Graphics g = this.screen.getGraphics();
        g.setColor(Color.BLACK.getRGB());
        g.fillRect(0, 0, this.screen.getWidth(), this.screen.getHeight());
        g.setColor(Color.WHITE.getRGB());
        int fontHeight = Font.getDefaultFont().getHeight();
        g.drawString("Loading...", 5, this.screen.getHeight() - fontHeight, 20);
        this.screen.update();
        float ambientLightIntensity = 0.2f;
        Vector<PointLight3D> lights = new Vector<PointLight3D>();
        lights.addElement(new PointLight3D(-100.0f, 100.0f, 100.0f, 0.3f, -1.0f));
        lights.addElement(new PointLight3D(100.0f, 100.0f, 0.0f, 0.3f, -1.0f));
        MapLoader loader = new MapLoader(new BSPTreeBuilderWithPortals());
        loader.setObjectLights(lights, ambientLightIntensity);
        try {
            this.bspTree = loader.loadMap("/res/", "quake.map");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.collisionDetection = new CollisionDetectionWithSliding(this.bspTree);
        this.gameObjectManager = new GridGameObjectManager(this.bspTree.calcBounds(), this.collisionDetection);
        this.gameObjectManager.addPlayer(new Player());
        ((BSPRenderer)this.polygonRenderer).setGameObjectManager(this.gameObjectManager);
        this.createGameObjects(loader.getObjectsInMap());
        Transform3D start = loader.getPlayerStartLocation();
        this.gameObjectManager.getPlayer().getTransform().setTo(start);
    }

    private void createGameObjects(Vector mapObjects) {
        Player player = (Player)this.gameObjectManager.getPlayer();
        player.setHealth(100.0f);
        this.drawInstructions = false;
        MessageQueue queue = MessageQueue.getInstance();
        this.addOverlay(queue);
        this.addOverlay(new HeadsUpDisplay(player));
        queue.setDebug(false);
        this.createBrains();
        Enumeration i = mapObjects.elements();
        while (i.hasMoreElements()) {
            MovingTransform3D mainTransform;
            PolygonGroup group = (PolygonGroup)i.nextElement();
            String filename = group.getFilename();
            if ("robot.obj3d".equals(filename)) {
                this.gameObjectManager.add(new Bot(group));
                continue;
            }
            if ("averagebot.obj3d".equals(filename)) {
                AIBot bot = new AIBot(group, this.collisionDetection, this.averageBrain, this.botProjectileModel);
                this.gameObjectManager.add(bot);
                bot.setFlyHeight(48.0f);
                continue;
            }
            if ("aggressivebot.obj3d".equals(filename)) {
                AIBot bot = new AIBot(group, this.collisionDetection, this.aggressiveBrain, this.botProjectileModel);
                this.gameObjectManager.add(bot);
                continue;
            }
            if ("scaredybot.obj3d".equals(filename)) {
                AIBot bot = new AIBot(group, this.collisionDetection, this.scaredBrain, this.botProjectileModel);
                this.gameObjectManager.add(bot);
                continue;
            }
            if ("cacao-cube.obj3d".equals(filename) || "linuxtag-cube.obj3d".equals(filename)) {
                float angleVelocity = 0.001f;
                mainTransform = group.getTransform();
                mainTransform.setAngleVelocityY(angleVelocity);
                mainTransform.setAngleVelocityX(angleVelocity);
                mainTransform.rotateAngleY(50.0f);
                mainTransform.rotateAngleX(50.0f);
                this.gameObjectManager.add(new GameObject(group));
                continue;
            }
            if ("classpath-cube.obj3d".equals(filename)) {
                float angleVelocity = 0.001f;
                mainTransform = group.getTransform();
                mainTransform.setAngleVelocityY(angleVelocity);
                mainTransform.setAngleVelocityX(angleVelocity);
                mainTransform.rotateAngleY(50.0f);
                mainTransform.rotateAngleX(50.0f);
                this.gameObjectManager.add(new GameObject(group));
                continue;
            }
            this.gameObjectManager.add(new GameObject(group));
        }
    }

    public void drawPolygons(Graphics g) {
        this.polygonRenderer.startFrame(this.screen);
        ((BSPRenderer)this.polygonRenderer).draw(g, this.bspTree);
        this.gameObjectManager.draw(g, (GameObjectRenderer)((Object)this.polygonRenderer));
        this.polygonRenderer.endFrame(this.screen);
    }

    protected void createBrains() {
        this.averageBrain = new Brain();
        this.averageBrain.attackPathFinder = new AttackPatternRush(this.bspTree);
        this.averageBrain.aimPathFinder = new AimPattern(this.bspTree);
        this.averageBrain.dodgePathFinder = new DodgePatternRandom(this.bspTree);
        this.averageBrain.idlePathFinder = null;
        this.averageBrain.chasePathFinder = new AStarSearchWithBSP(this.bspTree);
        this.averageBrain.runAwayPathFinder = new RunAwayPattern(this.bspTree);
        this.averageBrain.attackProbability = 0.5f;
        this.averageBrain.dodgeProbability = 0.4f;
        this.averageBrain.runAwayProbability = 0.1f;
        this.averageBrain.decisionTime = 4000L;
        this.averageBrain.aimTime = 1000L;
        this.averageBrain.hearDistance = 1000.0f;
        this.aggressiveBrain = new Brain();
        this.aggressiveBrain.attackPathFinder = new AttackPatternStrafe(this.bspTree);
        this.aggressiveBrain.aimPathFinder = new AimPattern(this.bspTree);
        this.aggressiveBrain.dodgePathFinder = new DodgePatternZigZag(this.bspTree);
        this.aggressiveBrain.idlePathFinder = null;
        this.aggressiveBrain.chasePathFinder = new AStarSearchWithBSP(this.bspTree);
        this.aggressiveBrain.runAwayPathFinder = null;
        this.aggressiveBrain.attackProbability = 0.8f;
        this.aggressiveBrain.dodgeProbability = 0.2f;
        this.aggressiveBrain.runAwayProbability = 0.0f;
        this.aggressiveBrain.decisionTime = 2000L;
        this.aggressiveBrain.aimTime = 300L;
        this.aggressiveBrain.hearDistance = 1000.0f;
        this.scaredBrain = new Brain();
        this.scaredBrain.attackPathFinder = new AttackPatternRush(this.bspTree);
        this.scaredBrain.aimPathFinder = new AimPattern(this.bspTree);
        this.scaredBrain.dodgePathFinder = new DodgePatternZigZag(this.bspTree);
        this.scaredBrain.idlePathFinder = null;
        this.scaredBrain.chasePathFinder = new AStarSearchWithBSP(this.bspTree);
        this.scaredBrain.runAwayPathFinder = new RunAwayPattern(this.bspTree);
        this.scaredBrain.attackProbability = 0.2f;
        this.scaredBrain.dodgeProbability = 0.4f;
        this.scaredBrain.runAwayProbability = 0.4f;
        this.scaredBrain.decisionTime = 4000L;
        this.scaredBrain.aimTime = 1000L;
        this.scaredBrain.hearDistance = 2000.0f;
    }
}

