/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.game;

import org.thenesis.planetino2.bsp2D.BSPPolygon;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.game.CollisionDetection;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.game.Physics;
import org.thenesis.planetino2.math3D.PolygonGroupBounds;
import org.thenesis.planetino2.math3D.Vector3D;

public class CollisionDetectionWithSliding
extends CollisionDetection {
    private Vector3D scratch = new Vector3D();
    private Vector3D originalLocation = new Vector3D();

    public CollisionDetectionWithSliding(BSPTree bspTree) {
        super(bspTree);
    }

    public BSPPolygon checkWalls(GameObject object, Vector3D oldLocation, long elapsedTime) {
        float goalX = object.getX();
        float goalZ = object.getZ();
        BSPPolygon wall = super.checkWalls(object, oldLocation, elapsedTime);
        if (wall != null && object.getTransform().isMoving()) {
            float actualX = object.getX();
            float actualZ = object.getZ();
            this.scratch.setTo(actualX, 0.0f, actualZ);
            this.scratch.subtract(goalX, 0.0f, goalZ);
            float length = this.scratch.getDotProduct(wall.getNormal());
            float slideX = goalX + length * wall.getNormal().x;
            float slideZ = goalZ + length * wall.getNormal().z;
            object.getLocation().setTo(slideX, object.getY(), slideZ);
            this.originalLocation.setTo(oldLocation);
            oldLocation.setTo(actualX, oldLocation.y, actualZ);
            PolygonGroupBounds bounds = object.getBounds();
            float originalRadius = bounds.getRadius();
            bounds.setRadius(originalRadius - 1.0f);
            BSPPolygon wall2 = super.checkWalls(object, oldLocation, elapsedTime);
            oldLocation.setTo(this.originalLocation);
            bounds.setRadius(originalRadius);
            if (wall2 != null) {
                object.getLocation().setTo(actualX, object.getY(), actualZ);
                return wall2;
            }
        }
        return wall;
    }

    protected void checkFloorAndCeiling(GameObject object, long elapsedTime) {
        float floorHeight = object.getFloorHeight();
        float ceilHeight = object.getCeilHeight();
        float bottomHeight = object.getBounds().getBottomHeight();
        float topHeight = object.getBounds().getTopHeight();
        Vector3D v = object.getTransform().getVelocity();
        Physics physics = Physics.getInstance();
        if (object.getY() + bottomHeight == floorHeight) {
            if (v.y < 0.0f) {
                v.y = 0.0f;
            }
        } else if (object.getY() + bottomHeight < floorHeight) {
            if (!object.isFlying()) {
                if (v.y < 0.0f) {
                    object.notifyFloorCollision();
                    v.y = 0.0f;
                    object.getLocation().y = floorHeight - bottomHeight;
                } else if (!object.isJumping()) {
                    physics.scootUp(object, elapsedTime);
                }
            } else {
                object.notifyFloorCollision();
                v.y = 0.0f;
                object.getLocation().y = floorHeight - bottomHeight;
            }
        } else if (object.getY() + topHeight > ceilHeight) {
            object.notifyCeilingCollision();
            if (v.y > 0.0f) {
                v.y = 0.0f;
            }
            object.getLocation().y = ceilHeight - topHeight;
            if (!object.isFlying()) {
                physics.applyGravity(object, elapsedTime);
            }
        } else if (!object.isFlying()) {
            if (v.y > 0.0f && !object.isJumping()) {
                v.y = 0.0f;
                object.getLocation().y = floorHeight - bottomHeight;
            } else {
                physics.applyGravity(object, elapsedTime);
            }
        }
    }

    protected boolean handleObjectCollision(GameObject objectA, GameObject objectB, float distSq, float minDistSq, Vector3D oldLocation) {
        float objectBTop;
        objectA.notifyObjectCollision(objectB);
        if (objectA.isFlying()) {
            return true;
        }
        float stepSize = objectA.getBounds().getTopHeight() / 6.0f;
        Vector3D velocity = objectA.getTransform().getVelocity();
        float objectABottom = objectA.getY() + objectA.getBounds().getBottomHeight();
        if (objectABottom + stepSize > (objectBTop = objectB.getY() + objectB.getBounds().getTopHeight()) && objectBTop + objectA.getBounds().getTopHeight() < objectA.getCeilHeight()) {
            objectA.getLocation().y = objectBTop - objectA.getBounds().getBottomHeight();
            if (velocity.y < 0.0f) {
                objectA.setJumping(false);
                velocity.y = -0.01f;
            }
            return false;
        }
        if (objectA.getX() != oldLocation.x || objectA.getZ() != oldLocation.z) {
            float slideDistFactor = (float)Math.sqrt(minDistSq / distSq) - 1.0f;
            this.scratch.setTo(objectA.getX(), 0.0f, objectA.getZ());
            this.scratch.subtract(objectB.getX(), 0.0f, objectB.getZ());
            this.scratch.multiply(slideDistFactor);
            objectA.getLocation().add(this.scratch);
            return super.checkWalls(objectA, oldLocation, 0L) != null;
        }
        return true;
    }
}

