/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.game;

import java.util.Vector;
import org.thenesis.planetino2.math3D.MovingTransform3D;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.PolygonGroupBounds;
import org.thenesis.planetino2.math3D.Vector3D;

public class GameObject {
    protected static final int STATE_IDLE = 0;
    protected static final int STATE_ACTIVE = 1;
    protected static final int STATE_DESTROYED = 2;
    private PolygonGroup polygonGroup;
    private PolygonGroupBounds bounds;
    private int state;
    private boolean isJumping;
    private float floorHeight;
    private float ceilHeight;
    private Vector spawns;
    private long noiseDuration;

    public GameObject(PolygonGroup polygonGroup) {
        this.polygonGroup = polygonGroup;
        this.bounds = new PolygonGroupBounds(polygonGroup);
        this.state = 0;
    }

    public Vector3D getLocation() {
        return this.polygonGroup.getTransform().getLocation();
    }

    public MovingTransform3D getTransform() {
        return this.polygonGroup.getTransform();
    }

    public PolygonGroup getPolygonGroup() {
        return this.polygonGroup;
    }

    public PolygonGroupBounds getBounds() {
        return this.bounds;
    }

    public float getX() {
        return this.getLocation().x;
    }

    public float getY() {
        return this.getLocation().y;
    }

    public float getZ() {
        return this.getLocation().z;
    }

    public void setFloorHeight(float floorHeight) {
        this.floorHeight = floorHeight;
    }

    public void setCeilHeight(float ceilHeight) {
        this.ceilHeight = ceilHeight;
    }

    public float getFloorHeight() {
        return this.floorHeight;
    }

    public float getCeilHeight() {
        return this.ceilHeight;
    }

    protected void setState(int state) {
        this.state = state;
    }

    protected void setState(GameObject object, int state) {
        object.setState(state);
    }

    public boolean isFlying() {
        return false;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setJumping(boolean b) {
        this.isJumping = b;
    }

    public boolean isIdle() {
        return this.state == 0;
    }

    public boolean isActive() {
        return this.state == 1;
    }

    public boolean isDestroyed() {
        return this.state == 2;
    }

    public void update(GameObject player, long elapsedTime) {
        if (this.isActive()) {
            this.polygonGroup.update(elapsedTime);
        }
    }

    public void notifyVisible(boolean visible) {
        if (visible && this.isIdle()) {
            this.state = 1;
        }
    }

    public void notifyObjectCollision(GameObject otherObject) {
    }

    public void notifyFloorCollision() {
    }

    public void notifyCeilingCollision() {
    }

    public void notifyWallCollision() {
    }

    public String getName() {
        return this.polygonGroup.getName();
    }

    protected void addSpawn(GameObject object) {
        if (this.spawns == null) {
            this.spawns = new Vector();
        }
        this.spawns.addElement(object);
    }

    public Vector getSpawns() {
        Vector returnList = this.spawns;
        this.spawns = null;
        return returnList;
    }

    public boolean isMakingNoise() {
        return this.noiseDuration > 0L;
    }

    public void makeNoise(long duration) {
        if (this.noiseDuration < duration) {
            this.noiseDuration = duration;
        }
    }
}

