/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.game;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import org.thenesis.planetino2.game.CollisionDetection;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.game.GameObjectManager;
import org.thenesis.planetino2.game.GameObjectRenderer;
import org.thenesis.planetino2.math3D.Rectangle;
import org.thenesis.planetino2.math3D.Vector3D;

public class GridGameObjectManager
implements GameObjectManager {
    private static final int GRID_SIZE_BITS = 9;
    private static final int GRID_SIZE = 512;
    private Cell[] grid;
    private Rectangle mapBounds;
    private int gridWidth;
    private int gridHeight;
    private Vector allObjects;
    private Vector spawnedObjects;
    private GameObject player;
    private Vector3D oldLocation;
    private CollisionDetection collisionDetection;

    public GridGameObjectManager(Rectangle mapBounds, CollisionDetection collisionDetection) {
        this.mapBounds = mapBounds;
        this.collisionDetection = collisionDetection;
        this.gridWidth = (mapBounds.width >> 9) + 1;
        this.gridHeight = (mapBounds.height >> 9) + 1;
        this.grid = new Cell[this.gridWidth * this.gridHeight];
        for (int i = 0; i < this.grid.length; ++i) {
            this.grid[i] = new Cell();
        }
        this.allObjects = new Vector();
        this.spawnedObjects = new Vector();
        this.oldLocation = new Vector3D();
    }

    private int convertMapXtoGridX(int x) {
        return x - this.mapBounds.x >> 9;
    }

    private int convertMapYtoGridY(int y) {
        return y - this.mapBounds.y >> 9;
    }

    public void markAllVisible() {
        for (int i = 0; i < this.grid.length; ++i) {
            this.grid[i].visible = true;
        }
    }

    public void markVisible(Rectangle bounds) {
        int x1 = Math.max(0, this.convertMapXtoGridX(bounds.x));
        int y1 = Math.max(0, this.convertMapYtoGridY(bounds.y));
        int x2 = Math.min(this.gridWidth - 1, this.convertMapXtoGridX(bounds.x + bounds.width));
        int y2 = Math.min(this.gridHeight - 1, this.convertMapYtoGridY(bounds.y + bounds.height));
        for (int y = y1; y <= y2; ++y) {
            int offset = y * this.gridWidth;
            for (int x = x1; x <= x2; ++x) {
                this.grid[offset + x].visible = true;
            }
        }
    }

    public void add(GameObject object) {
        if (object != null) {
            if (object == this.player) {
                this.allObjects.insertElementAt(object, 0);
            } else {
                this.allObjects.addElement(object);
            }
            Cell cell = this.getCell(object);
            if (cell != null) {
                cell.objects.addElement(object);
            }
        }
    }

    public void remove(GameObject object) {
        if (object != null) {
            this.allObjects.removeElement(object);
            Cell cell = this.getCell(object);
            if (cell != null) {
                cell.objects.removeElement(object);
            }
        }
    }

    public void addPlayer(GameObject player) {
        this.player = player;
        if (player != null) {
            player.notifyVisible(true);
            this.add(player);
        }
    }

    public GameObject getPlayer() {
        return this.player;
    }

    private Cell getCell(GameObject object) {
        int x = this.convertMapXtoGridX((int)object.getX());
        int y = this.convertMapYtoGridY((int)object.getZ());
        return this.getCell(x, y);
    }

    private Cell getCell(int x, int y) {
        if (x < 0 || y < 0 || x >= this.gridWidth || y >= this.gridHeight) {
            return null;
        }
        return this.grid[x + y * this.gridWidth];
    }

    public void update(long elapsedTime) {
        int i;
        for (i = 0; i < this.allObjects.size(); ++i) {
            Cell cell;
            GameObject object = (GameObject)this.allObjects.elementAt(i);
            Cell oldCell = this.getCell(object);
            this.oldLocation.setTo(object.getLocation());
            boolean isRegenerating = false;
            object.update(this.player, elapsedTime);
            Vector spawns = object.getSpawns();
            if (spawns != null) {
                if (spawns.contains(object)) {
                    isRegenerating = true;
                }
                Enumeration e = spawns.elements();
                while (e.hasMoreElements()) {
                    this.spawnedObjects.addElement(e.nextElement());
                }
            }
            if (object.isDestroyed() || isRegenerating) {
                this.allObjects.removeElementAt(i);
                --i;
                if (oldCell == null) continue;
                oldCell.objects.removeElement(object);
                continue;
            }
            if (object.getLocation().equals(this.oldLocation) && !object.isJumping()) continue;
            this.collisionDetection.checkBSP(object, this.oldLocation, elapsedTime);
            if (this.checkObjectCollision(object, this.oldLocation)) {
                object.getLocation().setTo(this.oldLocation);
            }
            if ((cell = this.getCell(object)) == oldCell) continue;
            if (oldCell != null) {
                oldCell.objects.removeElement(object);
            }
            if (cell == null) continue;
            cell.objects.addElement(object);
        }
        if (this.spawnedObjects.size() > 0) {
            for (i = 0; i < this.spawnedObjects.size(); ++i) {
                this.add((GameObject)this.spawnedObjects.elementAt(i));
            }
            this.spawnedObjects.removeAllElements();
        }
    }

    public boolean checkObjectCollision(GameObject object, Vector3D oldLocation) {
        boolean collision = false;
        int x = this.convertMapXtoGridX((int)object.getX());
        int y = this.convertMapYtoGridY((int)object.getZ());
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = y - 1; j <= y + 1; ++j) {
                Cell cell = this.getCell(i, j);
                if (cell == null) continue;
                collision |= this.collisionDetection.checkObject(object, cell.objects, oldLocation);
            }
        }
        return collision;
    }

    public void draw(Graphics g, GameObjectRenderer r) {
        for (int i = 0; i < this.grid.length; ++i) {
            Vector objects = this.grid[i].objects;
            for (int j = 0; j < objects.size(); ++j) {
                GameObject object = (GameObject)objects.elementAt(j);
                boolean visible = false;
                if (this.grid[i].visible) {
                    visible = r.draw(g, object);
                }
                if (object == this.player) continue;
                object.notifyVisible(visible);
            }
            this.grid[i].visible = false;
        }
    }

    private static class Cell {
        Vector objects = new Vector();
        boolean visible = false;

        Cell() {
        }
    }
}

