/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.graphics;

public class Color {
    public static final Color white;
    public static final Color WHITE;
    public static final Color lightGray;
    public static final Color LIGHT_GRAY;
    public static final Color gray;
    public static final Color GRAY;
    public static final Color darkGray;
    public static final Color DARK_GRAY;
    public static final Color black;
    public static final Color BLACK;
    public static final Color red;
    public static final Color RED;
    public static final Color pink;
    public static final Color PINK;
    public static final Color orange;
    public static final Color ORANGE;
    public static final Color yellow;
    public static final Color YELLOW;
    public static final Color green;
    public static final Color GREEN;
    public static final Color magenta;
    public static final Color MAGENTA;
    public static final Color cyan;
    public static final Color CYAN;
    public static final Color blue;
    public static final Color BLUE;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    static final int ALPHA_MASK = -16777216;
    private static final float BRIGHT_SCALE = 0.7f;
    int OPAQUE = 1;
    int BITMASK = 2;
    int TRANSLUCENT = 3;
    final int value;
    private float[] frgbvalue;
    private float[] fvalue;
    private final float falpha;

    public Color(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    public Color(int red, int green, int blue, int alpha) {
        if ((red & 0xFF) != red || (green & 0xFF) != green || (blue & 0xFF) != blue || (alpha & 0xFF) != alpha) {
            throw new IllegalArgumentException("Bad RGB values red=0x" + Integer.toHexString(red) + " green=0x" + Integer.toHexString(green) + " blue=0x" + Integer.toHexString(blue) + " alpha=0x" + Integer.toHexString(alpha));
        }
        this.value = alpha << 24 | red << 16 | green << 8 | blue;
        this.falpha = 1.0f;
    }

    public Color(int value) {
        this(value, false);
    }

    public Color(int value, boolean hasalpha) {
        if (hasalpha) {
            this.falpha = (float)((value & 0xFF000000) >> 24) / 255.0f;
        } else {
            value |= 0xFF000000;
            this.falpha = 1.0f;
        }
        this.value = value;
    }

    public Color(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public Color(float red, float green, float blue, float alpha) {
        this.value = Color.convert(red, green, blue, alpha);
        this.frgbvalue = new float[]{red, green, blue};
        this.falpha = alpha;
    }

    public int getRed() {
        return (this.getRGB() & 0xFF0000) >> 16;
    }

    public int getGreen() {
        return (this.getRGB() & 0xFF00) >> 8;
    }

    public int getBlue() {
        return this.getRGB() & 0xFF;
    }

    public int getAlpha() {
        return (this.getRGB() & 0xFF000000) >>> 24;
    }

    public int getRGB() {
        return this.value;
    }

    public Color brighter() {
        int value = this.getRGB();
        int[] hues = new int[]{(value & 0xFF0000) >> 16, (value & 0xFF00) >> 8, value & 0xFF};
        if (hues[0] == 0 && hues[1] == 0 && hues[2] == 0) {
            hues[0] = 3;
            hues[1] = 3;
            hues[2] = 3;
        } else {
            for (int index = 0; index < 3; ++index) {
                if (hues[index] > 2) {
                    hues[index] = (int)Math.min(255.0f, (float)hues[index] / 0.7f);
                }
                if (hues[index] != 1 && hues[index] != 2) continue;
                hues[index] = 4;
            }
        }
        return new Color(hues[0], hues[1], hues[2], 255);
    }

    public Color darker() {
        int value = this.getRGB();
        return new Color((int)((float)((value & 0xFF0000) >> 16) * 0.7f), (int)((float)((value & 0xFF00) >> 8) * 0.7f), (int)((float)(value & 0xFF) * 0.7f), 255);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof Color && ((Color)obj).value == this.value;
    }

    public String toString() {
        return this.getClass().getName() + "[r=" + ((this.value & 0xFF0000) >> 16) + ",g=" + ((this.value & 0xFF00) >> 8) + ",b=" + (this.value & 0xFF) + ']';
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        if (saturation == 0.0f) {
            return Color.convert(brightness, brightness, brightness, 0.0f);
        }
        if (saturation < 0.0f || saturation > 1.0f || brightness < 0.0f || brightness > 1.0f) {
            throw new IllegalArgumentException();
        }
        hue -= (float)Math.floor(hue);
        int i = (int)(6.0f * hue);
        float f = 6.0f * hue - (float)i;
        float p = brightness * (1.0f - saturation);
        float q = brightness * (1.0f - saturation * f);
        float t = brightness * (1.0f - saturation * (1.0f - f));
        switch (i) {
            case 0: {
                return Color.convert(brightness, t, p, 0.0f);
            }
            case 1: {
                return Color.convert(q, brightness, p, 0.0f);
            }
            case 2: {
                return Color.convert(p, brightness, t, 0.0f);
            }
            case 3: {
                return Color.convert(p, q, brightness, 0.0f);
            }
            case 4: {
                return Color.convert(t, p, brightness, 0.0f);
            }
            case 5: {
                return Color.convert(brightness, p, q, 0.0f);
            }
        }
        throw new Error("impossible");
    }

    public static float[] RGBtoHSB(int red, int green, int blue, float[] array) {
        int max;
        int min;
        if (array == null) {
            array = new float[3];
        }
        if (red < green) {
            min = red;
            max = green;
        } else {
            min = green;
            max = red;
        }
        if (blue > max) {
            max = blue;
        } else if (blue < min) {
            min = blue;
        }
        array[2] = (float)max / 255.0f;
        array[1] = max == 0 ? 0.0f : (float)(max - min) / (float)max;
        if (array[1] == 0.0f) {
            array[0] = 0.0f;
        } else {
            float delta = (max - min) * 6;
            array[0] = red == max ? (float)(green - blue) / delta : (green == max ? 0.33333334f + (float)(blue - red) / delta : 0.6666667f + (float)(red - green) / delta);
            if (array[0] < 0.0f) {
                array[0] = array[0] + 1.0f;
            }
        }
        return array;
    }

    public static Color getHSBColor(float hue, float saturation, float brightness) {
        return new Color(Color.HSBtoRGB(hue, saturation, brightness), false);
    }

    public float[] getRGBComponents(float[] array) {
        if (array == null) {
            array = new float[4];
        }
        this.getRGBColorComponents(array);
        array[3] = this.falpha == 0.0f && this.frgbvalue == null ? (float)((this.getRGB() & 0xFF000000) >> 24) / 255.0f : this.falpha;
        return array;
    }

    public float[] getRGBColorComponents(float[] array) {
        if (array == null) {
            array = new float[3];
        } else if (array == this.frgbvalue) {
            return array;
        }
        if (this.frgbvalue == null) {
            int value = this.getRGB();
            this.frgbvalue = new float[]{(float)((value & 0xFF0000) >> 16) / 255.0f, (float)((value & 0xFF00) >> 8) / 255.0f, (float)(value & 0xFF) / 255.0f};
        }
        array[0] = this.frgbvalue[0];
        array[1] = this.frgbvalue[1];
        array[2] = this.frgbvalue[2];
        return array;
    }

    public static int convertRBG565To888(int color) {
        int r = color >> 11 & 0x1F;
        int g = color >> 5 & 0x3F;
        int b = color & 0x1F;
        return r << 19 | g << 10 | b << 3;
    }

    public static int convertRBG888To565(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return r >> 3 << 11 | g >> 2 << 5 | b >> 3;
    }

    public static int convertRBG232To888(int color) {
        int r = color >> 5 & 3;
        int g = color >> 2 & 7;
        int b = color & 3;
        return r << 22 | g << 13 | b << 6;
    }

    public static int convertRBG888To232(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return r >> 6 << 5 | g >> 5 << 2 | b >> 6;
    }

    public int getTransparency() {
        int alpha = this.getRGB() & 0xFF000000;
        return alpha == -16777216 ? this.OPAQUE : (alpha == 0 ? this.BITMASK : this.TRANSLUCENT);
    }

    private static int convert(float red, float green, float blue, float alpha) {
        if (red < 0.0f || red > 1.0f || green < 0.0f || green > 1.0f || blue < 0.0f || blue > 1.0f || alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("Bad RGB values");
        }
        int redval = (int)Math.floor(255.0f * red + 0.5f);
        int greenval = (int)Math.floor(255.0f * green + 0.5f);
        int blueval = (int)Math.floor(255.0f * blue + 0.5f);
        int alphaval = (int)Math.floor(255.0f * alpha + 0.5f);
        return alphaval << 24 | redval << 16 | greenval << 8 | blueval;
    }

    static {
        WHITE = white = new Color(0xFFFFFF, false);
        LIGHT_GRAY = lightGray = new Color(0xC0C0C0, false);
        GRAY = gray = new Color(0x808080, false);
        DARK_GRAY = darkGray = new Color(0x404040, false);
        BLACK = black = new Color(0, false);
        RED = red = new Color(0xFF0000, false);
        PINK = pink = new Color(0xFFAFAF, false);
        ORANGE = orange = new Color(16762880, false);
        YELLOW = yellow = new Color(0xFFFF00, false);
        GREEN = green = new Color(65280, false);
        MAGENTA = magenta = new Color(0xFF00FF, false);
        CYAN = cyan = new Color(65535, false);
        BLUE = blue = new Color(255, false);
    }
}

