/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.math3D;

import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.util.MoreMath;

public class Transform3D {
    protected Vector3D location;
    private float cosAngleX;
    private float sinAngleX;
    private float cosAngleY;
    private float sinAngleY;
    private float cosAngleZ;
    private float sinAngleZ;

    public Transform3D() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Transform3D(float x, float y, float z) {
        this.location = new Vector3D(x, y, z);
        this.setAngle(0.0f, 0.0f, 0.0f);
    }

    public Transform3D(Transform3D v) {
        this.location = new Vector3D();
        this.setTo(v);
    }

    public Object clone() {
        return new Transform3D(this);
    }

    public void setTo(Transform3D v) {
        this.location.setTo(v.location);
        this.cosAngleX = v.cosAngleX;
        this.sinAngleX = v.sinAngleX;
        this.cosAngleY = v.cosAngleY;
        this.sinAngleY = v.sinAngleY;
        this.cosAngleZ = v.cosAngleZ;
        this.sinAngleZ = v.sinAngleZ;
    }

    public Vector3D getLocation() {
        return this.location;
    }

    public float getCosAngleX() {
        return this.cosAngleX;
    }

    public float getSinAngleX() {
        return this.sinAngleX;
    }

    public float getCosAngleY() {
        return this.cosAngleY;
    }

    public float getSinAngleY() {
        return this.sinAngleY;
    }

    public float getCosAngleZ() {
        return this.cosAngleZ;
    }

    public float getSinAngleZ() {
        return this.sinAngleZ;
    }

    public float getAngleX() {
        return (float)MoreMath.atan2(this.sinAngleX, this.cosAngleX);
    }

    public float getAngleY() {
        return (float)MoreMath.atan2(this.sinAngleY, this.cosAngleY);
    }

    public float getAngleZ() {
        return (float)MoreMath.atan2(this.sinAngleZ, this.cosAngleZ);
    }

    public void setAngleX(float angleX) {
        this.cosAngleX = (float)Math.cos(angleX);
        this.sinAngleX = (float)Math.sin(angleX);
    }

    public void setAngleY(float angleY) {
        this.cosAngleY = (float)Math.cos(angleY);
        this.sinAngleY = (float)Math.sin(angleY);
    }

    public void setAngleZ(float angleZ) {
        this.cosAngleZ = (float)Math.cos(angleZ);
        this.sinAngleZ = (float)Math.sin(angleZ);
    }

    public void setAngle(float angleX, float angleY, float angleZ) {
        this.setAngleX(angleX);
        this.setAngleY(angleY);
        this.setAngleZ(angleZ);
    }

    public void rotateAngleX(float angle) {
        if (angle != 0.0f) {
            this.setAngleX(this.getAngleX() + angle);
        }
    }

    public void rotateAngleY(float angle) {
        if (angle != 0.0f) {
            this.setAngleY(this.getAngleY() + angle);
        }
    }

    public void rotateAngleZ(float angle) {
        if (angle != 0.0f) {
            this.setAngleZ(this.getAngleZ() + angle);
        }
    }

    public void rotateAngle(float angleX, float angleY, float angleZ) {
        this.rotateAngleX(angleX);
        this.rotateAngleY(angleY);
        this.rotateAngleZ(angleZ);
    }
}

