/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.path;

import java.util.Enumeration;
import java.util.Vector;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.bsp2D.Portal;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.path.AStarNode;
import org.thenesis.planetino2.path.AStarSearch;
import org.thenesis.planetino2.path.PathFinder;

public class AStarSearchWithBSP
extends AStarSearch
implements PathFinder {
    private BSPTree bspTree;

    public AStarSearchWithBSP(BSPTree bspTree) {
        this.setBSPTree(bspTree);
    }

    public void setBSPTree(BSPTree bspTree) {
        this.bspTree = bspTree;
    }

    public Enumeration find(GameObject a, GameObject b) {
        return this.find(a.getLocation(), b.getLocation());
    }

    public Enumeration find(Vector3D start, Vector3D goal) {
        BSPTree.Leaf goalLeaf;
        BSPTree.Leaf startLeaf = this.bspTree.getLeaf(start.x, start.z);
        if (startLeaf == (goalLeaf = this.bspTree.getLeaf(goal.x, goal.z))) {
            Vector<Vector3D> v = new Vector<Vector3D>();
            v.addElement(goal);
            return v.elements();
        }
        LeafNode startNode = new LeafNode(startLeaf, start);
        LeafNode goalNode = new LeafNode(goalLeaf, goal);
        Vector goalNeighbors = ((AStarNode)goalNode).getNeighbors();
        for (int i = 0; i < goalNeighbors.size(); ++i) {
            Portal portal = (Portal)goalNeighbors.elementAt(i);
            portal.addNeighbor(goalNode);
        }
        Vector path = super.findPath(startNode, goalNode);
        for (int i = 0; i < goalNeighbors.size(); ++i) {
            Portal portal = (Portal)goalNeighbors.elementAt(i);
            portal.removeNeighbor(goalNode);
        }
        return this.convertPath(path);
    }

    protected Enumeration convertPath(Vector path) {
        if (path == null) {
            return null;
        }
        for (int i = 0; i < path.size(); ++i) {
            Object node = path.elementAt(i);
            if (node instanceof Portal) {
                path.setElementAt(((Portal)node).getMidPoint(), i);
                continue;
            }
            path.setElementAt(((LeafNode)node).location, i);
        }
        Vector v = new Vector();
        Enumeration e = path.elements();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        return v.elements();
    }

    public String toString() {
        return "AStarSearchWithBSP";
    }

    public static class LeafNode
    extends AStarNode {
        BSPTree.Leaf leaf;
        Vector3D location;

        public LeafNode(BSPTree.Leaf leaf, Vector3D location) {
            this.leaf = leaf;
            this.location = location;
        }

        public float getCost(AStarNode node) {
            return this.getEstimatedCost(node);
        }

        public float getEstimatedCost(AStarNode node) {
            float otherZ;
            float otherX;
            AStarNode other;
            if (node instanceof Portal) {
                other = (Portal)node;
                otherX = ((Portal)other).getMidPoint().x;
                otherZ = ((Portal)other).getMidPoint().z;
            } else {
                other = (LeafNode)node;
                otherX = ((LeafNode)other).location.x;
                otherZ = ((LeafNode)other).location.z;
            }
            float dx = this.location.x - otherX;
            float dz = this.location.z - otherZ;
            return (float)Math.sqrt(dx * dx + dz * dz);
        }

        public Vector getNeighbors() {
            return this.leaf.portals;
        }
    }
}

