/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.test;

import java.util.Enumeration;
import java.util.Vector;
import org.thenesis.planetino2.ai.EvolutionBot;
import org.thenesis.planetino2.ai.EvolutionGenePool;
import org.thenesis.planetino2.engine.shooter3D.HeadsUpDisplay;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.game.MessageQueue;
import org.thenesis.planetino2.game.Player;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.input.InputManager;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.test.PathFindingTest;

public class EvolutionTest
extends PathFindingTest {
    private EvolutionGenePool genePool;

    public EvolutionTest(Screen screen, InputManager inputManager) {
        super(screen, inputManager, "sample3.map");
        this.inputManager = inputManager;
    }

    public void stop() {
        super.stop();
        System.out.println(this.genePool);
    }

    protected void createGameObjects(Vector mapObjects) {
        this.drawInstructions = false;
        MessageQueue queue = MessageQueue.getInstance();
        this.addOverlay(queue);
        this.addOverlay(new HeadsUpDisplay((Player)this.gameObjectManager.getPlayer()));
        queue.setDebug(false);
        queue.add("Use the mouse/arrow keys to move.");
        queue.add("Press Esc to exit.");
        this.genePool = new EvolutionGenePool(this.bspTree);
        Enumeration i = mapObjects.elements();
        while (i.hasMoreElements()) {
            PolygonGroup group = (PolygonGroup)i.nextElement();
            String filename = group.getFilename();
            if (filename != null && filename.endsWith("bot.obj3d")) {
                EvolutionBot bot = new EvolutionBot(group, this.collisionDetection, this.genePool, this.botProjectileModel);
                bot.setRegenerating(true);
                this.gameObjectManager.add(bot);
                continue;
            }
            this.gameObjectManager.add(new GameObject(group));
        }
    }
}

