/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.test;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import org.thenesis.planetino2.engine.GameCore;
import org.thenesis.planetino2.graphics.Color;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.graphics3D.PolygonRenderer;
import org.thenesis.planetino2.graphics3D.SolidPolygonRenderer;
import org.thenesis.planetino2.input.GameAction;
import org.thenesis.planetino2.input.InputManager;
import org.thenesis.planetino2.math3D.Polygon3D;
import org.thenesis.planetino2.math3D.SolidPolygon3D;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.math3D.ViewWindow;

public class Simple3DTest2
extends GameCore {
    protected PolygonRenderer polygonRenderer;
    protected ViewWindow viewWindow;
    protected Vector polygons;
    private boolean drawFrameRate = false;
    private boolean drawInstructions = true;
    private int numFrames;
    private long startTime;
    private float frameRate;
    protected InputManager inputManager;
    private GameAction exit = new GameAction("exit");
    private GameAction smallerView = new GameAction("smallerView", 1);
    private GameAction largerView = new GameAction("largerView", 1);
    private GameAction frameRateToggle = new GameAction("frameRateToggle", 1);
    private GameAction goForward = new GameAction("goForward");
    private GameAction goBackward = new GameAction("goBackward");
    private GameAction goUp = new GameAction("goUp");
    private GameAction goDown = new GameAction("goDown");
    private GameAction goLeft = new GameAction("goLeft");
    private GameAction goRight = new GameAction("goRight");
    private GameAction turnLeft = new GameAction("turnLeft");
    private GameAction turnRight = new GameAction("turnRight");
    private GameAction tiltUp = new GameAction("tiltUp");
    private GameAction tiltDown = new GameAction("tiltDown");
    private GameAction tiltLeft = new GameAction("tiltLeft");
    private GameAction tiltRight = new GameAction("tiltRight");

    public Simple3DTest2(Screen screen, InputManager inputManager) {
        super(screen);
        this.inputManager = inputManager;
    }

    public void init() {
        super.init();
        this.inputManager.mapToKey(this.goForward, 1);
        this.inputManager.mapToKey(this.goForward, 50);
        this.inputManager.mapToKey(this.goBackward, 6);
        this.inputManager.mapToKey(this.goBackward, 56);
        this.inputManager.mapToKey(this.goLeft, 2);
        this.inputManager.mapToKey(this.goLeft, 52);
        this.inputManager.mapToKey(this.goRight, 5);
        this.inputManager.mapToKey(this.goRight, 54);
        this.inputManager.mapToKey(this.goUp, 9);
        this.inputManager.mapToKey(this.goUp, 51);
        this.inputManager.mapToKey(this.goDown, 10);
        this.inputManager.mapToKey(this.goDown, 49);
        this.inputManager.mapToMouse(this.turnLeft, 0);
        this.inputManager.mapToMouse(this.turnRight, 1);
        this.inputManager.mapToMouse(this.tiltUp, 2);
        this.inputManager.mapToMouse(this.tiltDown, 3);
        this.createPolygonRenderer();
        this.polygons = new Vector();
        this.createPolygons();
    }

    public void createPolygons() {
        SolidPolygon3D poly = new SolidPolygon3D(new Vector3D(-200.0f, 0.0f, -1000.0f), new Vector3D(200.0f, 0.0f, -1000.0f), new Vector3D(200.0f, 250.0f, -1000.0f), new Vector3D(-200.0f, 250.0f, -1000.0f));
        poly.setColor(Color.WHITE);
        this.polygons.addElement(poly);
        poly = new SolidPolygon3D(new Vector3D(-200.0f, 0.0f, -1400.0f), new Vector3D(-200.0f, 250.0f, -1400.0f), new Vector3D(200.0f, 250.0f, -1400.0f), new Vector3D(200.0f, 0.0f, -1400.0f));
        poly.setColor(Color.WHITE);
        this.polygons.addElement(poly);
        poly = new SolidPolygon3D(new Vector3D(-200.0f, 0.0f, -1400.0f), new Vector3D(-200.0f, 0.0f, -1000.0f), new Vector3D(-200.0f, 250.0f, -1000.0f), new Vector3D(-200.0f, 250.0f, -1400.0f));
        poly.setColor(Color.GRAY);
        this.polygons.addElement(poly);
        poly = new SolidPolygon3D(new Vector3D(200.0f, 0.0f, -1000.0f), new Vector3D(200.0f, 0.0f, -1400.0f), new Vector3D(200.0f, 250.0f, -1400.0f), new Vector3D(200.0f, 250.0f, -1000.0f));
        poly.setColor(Color.GRAY);
        this.polygons.addElement(poly);
        poly = new SolidPolygon3D(new Vector3D(0.0f, 0.0f, -1000.0f), new Vector3D(75.0f, 0.0f, -1000.0f), new Vector3D(75.0f, 125.0f, -1000.0f), new Vector3D(0.0f, 125.0f, -1000.0f));
        poly.setColor(new Color(0x660000));
        this.polygons.addElement(poly);
        poly = new SolidPolygon3D(new Vector3D(-150.0f, 150.0f, -1000.0f), new Vector3D(-100.0f, 150.0f, -1000.0f), new Vector3D(-100.0f, 200.0f, -1000.0f), new Vector3D(-150.0f, 200.0f, -1000.0f));
        poly.setColor(new Color(0x660000));
        this.polygons.addElement(poly);
        poly = new SolidPolygon3D(new Vector3D(-200.0f, 250.0f, -1000.0f), new Vector3D(200.0f, 250.0f, -1000.0f), new Vector3D(75.0f, 400.0f, -1200.0f), new Vector3D(-75.0f, 400.0f, -1200.0f));
        poly.setColor(new Color(0x660000));
        this.polygons.addElement(poly);
        poly = new SolidPolygon3D(new Vector3D(-200.0f, 250.0f, -1400.0f), new Vector3D(-200.0f, 250.0f, -1000.0f), new Vector3D(-75.0f, 400.0f, -1200.0f));
        poly.setColor(new Color(0x330000));
        this.polygons.addElement(poly);
        poly = new SolidPolygon3D(new Vector3D(200.0f, 250.0f, -1400.0f), new Vector3D(-200.0f, 250.0f, -1400.0f), new Vector3D(-75.0f, 400.0f, -1200.0f), new Vector3D(75.0f, 400.0f, -1200.0f));
        poly.setColor(new Color(0x660000));
        this.polygons.addElement(poly);
        poly = new SolidPolygon3D(new Vector3D(200.0f, 250.0f, -1000.0f), new Vector3D(200.0f, 250.0f, -1400.0f), new Vector3D(75.0f, 400.0f, -1200.0f));
        poly.setColor(new Color(0x330000));
        this.polygons.addElement(poly);
    }

    public void createPolygonRenderer() {
        this.viewWindow = new ViewWindow(0, 0, this.screen.getWidth(), this.screen.getHeight(), (float)Math.toRadians(75.0));
        Transform3D camera = new Transform3D(0.0f, 100.0f, 0.0f);
        this.polygonRenderer = new SolidPolygonRenderer(camera, this.viewWindow);
    }

    public void setViewBounds(int width, int height) {
        width = Math.min(width, this.screen.getWidth());
        height = Math.min(height, this.screen.getHeight());
        width = Math.max(64, width);
        height = Math.max(48, height);
        this.viewWindow.setBounds((this.screen.getWidth() - width) / 2, (this.screen.getHeight() - height) / 2, width, height);
    }

    public void update(long elapsedTime) {
        if (this.exit.isPressed()) {
            this.stop();
            return;
        }
        if (this.largerView.isPressed()) {
            this.setViewBounds(this.viewWindow.getWidth() + 64, this.viewWindow.getHeight() + 48);
        } else if (this.smallerView.isPressed()) {
            this.setViewBounds(this.viewWindow.getWidth() - 64, this.viewWindow.getHeight() - 48);
        }
        if (this.frameRateToggle.isPressed()) {
            this.drawFrameRate = !this.drawFrameRate;
        }
        elapsedTime = Math.min(elapsedTime, 100L);
        float angleChange = 2.0E-4f * (float)elapsedTime;
        float distanceChange = 0.5f * (float)elapsedTime;
        Transform3D camera = this.polygonRenderer.getCamera();
        Vector3D cameraLoc = camera.getLocation();
        if (this.goForward.isPressed()) {
            cameraLoc.x -= distanceChange * camera.getSinAngleY();
            cameraLoc.z -= distanceChange * camera.getCosAngleY();
        }
        if (this.goBackward.isPressed()) {
            cameraLoc.x += distanceChange * camera.getSinAngleY();
            cameraLoc.z += distanceChange * camera.getCosAngleY();
        }
        if (this.goLeft.isPressed()) {
            cameraLoc.x -= distanceChange * camera.getCosAngleY();
            cameraLoc.z += distanceChange * camera.getSinAngleY();
        }
        if (this.goRight.isPressed()) {
            cameraLoc.x += distanceChange * camera.getCosAngleY();
            cameraLoc.z -= distanceChange * camera.getSinAngleY();
        }
        if (this.goUp.isPressed()) {
            cameraLoc.y += distanceChange;
        }
        if (this.goDown.isPressed()) {
            cameraLoc.y -= distanceChange;
        }
        int tilt = this.tiltUp.getAmount() - this.tiltDown.getAmount();
        tilt = Math.min(tilt, 200);
        tilt = Math.max(tilt, -200);
        float newAngleX = camera.getAngleX() + (float)tilt * angleChange;
        newAngleX = Math.max(newAngleX, -1.5707964f);
        newAngleX = Math.min(newAngleX, 1.5707964f);
        camera.setAngleX(newAngleX);
        int turn = this.turnLeft.getAmount() - this.turnRight.getAmount();
        turn = Math.min(turn, 200);
        turn = Math.max(turn, -200);
        camera.rotateAngleY((float)turn * angleChange);
        if (this.tiltLeft.isPressed()) {
            camera.rotateAngleZ(10.0f * angleChange);
        }
        if (this.tiltRight.isPressed()) {
            camera.rotateAngleZ(-10.0f * angleChange);
        }
    }

    public void draw(Graphics g) {
        this.polygonRenderer.startFrame(this.screen);
        for (int i = 0; i < this.polygons.size(); ++i) {
            this.polygonRenderer.draw(g, (Polygon3D)this.polygons.elementAt(i));
        }
        this.polygonRenderer.endFrame(this.screen);
        this.drawText(g);
    }

    public void drawText(Graphics g) {
    }

    public void calcFrameRate() {
        ++this.numFrames;
        long currTime = System.currentTimeMillis();
        if (currTime > this.startTime + 500L) {
            this.frameRate = (float)this.numFrames * 1000.0f / (float)(currTime - this.startTime);
            this.startTime = currTime;
            this.numFrames = 0;
        }
    }
}

