/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    private int pos;
    private final String str;
    private final int len;
    private String delim;
    private final boolean retDelims;

    public StringTokenizer(String str) {
        this(str, " \t\n\r\f", false);
    }

    public StringTokenizer(String str, String delim) {
        this(str, delim, false);
    }

    public StringTokenizer(String str, String delim, boolean returnDelims) {
        this.len = str.length();
        this.str = str;
        this.delim = delim;
        this.retDelims = returnDelims;
        this.pos = 0;
    }

    public boolean hasMoreTokens() {
        if (!this.retDelims) {
            while (this.pos < this.len && this.delim.indexOf(this.str.charAt(this.pos)) >= 0) {
                ++this.pos;
            }
        }
        return this.pos < this.len;
    }

    public String nextToken(String delim) throws NoSuchElementException {
        this.delim = delim;
        return this.nextToken();
    }

    public String nextToken() throws NoSuchElementException {
        if (this.pos < this.len && this.delim.indexOf(this.str.charAt(this.pos)) >= 0) {
            if (this.retDelims) {
                return this.str.substring(this.pos, ++this.pos);
            }
            while (++this.pos < this.len && this.delim.indexOf(this.str.charAt(this.pos)) >= 0) {
            }
        }
        if (this.pos < this.len) {
            int start = this.pos;
            while (++this.pos < this.len && this.delim.indexOf(this.str.charAt(this.pos)) < 0) {
            }
            return this.str.substring(start, this.pos);
        }
        throw new NoSuchElementException();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() throws NoSuchElementException {
        return this.nextToken();
    }

    public int countTokens() {
        int count = 0;
        int delimiterCount = 0;
        boolean tokenFound = false;
        int tmpPos = this.pos;
        while (tmpPos < this.len) {
            if (this.delim.indexOf(this.str.charAt(tmpPos++)) >= 0) {
                if (tokenFound) {
                    ++count;
                    tokenFound = false;
                }
                ++delimiterCount;
                continue;
            }
            tokenFound = true;
            while (tmpPos < this.len && this.delim.indexOf(this.str.charAt(tmpPos)) < 0) {
                ++tmpPos;
            }
        }
        if (tokenFound) {
            ++count;
        }
        return this.retDelims ? count + delimiterCount : count;
    }
}

