/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.ai.pattern;

import java.util.Enumeration;
import java.util.Vector;
import org.thenesis.planetino2.ai.pattern.AIPattern;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.util.MoreMath;

public class AimPattern
extends AIPattern {
    protected float accuracy;

    public AimPattern(BSPTree tree) {
        super(tree);
    }

    public void setAccuracy(float p) {
        this.accuracy = p;
    }

    public Enumeration find(GameObject bot, GameObject player) {
        Vector3D goal = new Vector3D(player.getLocation());
        goal.y += player.getBounds().getTopHeight() / 2.0f;
        goal.subtract(bot.getLocation());
        if (this.accuracy < 1.0f) {
            float maxAngle = 10.0f * (1.0f - this.accuracy);
            float angle = MoreMath.random(-maxAngle, maxAngle);
            goal.rotateY((float)Math.toRadians(angle));
        }
        goal.normalize();
        Vector<Vector3D> v = new Vector<Vector3D>();
        v.addElement(goal);
        return v.elements();
    }
}

