/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.ai.pattern;

import java.util.Enumeration;
import java.util.Vector;
import org.thenesis.planetino2.ai.pattern.AIPattern;
import org.thenesis.planetino2.bsp2D.BSPTree;
import org.thenesis.planetino2.game.GameObject;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.util.MoreMath;

public class AttackPatternStrafe
extends AIPattern {
    private float radiusSq;

    public AttackPatternStrafe(BSPTree tree) {
        this(tree, 250.0f);
    }

    public AttackPatternStrafe(BSPTree tree, float radius) {
        super(tree);
        this.radiusSq = radius * radius;
    }

    public Enumeration find(GameObject bot, GameObject player) {
        Vector<Vector3D> path = new Vector<Vector3D>();
        Vector3D firstGoal = this.getLocationFromPlayer(bot, player, this.radiusSq);
        if (!firstGoal.equals(bot.getLocation())) {
            path.addElement(firstGoal);
        }
        int numPoints = 8;
        float angle = (float)(Math.PI * 2 / (double)numPoints);
        if (MoreMath.chance(0.5f)) {
            angle *= -1.0f;
        }
        float lastY = bot.getFloorHeight();
        for (int i = 1; i < numPoints; ++i) {
            Vector3D goal = new Vector3D(firstGoal);
            goal.subtract(player.getLocation());
            goal.rotateY(angle * (float)i);
            goal.add(player.getLocation());
            this.calcFloorHeight(goal, lastY);
            lastY = goal.y;
            path.addElement(goal);
        }
        path.addElement(firstGoal);
        return path.elements();
    }
}

