/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.engine.shooter3D;

import java.io.IOException;
import java.util.Vector;
import org.thenesis.planetino2.bsp2D.BSPRenderer;
import org.thenesis.planetino2.engine.GameCore3D;
import org.thenesis.planetino2.game.GameObjectManager;
import org.thenesis.planetino2.game.Player;
import org.thenesis.planetino2.graphics.Screen;
import org.thenesis.planetino2.input.GameAction;
import org.thenesis.planetino2.input.InputManager;
import org.thenesis.planetino2.math3D.MovingTransform3D;
import org.thenesis.planetino2.math3D.ObjectLoader;
import org.thenesis.planetino2.math3D.PointLight3D;
import org.thenesis.planetino2.math3D.PolygonGroup;
import org.thenesis.planetino2.math3D.Transform3D;
import org.thenesis.planetino2.math3D.Vector3D;
import org.thenesis.planetino2.math3D.ViewWindow;

public abstract class ShooterCore
extends GameCore3D {
    private static final float PLAYER_SPEED = 0.5f;
    private static final float PLAYER_TURN_SPEED = 0.04f;
    private static final float CAMERA_HEIGHT = 100.0f;
    private static final float BULLET_HEIGHT = 75.0f;
    protected GameAction fire = new GameAction("fire", 1);
    protected GameAction jump = new GameAction("jump", 1);
    protected GameObjectManager gameObjectManager;
    protected PolygonGroup blastModel;
    protected PolygonGroup botProjectileModel;

    public ShooterCore(Screen screen, InputManager inputManager) {
        super(screen, inputManager);
        this.inputManager = inputManager;
    }

    public void init() {
        this.inputManager.mapToKey(this.jump, 57);
        this.inputManager.mapToKey(this.fire, 53);
        float ambientLightIntensity = 0.8f;
        Vector<PointLight3D> lights = new Vector<PointLight3D>();
        lights.addElement(new PointLight3D(-100.0f, 100.0f, 100.0f, 0.5f, -1.0f));
        lights.addElement(new PointLight3D(100.0f, 100.0f, 0.0f, 0.5f, -1.0f));
        ObjectLoader loader = new ObjectLoader();
        loader.setLights(lights, ambientLightIntensity);
        try {
            this.blastModel = loader.loadObject("/res/", "blast.obj3d");
            this.botProjectileModel = loader.loadObject("/res/", "botprojectile.obj3d");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        super.init();
        ((Player)this.gameObjectManager.getPlayer()).setBlastModel(this.blastModel);
    }

    public void createPolygonRenderer() {
        this.viewWindow = new ViewWindow(0, 0, this.screen.getWidth(), this.screen.getHeight(), (float)Math.toRadians(75.0));
        Transform3D camera = new Transform3D();
        this.polygonRenderer = new BSPRenderer(camera, this.viewWindow);
    }

    public void updateWorld(long elapsedTime) {
        elapsedTime = Math.min(elapsedTime, 100L);
        Player player = (Player)this.gameObjectManager.getPlayer();
        MovingTransform3D playerTransform = player.getTransform();
        Vector3D velocity = playerTransform.getVelocity();
        velocity.x = 0.0f;
        velocity.z = 0.0f;
        float x = -playerTransform.getSinAngleY();
        float z = -playerTransform.getCosAngleY();
        if (this.goForward.isPressed()) {
            velocity.add(x * 0.5f, 0.0f, z * 0.5f);
        }
        if (this.goBackward.isPressed()) {
            velocity.add(-x * 0.5f, 0.0f, -z * 0.5f);
        }
        if (this.goLeft.isPressed()) {
            velocity.add(z * 0.5f, 0.0f, -x * 0.5f);
        }
        if (this.goRight.isPressed()) {
            velocity.add(-z * 0.5f, 0.0f, x * 0.5f);
        }
        if (this.jump.isPressed()) {
            player.setJumping(true);
        }
        if (this.fire.isPressed()) {
            player.fireProjectile();
        }
        playerTransform.setVelocity(velocity);
        float angleVelocity = Math.min(this.tiltUp.getAmount(), 200);
        playerTransform.setAngleVelocityX((angleVelocity += (float)Math.max(-this.tiltDown.getAmount(), -200)) * 0.04f / 200.0f);
        angleVelocity = Math.min(this.turnLeft.getAmount(), 200);
        playerTransform.setAngleVelocityY((angleVelocity += (float)Math.max(-this.turnRight.getAmount(), -200)) * 0.04f / 200.0f);
        this.gameObjectManager.update(elapsedTime);
        float angleX = playerTransform.getAngleX();
        float limit = 1.5707964f;
        if (angleX < -limit) {
            playerTransform.setAngleX(-limit);
        } else if (angleX > limit) {
            playerTransform.setAngleX(limit);
        }
        Transform3D camera = this.polygonRenderer.getCamera();
        camera.setTo(playerTransform);
        camera.getLocation().add(0.0f, 100.0f, 0.0f);
    }
}

