/*
 * Decompiled with CFR 0.152.
 */
package org.thenesis.planetino2.test;

import org.thenesis.planetino2.util.MoreMath;

public class TrigTableTest {
    public static final int COUNT = 8000000;

    public static void main(String[] args) {
        long funcTime = TrigTableTest.timeFunctionTest();
        long tableTime = TrigTableTest.timeTableTest();
        System.out.println("Function time: " + funcTime);
        System.out.println("Table time: " + tableTime);
    }

    public static long timeFunctionTest() {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 8000000; ++i) {
            TrigTableTest.functionTest(i);
        }
        return System.currentTimeMillis() - startTime;
    }

    public static long timeTableTest() {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 8000000; ++i) {
            TrigTableTest.tableTest(i);
        }
        return System.currentTimeMillis() - startTime;
    }

    public static void functionTest(int i) {
        float angle = (float)i * (float)Math.PI * 2.0f / 8000000.0f;
        double cosAngle = Math.cos(angle);
        if ((i & 0xFFFF) == 0) {
            TrigTableTest.printMessage((float)cosAngle, "Cosine Function");
        }
    }

    public static void tableTest(int i) {
        float angle = (float)i * (float)Math.PI * 2.0f / 8000000.0f;
        float cosAngle = MoreMath.cos(MoreMath.angleConvert(angle));
        if ((i & 0xFFFF) == 0) {
            TrigTableTest.printMessage(cosAngle, "Cosine Table");
        }
    }

    public static void printMessage(float cosAngle, String msg) {
        int x = (int)(30.0f * (1.0f + cosAngle));
        for (int j = 0; j < x; ++j) {
            System.out.print(" ");
        }
        System.out.println(msg);
    }
}

