/*
 * Decompiled with CFR 0.152.
 */
package com.doctordrive.scrobbler;

import com.doctordrive.scrobbler.Session;
import com.doctordrive.scrobbler.Submitter;
import java.util.Hashtable;
import java.util.Vector;
import main.Main;
import main.Settings;
import main.Song;

public final class Scrobbler {
    public static void scrobble(Song song) {
        if (Main.session.online && Main.session.status || !Main.session.online) {
            String[] blacklist = Scrobbler.getBlackList();
            boolean passed = true;
            if (blacklist != null) {
                for (int i = 0; i < blacklist.length; i = (int)((short)(i + 1))) {
                    if (!song.track.equals(blacklist[i]) && !song.album.equals(blacklist[i]) && !song.artist.equals(blacklist[i])) continue;
                    passed = false;
                }
            }
            if (passed) {
                if (Main.session.online) {
                    Hashtable params;
                    if (Main.cache.isEmpty()) {
                        params = Scrobbler.getTable("track.scrobble", song);
                        params.put("timestamp", song.timestamp);
                    } else {
                        Main.cache.addElement(song);
                        params = Scrobbler.getTable("track.scrobble", Main.cache);
                    }
                    Submitter.submit(params);
                    if (Submitter.status) {
                        Main.log.write("Scrobbled: " + song.track);
                        if (!Main.cache.isEmpty()) {
                            Main.log.write("Cache scrobbled!");
                            Main.cache.removeAllElements();
                        }
                    } else {
                        Main.cache.addElement(song);
                        Main.log.write("Added to cache: " + song.track);
                    }
                } else {
                    Main.cache.addElement(song);
                    Main.log.write("Added to cache: " + song.track);
                }
            }
        }
    }

    public static void scrobble(Vector cache) {
        if (Main.session.online && Main.session.status) {
            Hashtable params = Scrobbler.getTable("track.scrobble", Main.cache);
            Submitter.submit(params);
            if (Submitter.status) {
                Main.log.write("Cache scrobbled!");
                Main.cache.removeAllElements();
            }
        }
    }

    public static void updateNowPlaying(Song song) {
        if (Settings.nowPlaying && Main.session.status && Main.session.online && !Settings.offline) {
            String[] blacklist = Scrobbler.getBlackList();
            boolean passed = true;
            if (blacklist != null) {
                for (int i = 0; i < blacklist.length; i = (int)((short)(i + 1))) {
                    if (!song.track.equals(blacklist[i]) && !song.album.equals(blacklist[i]) && !song.artist.equals(blacklist[i])) continue;
                    passed = false;
                }
            }
            if (passed) {
                Submitter.submit(Scrobbler.getTable("track.updateNowPlaying", song));
                if (Submitter.status) {
                    Main.log.write("NowPlaying: " + song.track);
                }
            }
        }
    }

    private static Hashtable getTable(String method, Song song) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("api_key", Session.api_key);
        ht.put("method", method);
        ht.put("sk", Main.session.sk);
        ht.put("album", song.album);
        ht.put("artist", song.artist);
        ht.put("track", song.track);
        return ht;
    }

    private static Hashtable getTable(String method, Vector songs) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("api_key", Session.api_key);
        ht.put("method", method);
        ht.put("sk", Main.session.sk);
        int size = songs.size() <= 50 ? (int)songs.size() : 50;
        for (int i = 0; i < size; i = (int)((short)(i + 1))) {
            ht.put("album[" + i + "]", ((Song)songs.elementAt((int)i)).album);
            ht.put("artist[" + i + "]", ((Song)songs.elementAt((int)i)).artist);
            ht.put("track[" + i + "]", ((Song)songs.elementAt((int)i)).track);
            ht.put("timestamp[" + i + "]", ((Song)songs.elementAt((int)i)).timestamp);
        }
        return ht;
    }

    private static String[] getBlackList() {
        String bl = Settings.blacklist;
        if (bl.length() > 0 && !bl.equals(" ")) {
            int num = 0;
            int pos = 0;
            while (pos < bl.length() && pos != -1) {
                ++pos;
                if ((pos = bl.indexOf(44, pos)) == -1) continue;
                num = (short)(num + 1);
            }
            String[] ret = new String[num + 1];
            int index = 0;
            int start = 0;
            pos = 0;
            while (pos < bl.length() && start < bl.length() && pos != -1) {
                ++pos;
                if ((pos = bl.indexOf(44, pos)) != -1) {
                    ret[index] = bl.substring(start, pos).trim();
                    start = pos + 1;
                    ++index;
                    continue;
                }
                ret[index] = bl.substring(start, bl.length()).trim();
            }
            return ret;
        }
        return null;
    }
}

