/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import javax.microedition.lcdui.Graphics;
import ntr.ttme.DoublePolygon;
import ntr.ttme.IntPolygon;
import ntr.ttme.Polyline;

public class SplineCurveRenderer {
    public static final int DEFAULT_NUMBER_OF_SPLINE_POINTS = 5;
    int numberOfSplinePoints;
    IntPolygon points;
    DoublePolygon worldPoints;

    public SplineCurveRenderer() {
        this(5);
    }

    public SplineCurveRenderer(int p) {
        this.numberOfSplinePoints = p;
        this.points = new IntPolygon();
        this.worldPoints = new DoublePolygon(p);
    }

    public void RawDrawSpline(Graphics g, int p0x, int p0y, int p1x, int p1y, int p2x, int p2y, int c) {
        this.calculateWorldSpline(p0x, p0y, p1x, p1y, p2x, p2y);
        this.points.npoints = 0;
        int i = 0;
        while (i < this.worldPoints.getNumberOfPoints()) {
            this.points.addPoint((int)this.worldPoints.getPointX(i), (int)this.worldPoints.getPointY(i));
            ++i;
        }
        g.setColor(c);
        Polyline.draw(g, this.points.xpoints, this.points.ypoints, this.points.npoints);
    }

    public void calculateWorldSpline(double p0x, double p0y, double p1x, double p1y, double p2x, double p2y) {
        this.worldPoints.clear();
        this.worldPoints.addPoint(p0x, p0y);
        int i = 0;
        while (i <= this.numberOfSplinePoints) {
            double progress = (double)i / (double)this.numberOfSplinePoints;
            double rest = 1.0 - progress;
            double leftSqr = rest * rest;
            double rightSqr = progress * progress;
            double m = 2.0 * progress * rest;
            this.worldPoints.addPoint(leftSqr * p0x + m * p1x + rightSqr * p2x, leftSqr * p0y + m * p1y + rightSqr * p2y);
            ++i;
        }
    }
}

